/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsListBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class GroupModInputMessageFactoryTest {
    private static final byte MESSAGE_TYPE = 15;
    private static final byte PADDING_IN_GROUP_MOD_MESSAGE = 1;
    private SerializerRegistry registry;
    private OFSerializer<GroupModInput> groupModFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.groupModFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, GroupModInput.class));
    }

    @Test
    public void testGroupModInputMessage() throws Exception {
        GroupModInputBuilder builder = new GroupModInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setCommand(GroupModCommand.forValue((int)2));
        builder.setType(GroupType.forValue((int)3));
        builder.setGroupId(new GroupId(Long.valueOf(256L)));
        List<BucketsList> exp = GroupModInputMessageFactoryTest.createBucketsList();
        builder.setBucketsList(exp);
        GroupModInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.groupModFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)15, 32);
        Assert.assertEquals((String)"Wrong command", (long)message.getCommand().getIntValue(), (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong type", (long)message.getType().getIntValue(), (long)out.readUnsignedByte());
        out.skipBytes(1);
        Assert.assertEquals((String)"Wrong groupId", (long)message.getGroupId().getValue().intValue(), (long)out.readUnsignedInt());
        List<BucketsList> rec = GroupModInputMessageFactoryTest.createBucketsListFromBufer(out);
        Assert.assertArrayEquals((String)"Wrong bucketList", (Object[])exp.toArray(), (Object[])rec.toArray());
    }

    private static List<BucketsList> createBucketsList() {
        ArrayList<BucketsList> bucketsList = new ArrayList<BucketsList>();
        BucketsListBuilder bucketsBuilder = new BucketsListBuilder();
        bucketsBuilder.setWeight(Integer.valueOf(10));
        bucketsBuilder.setWatchPort(new PortNumber(Long.valueOf(65L)));
        bucketsBuilder.setWatchGroup(Long.valueOf(22L));
        BucketsList bucket = bucketsBuilder.build();
        bucketsList.add(bucket);
        return bucketsList;
    }

    private static List<BucketsList> createBucketsListFromBufer(ByteBuf out) {
        ArrayList<BucketsList> bucketsList = new ArrayList<BucketsList>();
        BucketsListBuilder bucketsBuilder = new BucketsListBuilder();
        out.skipBytes(2);
        bucketsBuilder.setWeight(Integer.valueOf(out.readUnsignedShort()));
        bucketsBuilder.setWatchPort(new PortNumber(Long.valueOf(out.readUnsignedInt())));
        bucketsBuilder.setWatchGroup(Long.valueOf(out.readUnsignedInt()));
        out.skipBytes(4);
        BucketsList bucket = bucketsBuilder.build();
        bucketsList.add(bucket);
        return bucketsList;
    }

    @Test
    public void testGroupModInputWithNoBuckets() throws Exception {
        GroupModInputBuilder builder = new GroupModInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setCommand(GroupModCommand.forValue((int)2));
        builder.setType(GroupType.forValue((int)3));
        builder.setGroupId(new GroupId(Long.valueOf(256L)));
        GroupModInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.groupModFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)15, 16);
        Assert.assertEquals((String)"Wrong command", (long)message.getCommand().getIntValue(), (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong type", (long)message.getType().getIntValue(), (long)out.readUnsignedByte());
        out.skipBytes(1);
        Assert.assertEquals((String)"Wrong groupId", (long)message.getGroupId().getValue().intValue(), (long)out.readUnsignedInt());
        Assert.assertTrue((String)"Unexpected data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }
}

