/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.HelloElementType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello.Elements;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello.ElementsBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloInputMessageFactoryTest {
    private static final Logger LOG = LoggerFactory.getLogger(HelloInputMessageFactoryTest.class);
    private SerializerRegistry registry;
    private OFSerializer<HelloInput> helloFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.helloFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, HelloInput.class));
    }

    @Test
    public void testWithoutElementsSet() throws Exception {
        HelloInputBuilder hib = new HelloInputBuilder();
        BufferHelper.setupHeader(hib, 4);
        HelloInput hi = hib.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.helloFactory.serialize((DataContainer)hi, out);
        BufferHelper.checkHeaderV13(out, (byte)0, 8);
    }

    @Test
    public void testWith4BitVersionBitmap() throws Exception {
        int lengthOfBitmap = 4;
        HelloInputBuilder builder = new HelloInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        List<Elements> expectedElement = HelloInputMessageFactoryTest.createElement(lengthOfBitmap);
        builder.setElements(expectedElement);
        HelloInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.helloFactory.serialize((DataContainer)message, out);
        if (LOG.isDebugEnabled()) {
            LOG.debug("bytebuf: {}", (Object)ByteBufUtils.byteBufToHexString((ByteBuf)out));
        }
        BufferHelper.checkHeaderV13(out, (byte)0, 16);
        Elements element = HelloInputMessageFactoryTest.readElement(out).get(0);
        Assert.assertEquals((String)"Wrong element type", (Object)expectedElement.get(0).getType(), (Object)element.getType());
        Elements comparation = HelloInputMessageFactoryTest.createComparationElement(lengthOfBitmap).get(0);
        Assert.assertArrayEquals((String)"Wrong element bitmap", (Object[])comparation.getVersionBitmap().toArray(), (Object[])element.getVersionBitmap().toArray());
    }

    @Test
    public void testWith64BitVersionBitmap() throws Exception {
        int lengthOfBitmap = 64;
        HelloInputBuilder builder = new HelloInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        List<Elements> expectedElement = HelloInputMessageFactoryTest.createElement(lengthOfBitmap);
        builder.setElements(expectedElement);
        HelloInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.helloFactory.serialize((DataContainer)message, out);
        if (LOG.isDebugEnabled()) {
            LOG.debug("bytebuf: ", (Object)ByteBufUtils.byteBufToHexString((ByteBuf)out));
        }
        BufferHelper.checkHeaderV13(out, (byte)0, 24);
        Elements element = HelloInputMessageFactoryTest.readElement(out).get(0);
        Assert.assertEquals((String)"Wrong element type", (Object)expectedElement.get(0).getType(), (Object)element.getType());
        Elements comparation = HelloInputMessageFactoryTest.createComparationElement(lengthOfBitmap).get(0);
        Assert.assertArrayEquals((String)"Wrong element bitmap", (Object[])comparation.getVersionBitmap().toArray(), (Object[])element.getVersionBitmap().toArray());
    }

    private static List<Elements> createElement(int lengthOfBitmap) {
        ElementsBuilder elementsBuilder = new ElementsBuilder();
        ArrayList<Elements> elementsList = new ArrayList<Elements>();
        ArrayList<Boolean> booleanList = new ArrayList<Boolean>();
        for (int i = 0; i < lengthOfBitmap; ++i) {
            booleanList.add(true);
        }
        elementsBuilder.setType(HelloElementType.forValue((int)1));
        elementsBuilder.setVersionBitmap(booleanList);
        elementsList.add(elementsBuilder.build());
        return elementsList;
    }

    private static List<Elements> createComparationElement(int lengthOfBitmap) {
        int i;
        ElementsBuilder elementsBuilder = new ElementsBuilder();
        ArrayList<Elements> elementsList = new ArrayList<Elements>();
        ArrayList<Boolean> booleanList = new ArrayList<Boolean>();
        for (i = 0; i < lengthOfBitmap; ++i) {
            booleanList.add(true);
        }
        if (lengthOfBitmap % 32 != 0) {
            for (i = 0; i < 32 - lengthOfBitmap % 32; ++i) {
                booleanList.add(false);
            }
        }
        LOG.debug("boolsize {}", (Object)booleanList.size());
        elementsBuilder.setType(HelloElementType.forValue((int)1));
        elementsBuilder.setVersionBitmap(booleanList);
        elementsList.add(elementsBuilder.build());
        return elementsList;
    }

    private static List<Elements> readElement(ByteBuf input) {
        ArrayList<Elements> elementsList = new ArrayList<Elements>();
        while (input.readableBytes() > 0) {
            ElementsBuilder elementsBuilder = new ElementsBuilder();
            int type = input.readUnsignedShort();
            int elementLength = input.readUnsignedShort();
            if (type == HelloElementType.VERSIONBITMAP.getIntValue()) {
                elementsBuilder.setType(HelloElementType.forValue((int)type));
                int[] versionBitmap = new int[(elementLength - 4) / 4];
                for (int i = 0; i < versionBitmap.length; ++i) {
                    versionBitmap[i] = (int)input.readUnsignedInt();
                }
                elementsBuilder.setVersionBitmap(HelloInputMessageFactoryTest.readVersionBitmap(versionBitmap));
                int paddingRemainder = elementLength % 8;
                if (paddingRemainder != 0) {
                    input.readBytes(8 - paddingRemainder);
                }
            }
            elementsList.add(elementsBuilder.build());
        }
        return elementsList;
    }

    private static List<Boolean> readVersionBitmap(int[] input) {
        ArrayList<Boolean> versionBitmapList = new ArrayList<Boolean>();
        for (int i = 0; i < input.length; ++i) {
            int mask = input[i];
            for (int j = 0; j < 32; ++j) {
                versionBitmapList.add((mask & 1 << j) != 0);
            }
        }
        return versionBitmapList;
    }
}

