/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.MeterBand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDropCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDscpRemarkCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.drop._case.MeterBandDropBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.dscp.remark._case.MeterBandDscpRemarkBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.mod.Bands;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.mod.BandsBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class MeterModInputMessageFactoryTest {
    private SerializerRegistry registry;
    private OFSerializer<MeterModInput> meterModFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.meterModFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, MeterModInput.class));
    }

    @Test
    public void testMeterModInputMessage() throws Exception {
        MeterModInputBuilder builder = new MeterModInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setCommand(MeterModCommand.forValue((int)1));
        builder.setFlags(new MeterFlags(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setMeterId(new MeterId(Long.valueOf(2248L)));
        builder.setBands(MeterModInputMessageFactoryTest.createBandsList());
        MeterModInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.meterModFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)29, 48);
        Assert.assertEquals((String)"Wrong meterModCommand", (long)message.getCommand().getIntValue(), (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong meterFlags", (Object)message.getFlags(), (Object)MeterModInputMessageFactoryTest.decodeMeterModFlags(out.readShort()));
        Assert.assertEquals((String)"Wrong meterId", (long)message.getMeterId().getValue().intValue(), (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong bands", (Object)message.getBands(), MeterModInputMessageFactoryTest.decodeBandsList(out));
    }

    private static MeterFlags decodeMeterModFlags(short input) {
        Boolean _oFPMFKBPS = (input & 1) > 0;
        Boolean _oFPMFPKTPS = (input & 2) > 0;
        Boolean _oFPMFBURST = (input & 4) > 0;
        Boolean _oFPMFSTATS = (input & 8) > 0;
        return new MeterFlags(_oFPMFBURST, _oFPMFKBPS, _oFPMFPKTPS, _oFPMFSTATS);
    }

    private static List<Bands> createBandsList() {
        ArrayList<Bands> bandsList = new ArrayList<Bands>();
        BandsBuilder bandsBuilder = new BandsBuilder();
        MeterBandDropCaseBuilder dropCaseBuilder = new MeterBandDropCaseBuilder();
        MeterBandDropBuilder dropBand = new MeterBandDropBuilder();
        dropBand.setType(MeterBandType.OFPMBTDROP);
        dropBand.setRate(Long.valueOf(1L));
        dropBand.setBurstSize(Long.valueOf(2L));
        dropCaseBuilder.setMeterBandDrop(dropBand.build());
        bandsList.add(bandsBuilder.setMeterBand((MeterBand)dropCaseBuilder.build()).build());
        MeterBandDscpRemarkCaseBuilder dscpCaseBuilder = new MeterBandDscpRemarkCaseBuilder();
        MeterBandDscpRemarkBuilder dscpRemarkBand = new MeterBandDscpRemarkBuilder();
        dscpRemarkBand.setType(MeterBandType.OFPMBTDSCPREMARK);
        dscpRemarkBand.setRate(Long.valueOf(1L));
        dscpRemarkBand.setBurstSize(Long.valueOf(2L));
        dscpRemarkBand.setPrecLevel(Short.valueOf((short)3));
        dscpCaseBuilder.setMeterBandDscpRemark(dscpRemarkBand.build());
        bandsList.add(bandsBuilder.setMeterBand((MeterBand)dscpCaseBuilder.build()).build());
        return bandsList;
    }

    private static List<Bands> decodeBandsList(ByteBuf input) {
        ArrayList<Bands> bandsList = new ArrayList<Bands>();
        BandsBuilder bandsBuilder = new BandsBuilder();
        MeterBandDropCaseBuilder dropCaseBuilder = new MeterBandDropCaseBuilder();
        MeterBandDropBuilder dropBand = new MeterBandDropBuilder();
        dropBand.setType(MeterBandType.forValue((int)input.readUnsignedShort()));
        input.skipBytes(2);
        dropBand.setRate(Long.valueOf(input.readUnsignedInt()));
        dropBand.setBurstSize(Long.valueOf(input.readUnsignedInt()));
        input.skipBytes(4);
        dropCaseBuilder.setMeterBandDrop(dropBand.build());
        bandsList.add(bandsBuilder.setMeterBand((MeterBand)dropCaseBuilder.build()).build());
        MeterBandDscpRemarkCaseBuilder dscpCaseBuilder = new MeterBandDscpRemarkCaseBuilder();
        MeterBandDscpRemarkBuilder dscpRemarkBand = new MeterBandDscpRemarkBuilder();
        dscpRemarkBand.setType(MeterBandType.forValue((int)input.readUnsignedShort()));
        input.skipBytes(2);
        dscpRemarkBand.setRate(Long.valueOf(input.readUnsignedInt()));
        dscpRemarkBand.setBurstSize(Long.valueOf(input.readUnsignedInt()));
        dscpRemarkBand.setPrecLevel(Short.valueOf(input.readUnsignedByte()));
        input.skipBytes(3);
        dscpCaseBuilder.setMeterBandDscpRemark(dscpRemarkBand.build());
        bandsList.add(bandsBuilder.setMeterBand((MeterBand)dscpCaseBuilder.build()).build());
        return bandsList;
    }

    @Test
    public void testMeterModInputMessageWithNoBands() throws Exception {
        MeterModInputBuilder builder = new MeterModInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setCommand(MeterModCommand.forValue((int)1));
        builder.setFlags(new MeterFlags(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setMeterId(new MeterId(Long.valueOf(2248L)));
        builder.setBands(null);
        MeterModInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.meterModFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)29, 16);
        Assert.assertEquals((String)"Wrong meterModCommand", (long)message.getCommand().getIntValue(), (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong meterFlags", (Object)message.getFlags(), (Object)MeterModInputMessageFactoryTest.decodeMeterModFlags(out.readShort()));
        Assert.assertEquals((String)"Wrong meterId", (long)message.getMeterId().getValue().intValue(), (long)out.readUnsignedInt());
        Assert.assertTrue((String)"Unexpected data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }
}

