/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ActionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ActionRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.InstructionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.InstructionRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.NextTableRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.NextTableRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.OxmRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.OxmRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.table.features.properties.container.table.feature.properties.NextTableIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.table.features.properties.container.table.feature.properties.NextTableIdsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PopPbbCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PushVlanCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetNwTtlCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.output.action._case.OutputActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.push.vlan._case.PushVlanActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.nw.ttl._case.SetNwTtlActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.InstructionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ClearActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.GotoTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.MeterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.WriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.WriteMetadataCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice._goto.table._case.GotoTableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.apply.actions._case.ApplyActionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.meter._case.MeterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.write.actions._case.WriteActionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.write.metadata._case.WriteMetadataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.InstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ActionType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandTypeBitmap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableFeaturesPropType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.IpEcn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.IpProto;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.InPhyPortCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.IpEcnCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.in.phy.port._case.InPhyPortBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ip.ecn._case.IpEcnBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.MeterBand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDropCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDscpRemarkCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.drop._case.MeterBandDropBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.dscp.remark._case.MeterBandDscpRemarkBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.MultipartReplyBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyAggregateCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyFlowCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterConfigCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterConfigCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortStatsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyQueueCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.aggregate._case.MultipartReplyAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.aggregate._case.MultipartReplyAggregateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.desc._case.MultipartReplyDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.MultipartReplyFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.MultipartReplyFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.MultipartReplyGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.MultipartReplyGroupBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.GroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.GroupStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats.BucketStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats.BucketStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.MultipartReplyGroupDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.MultipartReplyGroupDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.multipart.reply.group.desc.GroupDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.multipart.reply.group.desc.GroupDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.features._case.MultipartReplyGroupFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.features._case.MultipartReplyGroupFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.MultipartReplyMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.MultipartReplyMeterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.MeterStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.MeterStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats.MeterBandStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats.MeterBandStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.MultipartReplyMeterConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.MultipartReplyMeterConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.MeterConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.MeterConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.meter.config.Bands;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.meter.config.BandsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.features._case.MultipartReplyMeterFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.features._case.MultipartReplyMeterFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.MultipartReplyPortDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.MultipartReplyPortDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.multipart.reply.port.desc.Ports;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.multipart.reply.port.desc.PortsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.MultipartReplyPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.MultipartReplyPortStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.MultipartReplyQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.MultipartReplyQueueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.MultipartReplyTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.MultipartReplyTableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.MultipartReplyTableFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.multipart.reply.table.features.TableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.multipart.reply.table.features.TableFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeatureProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeaturePropertiesBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class MultipartReplyMessageFactoryTest {
    private static final byte MESSAGE_TYPE = 19;
    private static final byte PADDING = 4;
    private OFSerializer<MultipartReplyMessage> factory;

    @Before
    public void startUp() throws Exception {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(4, MultipartReplyMessage.class));
    }

    @Test
    public void testMultipartRequestTableFeaturesMessageFactory() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)12));
        MultipartReplyTableFeaturesCaseBuilder caseBuilder = new MultipartReplyTableFeaturesCaseBuilder();
        MultipartReplyTableFeaturesBuilder featuresBuilder = new MultipartReplyTableFeaturesBuilder();
        ArrayList<TableFeatures> tableFeaturesList = new ArrayList<TableFeatures>();
        TableFeaturesBuilder tableFeaturesBuilder = new TableFeaturesBuilder();
        tableFeaturesBuilder.setTableId(Short.valueOf((short)8));
        tableFeaturesBuilder.setName("AAAABBBBCCCCDDDDEEEEFFFFGGGG");
        tableFeaturesBuilder.setMetadataMatch(new byte[]{0, 1, 2, 3, 1, 4, 8, 1});
        tableFeaturesBuilder.setMetadataWrite(new byte[]{0, 7, 1, 5, 1, 0, 3, 1});
        tableFeaturesBuilder.setConfig(new TableConfig(Boolean.valueOf(true)));
        tableFeaturesBuilder.setMaxEntries(Long.valueOf(65L));
        ArrayList<TableFeatureProperties> properties = new ArrayList<TableFeatureProperties>();
        TableFeaturePropertiesBuilder propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTNEXTTABLES);
        NextTableRelatedTableFeaturePropertyBuilder nextPropBuilder = new NextTableRelatedTableFeaturePropertyBuilder();
        ArrayList<NextTableIds> nextIds = new ArrayList<NextTableIds>();
        nextIds.add(new NextTableIdsBuilder().setTableId(Short.valueOf((short)1)).build());
        nextIds.add(new NextTableIdsBuilder().setTableId(Short.valueOf((short)2)).build());
        nextPropBuilder.setNextTableIds(nextIds);
        propBuilder.addAugmentation(NextTableRelatedTableFeatureProperty.class, (Augmentation)nextPropBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTNEXTTABLESMISS);
        nextPropBuilder = new NextTableRelatedTableFeaturePropertyBuilder();
        nextIds = new ArrayList();
        nextPropBuilder.setNextTableIds(nextIds);
        propBuilder.addAugmentation(NextTableRelatedTableFeatureProperty.class, (Augmentation)nextPropBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTINSTRUCTIONS);
        InstructionRelatedTableFeaturePropertyBuilder insPropBuilder = new InstructionRelatedTableFeaturePropertyBuilder();
        ArrayList<Instruction> insIds = new ArrayList<Instruction>();
        InstructionBuilder insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new WriteActionsCaseBuilder().build());
        insIds.add(insBuilder.build());
        insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new GotoTableCaseBuilder().build());
        insIds.add(insBuilder.build());
        insPropBuilder.setInstruction(insIds);
        propBuilder.addAugmentation(InstructionRelatedTableFeatureProperty.class, (Augmentation)insPropBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTINSTRUCTIONSMISS);
        insPropBuilder = new InstructionRelatedTableFeaturePropertyBuilder();
        insIds = new ArrayList();
        insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new WriteMetadataCaseBuilder().build());
        insIds.add(insBuilder.build());
        insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new ApplyActionsCaseBuilder().build());
        insIds.add(insBuilder.build());
        insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new MeterCaseBuilder().build());
        insIds.add(insBuilder.build());
        insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new ClearActionsCaseBuilder().build());
        insIds.add(insBuilder.build());
        insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new GotoTableCaseBuilder().build());
        insIds.add(insBuilder.build());
        insPropBuilder.setInstruction(insIds);
        propBuilder.addAugmentation(InstructionRelatedTableFeatureProperty.class, (Augmentation)insPropBuilder.build());
        properties.add(propBuilder.build());
        tableFeaturesBuilder.setTableFeatureProperties(properties);
        tableFeaturesList.add(tableFeaturesBuilder.build());
        tableFeaturesBuilder = new TableFeaturesBuilder();
        tableFeaturesBuilder.setTableId(Short.valueOf((short)8));
        tableFeaturesBuilder.setName("AAAABBBBCCCCDDDDEEEEFFFFGGGG");
        byte[] metadataMatch = new byte[]{0, 1, 2, 3, 1, 4, 8, 1};
        tableFeaturesBuilder.setMetadataMatch(metadataMatch);
        byte[] metadataWrite = new byte[]{0, 7, 1, 5, 1, 0, 3, 1};
        tableFeaturesBuilder.setMetadataWrite(metadataWrite);
        tableFeaturesBuilder.setConfig(new TableConfig(Boolean.valueOf(true)));
        tableFeaturesBuilder.setMaxEntries(Long.valueOf(67L));
        properties = new ArrayList();
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTWRITEACTIONS);
        ActionRelatedTableFeaturePropertyBuilder actBuilder = new ActionRelatedTableFeaturePropertyBuilder();
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice((ActionChoice)new OutputActionCaseBuilder().build());
        actions.add(actionBuilder.build());
        actBuilder.setAction(actions);
        propBuilder.addAugmentation(ActionRelatedTableFeatureProperty.class, (Augmentation)actBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTWRITEACTIONSMISS);
        actBuilder = new ActionRelatedTableFeaturePropertyBuilder();
        actions = new ArrayList();
        actBuilder.setAction(actions);
        propBuilder.addAugmentation(ActionRelatedTableFeatureProperty.class, (Augmentation)actBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTAPPLYACTIONS);
        actBuilder = new ActionRelatedTableFeaturePropertyBuilder();
        actions = new ArrayList();
        actBuilder.setAction(actions);
        propBuilder.addAugmentation(ActionRelatedTableFeatureProperty.class, (Augmentation)actBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTAPPLYACTIONSMISS);
        actBuilder = new ActionRelatedTableFeaturePropertyBuilder();
        actions = new ArrayList();
        actBuilder.setAction(actions);
        propBuilder.addAugmentation(ActionRelatedTableFeatureProperty.class, (Augmentation)actBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTMATCH);
        OxmRelatedTableFeaturePropertyBuilder oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(InPhyPort.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        entries.add(entriesBuilder.build());
        entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(InPort.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        entries.add(entriesBuilder.build());
        oxmBuilder.setMatchEntry(entries);
        propBuilder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTWILDCARDS);
        oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
        entries = new ArrayList();
        oxmBuilder.setMatchEntry(entries);
        propBuilder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTWRITESETFIELD);
        oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
        entries = new ArrayList();
        oxmBuilder.setMatchEntry(entries);
        propBuilder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTWRITESETFIELDMISS);
        oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
        entries = new ArrayList();
        oxmBuilder.setMatchEntry(entries);
        propBuilder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTAPPLYSETFIELD);
        oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
        entries = new ArrayList();
        entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(IpProto.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        entries.add(entriesBuilder.build());
        entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(IpEcn.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        entries.add(entriesBuilder.build());
        oxmBuilder.setMatchEntry(entries);
        propBuilder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTAPPLYSETFIELDMISS);
        oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
        entries = new ArrayList();
        oxmBuilder.setMatchEntry(entries);
        propBuilder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
        properties.add(propBuilder.build());
        tableFeaturesBuilder.setTableFeatureProperties(properties);
        tableFeaturesList.add(tableFeaturesBuilder.build());
        featuresBuilder.setTableFeatures(tableFeaturesList);
        caseBuilder.setMultipartReplyTableFeatures(featuresBuilder.build());
        builder.setMultipartReplyBody((MultipartReplyBody)caseBuilder.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 520);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPTABLEFEATURES.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong length", (long)232L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong registry-id", (long)8L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(5);
        Assert.assertEquals((String)"Wrong name", (Object)"AAAABBBBCCCCDDDDEEEEFFFFGGGG", (Object)ByteBufUtils.decodeNullTerminatedString((ByteBuf)serializedBuffer, (int)32));
        byte[] metadataMatchOutput = new byte[metadataMatch.length];
        serializedBuffer.readBytes(metadataMatchOutput);
        Assert.assertArrayEquals((String)"Wrong metadata-match", (byte[])new byte[]{0, 1, 2, 3, 1, 4, 8, 1}, (byte[])metadataMatchOutput);
        serializedBuffer.skipBytes(64 - metadataMatch.length);
        byte[] metadataWriteOutput = new byte[metadataWrite.length];
        serializedBuffer.readBytes(metadataWriteOutput);
        Assert.assertArrayEquals((String)"Wrong metadata-write", (byte[])new byte[]{0, 7, 1, 5, 1, 0, 3, 1}, (byte[])metadataWriteOutput);
        serializedBuffer.skipBytes(64 - metadataWrite.length);
        Assert.assertEquals((String)"Wrong config", (long)1L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong max-entries", (long)65L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong property type", (long)2L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)6L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong next-registry-id", (long)1L, (long)serializedBuffer.readUnsignedByte());
        Assert.assertEquals((String)"Wrong next-registry-id", (long)2L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(2);
        Assert.assertEquals((String)"Wrong property type", (long)3L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)0L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)12L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)3L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)1L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)1L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)24L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)2L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)4L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)6L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)5L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)1L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong length", (long)272L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong registry-id", (long)8L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(5);
        Assert.assertEquals((String)"Wrong name", (Object)"AAAABBBBCCCCDDDDEEEEFFFFGGGG", (Object)ByteBufUtils.decodeNullTerminatedString((ByteBuf)serializedBuffer, (int)32));
        metadataMatchOutput = new byte[metadataMatch.length];
        serializedBuffer.readBytes(metadataMatchOutput);
        serializedBuffer.skipBytes(64 - metadataMatch.length);
        Assert.assertArrayEquals((String)"Wrong metadata-match", (byte[])new byte[]{0, 1, 2, 3, 1, 4, 8, 1}, (byte[])metadataMatchOutput);
        metadataWriteOutput = new byte[metadataWrite.length];
        serializedBuffer.readBytes(metadataWriteOutput);
        serializedBuffer.skipBytes(64 - metadataWrite.length);
        Assert.assertArrayEquals((String)"Wrong metadata-write", (byte[])new byte[]{0, 7, 1, 5, 1, 0, 3, 1}, (byte[])metadataWriteOutput);
        Assert.assertEquals((String)"Wrong config", (long)1L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong max-entries", (long)67L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong property type", (long)4L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)8L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action type", (long)0L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property type", (long)5L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)6L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)7L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)8L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)12L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match class", (long)32768L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match field&mask", (long)2L, (long)serializedBuffer.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match length", (long)4L, (long)serializedBuffer.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match class", (long)32768L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match field&mask", (long)0L, (long)serializedBuffer.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match length", (long)4L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)10L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)12L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)13L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)14L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)12L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match class", (long)32768L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match field&mask", (long)20L, (long)serializedBuffer.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match length", (long)1L, (long)serializedBuffer.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match class", (long)32768L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match field&mask", (long)18L, (long)serializedBuffer.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match length", (long)1L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)15L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(4);
        Assert.assertTrue((String)"Unread data", (serializedBuffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPortDescSerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)13));
        MultipartReplyPortDescCaseBuilder portDescCase = new MultipartReplyPortDescCaseBuilder();
        MultipartReplyPortDescBuilder portDesc = new MultipartReplyPortDescBuilder();
        portDesc.setPorts(MultipartReplyMessageFactoryTest.createPortList());
        portDescCase.setMultipartReplyPortDesc(portDesc.build());
        builder.setMultipartReplyBody((MultipartReplyBody)portDescCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 80);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPPORTDESC.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        MultipartReplyPortDescCase body = (MultipartReplyPortDescCase)message.getMultipartReplyBody();
        MultipartReplyPortDesc messageOutput = body.getMultipartReplyPortDesc();
        Ports port = (Ports)messageOutput.getPorts().get(0);
        Assert.assertEquals((String)"Wrong PortNo", (long)port.getPortNo().intValue(), (long)serializedBuffer.readUnsignedInt());
        serializedBuffer.skipBytes(4);
        byte[] address = new byte[6];
        serializedBuffer.readBytes(address);
        Assert.assertEquals((String)"Wrong MacAddress", (Object)port.getHwAddr().getValue().toLowerCase(), (Object)new MacAddress(ByteBufUtils.macAddressToString((byte[])address)).getValue().toLowerCase());
        serializedBuffer.skipBytes(2);
        byte[] name = new byte[16];
        serializedBuffer.readBytes(name);
        Assert.assertEquals((String)"Wrong name", (Object)port.getName(), (Object)new String(name).trim());
        Assert.assertEquals((String)"Wrong config", (Object)port.getConfig(), (Object)MultipartReplyMessageFactoryTest.createPortConfig(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong state", (Object)port.getState(), (Object)MultipartReplyMessageFactoryTest.createPortState(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong current", (Object)port.getCurrentFeatures(), (Object)MultipartReplyMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong advertised", (Object)port.getAdvertisedFeatures(), (Object)MultipartReplyMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong supported", (Object)port.getSupportedFeatures(), (Object)MultipartReplyMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong peer", (Object)port.getPeerFeatures(), (Object)MultipartReplyMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong Current speed", (long)port.getCurrSpeed(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong Max speed", (long)port.getMaxSpeed(), (long)serializedBuffer.readInt());
    }

    @Test
    public void testMeterFeaturesSerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)11));
        MultipartReplyMeterFeaturesCaseBuilder meterFeaturesCase = new MultipartReplyMeterFeaturesCaseBuilder();
        MultipartReplyMeterFeaturesBuilder meterFeatures = new MultipartReplyMeterFeaturesBuilder();
        meterFeatures.setMaxMeter(Long.valueOf(1L));
        meterFeatures.setBandTypes(new MeterBandTypeBitmap(Boolean.valueOf(true), Boolean.valueOf(false)));
        meterFeatures.setCapabilities(new MeterFlags(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        meterFeatures.setMaxBands(Short.valueOf((short)1));
        meterFeatures.setMaxColor(Short.valueOf((short)1));
        meterFeaturesCase.setMultipartReplyMeterFeatures(meterFeatures.build());
        builder.setMultipartReplyBody((MultipartReplyBody)meterFeaturesCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 30);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPMETERFEATURES.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        MultipartReplyMeterFeaturesCase body = (MultipartReplyMeterFeaturesCase)message.getMultipartReplyBody();
        MultipartReplyMeterFeatures messageOutput = body.getMultipartReplyMeterFeatures();
        Assert.assertEquals((String)"Wrong max meter", (long)messageOutput.getMaxMeter().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong band type", (Object)messageOutput.getBandTypes(), (Object)MultipartReplyMessageFactoryTest.createMeterBandTypeBitmap(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong capabilities", (Object)messageOutput.getCapabilities(), (Object)MultipartReplyMessageFactoryTest.createMeterFlags(serializedBuffer.readShort()));
        Assert.assertEquals((String)"Wrong max bands", (long)messageOutput.getMaxBands().shortValue(), (long)serializedBuffer.readUnsignedByte());
        Assert.assertEquals((String)"Wrong max color", (long)messageOutput.getMaxColor().shortValue(), (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(2);
    }

    @Test
    public void testMeterConfigSerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)10));
        MultipartReplyMeterConfigCaseBuilder meterConfigCase = new MultipartReplyMeterConfigCaseBuilder();
        MultipartReplyMeterConfigBuilder meterConfigBuilder = new MultipartReplyMeterConfigBuilder();
        meterConfigBuilder.setMeterConfig(MultipartReplyMessageFactoryTest.createMeterConfig());
        meterConfigCase.setMultipartReplyMeterConfig(meterConfigBuilder.build());
        builder.setMultipartReplyBody((MultipartReplyBody)meterConfigCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 48);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPMETERCONFIG.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        MultipartReplyMeterConfigCase body = (MultipartReplyMeterConfigCase)message.getMultipartReplyBody();
        MultipartReplyMeterConfig messageOutput = body.getMultipartReplyMeterConfig();
        MeterConfig meterConfig = (MeterConfig)messageOutput.getMeterConfig().get(0);
        Assert.assertEquals((String)"Wrong len", (long)32L, (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)meterConfig.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMeterFlags(serializedBuffer.readShort()));
        Assert.assertEquals((String)"Wrong meterId", (long)meterConfig.getMeterId().getValue().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong bands", (Object)meterConfig.getBands(), MultipartReplyMessageFactoryTest.decodeBandsList(serializedBuffer));
    }

    @Test
    public void testMeterSerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)9));
        MultipartReplyMeterCaseBuilder meterCase = new MultipartReplyMeterCaseBuilder();
        MultipartReplyMeterBuilder meter = new MultipartReplyMeterBuilder();
        meter.setMeterStats(MultipartReplyMessageFactoryTest.createMeterStats());
        meterCase.setMultipartReplyMeter(meter.build());
        builder.setMultipartReplyBody((MultipartReplyBody)meterCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 74);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPMETER.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        MultipartReplyMeterCase body = (MultipartReplyMeterCase)message.getMultipartReplyBody();
        MultipartReplyMeter messageOutput = body.getMultipartReplyMeter();
        MeterStats meterStats = (MeterStats)messageOutput.getMeterStats().get(0);
        Assert.assertEquals((String)"Wrong meterId", (long)meterStats.getMeterId().getValue().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong len", (long)58L, (long)serializedBuffer.readInt());
        serializedBuffer.skipBytes(6);
        Assert.assertEquals((String)"Wrong flow count", (long)meterStats.getFlowCount().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong packet in count", (long)meterStats.getPacketInCount().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong byte in count", (long)meterStats.getByteInCount().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong duration sec", (long)meterStats.getDurationSec().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong duration nsec", (long)meterStats.getDurationNsec().intValue(), (long)serializedBuffer.readInt());
        MeterBandStats meterBandStats = (MeterBandStats)meterStats.getMeterBandStats().get(0);
        Assert.assertEquals((String)"Wrong packet in count", (long)meterBandStats.getPacketBandCount().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong byte in count", (long)meterBandStats.getByteBandCount().longValue(), (long)serializedBuffer.readLong());
    }

    @Test
    public void testGroupFeaturesSerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)8));
        MultipartReplyGroupFeaturesCaseBuilder featureCase = new MultipartReplyGroupFeaturesCaseBuilder();
        MultipartReplyGroupFeaturesBuilder feature = new MultipartReplyGroupFeaturesBuilder();
        feature.setTypes(new GroupTypes(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        feature.setCapabilities(new GroupCapabilities(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true)));
        ArrayList<Long> maxGroups = new ArrayList<Long>();
        maxGroups.add(1L);
        maxGroups.add(2L);
        maxGroups.add(3L);
        maxGroups.add(4L);
        feature.setMaxGroups(maxGroups);
        feature.setActionsBitmap(MultipartReplyMessageFactoryTest.createActionType());
        featureCase.setMultipartReplyGroupFeatures(feature.build());
        builder.setMultipartReplyBody((MultipartReplyBody)featureCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 56);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPGROUPFEATURES.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        MultipartReplyGroupFeaturesCase body = (MultipartReplyGroupFeaturesCase)message.getMultipartReplyBody();
        MultipartReplyGroupFeatures messageOutput = body.getMultipartReplyGroupFeatures();
        Assert.assertEquals((String)"Wrong type", (Object)messageOutput.getTypes(), (Object)MultipartReplyMessageFactoryTest.createGroupTypes(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong capabilities", (Object)messageOutput.getCapabilities(), (Object)MultipartReplyMessageFactoryTest.createGroupCapabilities(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong max groups", (long)((Long)messageOutput.getMaxGroups().get(0)).intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong max groups", (long)((Long)messageOutput.getMaxGroups().get(1)).intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong max groups", (long)((Long)messageOutput.getMaxGroups().get(2)).intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong max groups", (long)((Long)messageOutput.getMaxGroups().get(3)).intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong actions", messageOutput.getActionsBitmap().get(0), (Object)MultipartReplyMessageFactoryTest.createActionType(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong actions", messageOutput.getActionsBitmap().get(1), (Object)MultipartReplyMessageFactoryTest.createActionType(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong actions", messageOutput.getActionsBitmap().get(2), (Object)MultipartReplyMessageFactoryTest.createActionType(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong actions", messageOutput.getActionsBitmap().get(3), (Object)MultipartReplyMessageFactoryTest.createActionType(serializedBuffer.readInt()));
    }

    @Test
    public void testGroupDescSerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)7));
        MultipartReplyGroupDescCaseBuilder groupCase = new MultipartReplyGroupDescCaseBuilder();
        MultipartReplyGroupDescBuilder group = new MultipartReplyGroupDescBuilder();
        group.setGroupDesc(MultipartReplyMessageFactoryTest.createGroupDesc());
        groupCase.setMultipartReplyGroupDesc(group.build());
        builder.setMultipartReplyBody((MultipartReplyBody)groupCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 64);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPGROUPDESC.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        MultipartReplyGroupDescCase body = (MultipartReplyGroupDescCase)message.getMultipartReplyBody();
        MultipartReplyGroupDesc messageOutput = body.getMultipartReplyGroupDesc();
        GroupDesc groupDesc = (GroupDesc)messageOutput.getGroupDesc().get(0);
        Assert.assertEquals((String)"Wrong length", (long)48L, (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong type", (long)groupDesc.getType().getIntValue(), (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(1);
        Assert.assertEquals((String)"Wrong group id", (long)groupDesc.getGroupId().getValue().intValue(), (long)serializedBuffer.readInt());
        BucketsList bucketList = (BucketsList)groupDesc.getBucketsList().get(0);
        Assert.assertEquals((String)"Wrong length", (long)40L, (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong weight", (long)bucketList.getWeight().intValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong watch port", (long)bucketList.getWatchPort().getValue().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong watch group", (long)bucketList.getWatchGroup().intValue(), (long)serializedBuffer.readInt());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong action type", (long)0L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)16L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action type", (long)45L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong action type", (long)55L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(6);
        Assert.assertEquals((String)"Wrong action type", (long)23L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action type", (long)64L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(3);
        Assert.assertTrue((String)"Not all data were read", (serializedBuffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGroupSerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)6));
        MultipartReplyGroupCaseBuilder groupCase = new MultipartReplyGroupCaseBuilder();
        MultipartReplyGroupBuilder group = new MultipartReplyGroupBuilder();
        group.setGroupStats(MultipartReplyMessageFactoryTest.createGroupStats());
        groupCase.setMultipartReplyGroup(group.build());
        builder.setMultipartReplyBody((MultipartReplyBody)groupCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 72);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPGROUP.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        MultipartReplyGroupCase body = (MultipartReplyGroupCase)message.getMultipartReplyBody();
        MultipartReplyGroup messageOutput = body.getMultipartReplyGroup();
        GroupStats groupStats = (GroupStats)messageOutput.getGroupStats().get(0);
        Assert.assertEquals((String)"Wrong length", (long)56L, (long)serializedBuffer.readShort());
        serializedBuffer.skipBytes(2);
        Assert.assertEquals((String)"Wrong group id", (long)groupStats.getGroupId().getValue().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong ref count", (long)groupStats.getRefCount().intValue(), (long)serializedBuffer.readInt());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong Packet count", (long)groupStats.getPacketCount().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong Byte count", (long)groupStats.getByteCount().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong duration sec", (long)groupStats.getDurationSec().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong duration nsec", (long)groupStats.getDurationNsec().intValue(), (long)serializedBuffer.readInt());
        BucketStats bucketStats = (BucketStats)groupStats.getBucketStats().get(0);
        Assert.assertEquals((String)"Wrong Packet count", (long)bucketStats.getPacketCount().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong Byte count", (long)bucketStats.getByteCount().longValue(), (long)serializedBuffer.readLong());
    }

    @Test
    public void testQueueSerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)5));
        MultipartReplyQueueCaseBuilder queueCase = new MultipartReplyQueueCaseBuilder();
        MultipartReplyQueueBuilder queue = new MultipartReplyQueueBuilder();
        queue.setQueueStats(MultipartReplyMessageFactoryTest.createQueueStats());
        queueCase.setMultipartReplyQueue(queue.build());
        builder.setMultipartReplyBody((MultipartReplyBody)queueCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 56);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPQUEUE.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        MultipartReplyQueueCase body = (MultipartReplyQueueCase)message.getMultipartReplyBody();
        MultipartReplyQueue messageOutput = body.getMultipartReplyQueue();
        QueueStats queueStats = (QueueStats)messageOutput.getQueueStats().get(0);
        Assert.assertEquals((String)"Wrong PortNo", (long)queueStats.getPortNo().intValue(), (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong queue id", (long)queueStats.getQueueId().intValue(), (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong tx bytes", (long)queueStats.getTxBytes().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong tx packets", (long)queueStats.getTxPackets().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong tx errors", (long)queueStats.getTxErrors().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong duration sec", (long)queueStats.getDurationSec().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong duration nsec", (long)queueStats.getDurationNsec().intValue(), (long)serializedBuffer.readInt());
    }

    @Test
    public void testPortStatsSerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)4));
        MultipartReplyPortStatsCaseBuilder portStatsCase = new MultipartReplyPortStatsCaseBuilder();
        MultipartReplyPortStatsBuilder portStats = new MultipartReplyPortStatsBuilder();
        portStats.setPortStats(MultipartReplyMessageFactoryTest.createPortStats());
        portStatsCase.setMultipartReplyPortStats(portStats.build());
        builder.setMultipartReplyBody((MultipartReplyBody)portStatsCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 128);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPPORTSTATS.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        MultipartReplyPortStatsCase body = (MultipartReplyPortStatsCase)message.getMultipartReplyBody();
        MultipartReplyPortStats messageOutput = body.getMultipartReplyPortStats();
        PortStats portStatsOutput = (PortStats)messageOutput.getPortStats().get(0);
        Assert.assertEquals((String)"Wrong port no", (long)portStatsOutput.getPortNo().intValue(), (long)serializedBuffer.readInt());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong rx packets", (long)portStatsOutput.getRxPackets().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong tx packets", (long)portStatsOutput.getTxPackets().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong rx bytes", (long)portStatsOutput.getRxBytes().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong tx bytes", (long)portStatsOutput.getTxBytes().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong rx dropped", (long)portStatsOutput.getRxDropped().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong tx dropped", (long)portStatsOutput.getTxDropped().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong rx errors", (long)portStatsOutput.getRxErrors().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong tx errors", (long)portStatsOutput.getTxErrors().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong rx frame err", (long)portStatsOutput.getRxFrameErr().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong rx over err", (long)portStatsOutput.getRxOverErr().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong rx crc err", (long)portStatsOutput.getRxCrcErr().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong collisions", (long)portStatsOutput.getCollisions().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong duration sec", (long)portStatsOutput.getDurationSec().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong duration nsec", (long)portStatsOutput.getDurationNsec().intValue(), (long)serializedBuffer.readInt());
    }

    @Test
    public void testTableSerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)3));
        MultipartReplyTableCaseBuilder tableCase = new MultipartReplyTableCaseBuilder();
        MultipartReplyTableBuilder table = new MultipartReplyTableBuilder();
        table.setTableStats(MultipartReplyMessageFactoryTest.createTableStats());
        tableCase.setMultipartReplyTable(table.build());
        builder.setMultipartReplyBody((MultipartReplyBody)tableCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 40);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPTABLE.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        MultipartReplyTableCase body = (MultipartReplyTableCase)message.getMultipartReplyBody();
        MultipartReplyTable messageOutput = body.getMultipartReplyTable();
        TableStats tableStats = (TableStats)messageOutput.getTableStats().get(0);
        Assert.assertEquals((String)"Wrong tableId", (long)tableStats.getTableId().shortValue(), (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(3);
        Assert.assertEquals((String)"Wrong active count", (long)tableStats.getActiveCount(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong lookup count", (long)tableStats.getLookupCount().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong matched count", (long)tableStats.getMatchedCount().longValue(), (long)serializedBuffer.readLong());
    }

    @Test
    public void testAggregateSerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)2));
        MultipartReplyAggregateCaseBuilder aggregateCase = new MultipartReplyAggregateCaseBuilder();
        MultipartReplyAggregateBuilder aggregate = new MultipartReplyAggregateBuilder();
        aggregate.setPacketCount(BigInteger.valueOf(1L));
        aggregate.setByteCount(BigInteger.valueOf(1L));
        aggregate.setFlowCount(Long.valueOf(1L));
        aggregateCase.setMultipartReplyAggregate(aggregate.build());
        builder.setMultipartReplyBody((MultipartReplyBody)aggregateCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 40);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPAGGREGATE.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        MultipartReplyAggregateCase body = (MultipartReplyAggregateCase)message.getMultipartReplyBody();
        MultipartReplyAggregate messageOutput = body.getMultipartReplyAggregate();
        Assert.assertEquals((String)"Wrong Packet count", (long)messageOutput.getPacketCount().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong Byte count", (long)messageOutput.getByteCount().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong Flow count", (long)messageOutput.getFlowCount(), (long)serializedBuffer.readInt());
        serializedBuffer.skipBytes(4);
    }

    @Test
    public void testFlowSerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)1));
        MultipartReplyFlowCaseBuilder flowCase = new MultipartReplyFlowCaseBuilder();
        MultipartReplyFlowBuilder flow = new MultipartReplyFlowBuilder();
        flow.setFlowStats(MultipartReplyMessageFactoryTest.createFlowStats());
        flowCase.setMultipartReplyFlow(flow.build());
        builder.setMultipartReplyBody((MultipartReplyBody)flowCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 192);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPFLOW.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        MultipartReplyMessageFactoryTest.testFlowBody(message.getMultipartReplyBody(), serializedBuffer);
    }

    @Test
    public void testDescSerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)0));
        MultipartReplyDescCaseBuilder descCase = new MultipartReplyDescCaseBuilder();
        MultipartReplyDescBuilder desc = new MultipartReplyDescBuilder();
        desc.setMfrDesc("Test");
        desc.setHwDesc("Test");
        desc.setSwDesc("Test");
        desc.setSerialNum("12345");
        desc.setDpDesc("Test");
        descCase.setMultipartReplyDesc(desc.build());
        builder.setMultipartReplyBody((MultipartReplyBody)descCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)19, 1072);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPDESC.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong desc body", (Object)message.getMultipartReplyBody(), (Object)MultipartReplyMessageFactoryTest.decodeDescBody(serializedBuffer));
    }

    private static void testFlowBody(MultipartReplyBody body, ByteBuf output) {
        MultipartReplyFlowCase flowCase = (MultipartReplyFlowCase)body;
        MultipartReplyFlow flow = flowCase.getMultipartReplyFlow();
        FlowStats flowStats = (FlowStats)flow.getFlowStats().get(0);
        Assert.assertEquals((String)"Wrong length", (long)176L, (long)output.readShort());
        Assert.assertEquals((String)"Wrong Table ID", (long)flowStats.getTableId().intValue(), (long)output.readUnsignedByte());
        output.skipBytes(1);
        Assert.assertEquals((String)"Wrong duration sec", (long)flowStats.getDurationSec().intValue(), (long)output.readInt());
        Assert.assertEquals((String)"Wrong duration nsec", (long)flowStats.getDurationNsec().intValue(), (long)output.readInt());
        Assert.assertEquals((String)"Wrong priority", (long)flowStats.getPriority().intValue(), (long)output.readShort());
        Assert.assertEquals((String)"Wrong idle timeout", (long)flowStats.getIdleTimeout().intValue(), (long)output.readShort());
        Assert.assertEquals((String)"Wrong hard timeout", (long)flowStats.getHardTimeout().intValue(), (long)output.readShort());
        output.skipBytes(6);
        Assert.assertEquals((String)"Wrong cookie", (long)flowStats.getCookie().longValue(), (long)output.readLong());
        Assert.assertEquals((String)"Wrong Packet count", (long)flowStats.getPacketCount().longValue(), (long)output.readLong());
        Assert.assertEquals((String)"Wrong Byte count", (long)flowStats.getByteCount().longValue(), (long)output.readLong());
        Assert.assertEquals((String)"Wrong match type", (long)1L, (long)output.readUnsignedShort());
        output.skipBytes(2);
        Assert.assertEquals((String)"Wrong oxm class", (long)32768L, (long)output.readUnsignedShort());
        short fieldAndMask = output.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm hasMask", (long)0L, (long)(fieldAndMask & 1));
        Assert.assertEquals((String)"Wrong oxm field", (long)1L, (long)(fieldAndMask >> 1));
        output.skipBytes(1);
        Assert.assertEquals((String)"Wrong oxm value", (long)42L, (long)output.readUnsignedInt());
        Assert.assertEquals((String)"Wrong oxm class", (long)32768L, (long)output.readUnsignedShort());
        fieldAndMask = output.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm hasMask", (long)0L, (long)(fieldAndMask & 1));
        Assert.assertEquals((String)"Wrong oxm field", (long)9L, (long)(fieldAndMask >> 1));
        output.skipBytes(1);
        Assert.assertEquals((String)"Wrong oxm value", (long)4L, (long)output.readUnsignedByte());
        output.skipBytes(7);
        Assert.assertEquals((String)"Wrong instruction type", (long)1L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)8L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction table-id", (long)5L, (long)output.readUnsignedByte());
        output.skipBytes(3);
        Assert.assertEquals((String)"Wrong instruction type", (long)2L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)24L, (long)output.readUnsignedShort());
        output.skipBytes(4);
        byte[] actual = new byte[8];
        output.readBytes(actual);
        Assert.assertEquals((String)"Wrong instruction metadata", (Object)"00 01 02 03 04 05 06 07", (Object)ByteBufUtils.bytesToHexString((byte[])actual));
        actual = new byte[8];
        output.readBytes(actual);
        Assert.assertEquals((String)"Wrong instruction metadata-mask", (Object)"07 06 05 04 03 02 01 00", (Object)ByteBufUtils.bytesToHexString((byte[])actual));
        Assert.assertEquals((String)"Wrong instruction type", (long)5L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)8L, (long)output.readUnsignedShort());
        output.skipBytes(4);
        Assert.assertEquals((String)"Wrong instruction type", (long)6L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)8L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction meter-id", (long)42L, (long)output.readUnsignedInt());
        Assert.assertEquals((String)"Wrong instruction type", (long)3L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)32L, (long)output.readUnsignedShort());
        output.skipBytes(4);
        Assert.assertEquals((String)"Wrong action type", (long)0L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)16L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action type", (long)45L, (long)output.readUnsignedInt());
        Assert.assertEquals((String)"Wrong action type", (long)55L, (long)output.readUnsignedShort());
        output.skipBytes(6);
        Assert.assertEquals((String)"Wrong action type", (long)23L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action type", (long)64L, (long)output.readUnsignedByte());
        output.skipBytes(3);
        Assert.assertEquals((String)"Wrong instruction type", (long)4L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)24L, (long)output.readUnsignedShort());
        output.skipBytes(4);
        Assert.assertEquals((String)"Wrong action type", (long)17L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action ethertype", (long)14L, (long)output.readUnsignedShort());
        output.skipBytes(2);
        Assert.assertEquals((String)"Wrong action type", (long)27L, (long)output.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)output.readUnsignedShort());
        output.skipBytes(4);
        Assert.assertTrue((String)"Not all data were read", (output.readableBytes() == 0 ? 1 : 0) != 0);
    }

    private static List<Ports> createPortList() {
        PortsBuilder builder = new PortsBuilder();
        builder.setPortNo(Long.valueOf(1L));
        builder.setHwAddr(new MacAddress("94:de:80:a6:61:40"));
        builder.setName("Port name");
        builder.setConfig(new PortConfig(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setState(new PortState(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)));
        builder.setCurrentFeatures(new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setAdvertisedFeatures(new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setSupportedFeatures(new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setPeerFeatures(new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setCurrSpeed(Long.valueOf(1234L));
        builder.setMaxSpeed(Long.valueOf(1234L));
        ArrayList<Ports> list = new ArrayList<Ports>();
        list.add(builder.build());
        return list;
    }

    private static PortConfig createPortConfig(long input) {
        Boolean _portDown = (input & 1L) > 0L;
        Boolean _noRecv = (input & 4L) > 0L;
        Boolean _noFwd = (input & 0x20L) > 0L;
        Boolean _noPacketIn = (input & 0x40L) > 0L;
        return new PortConfig(_noFwd, _noPacketIn, _noRecv, _portDown);
    }

    private static PortFeatures createPortFeatures(long input) {
        Boolean _10mbHd = (input & 1L) > 0L;
        Boolean _10mbFd = (input & 2L) > 0L;
        Boolean _100mbHd = (input & 4L) > 0L;
        Boolean _100mbFd = (input & 8L) > 0L;
        Boolean _1gbHd = (input & 0x10L) > 0L;
        Boolean _1gbFd = (input & 0x20L) > 0L;
        Boolean _10gbFd = (input & 0x40L) > 0L;
        Boolean _40gbFd = (input & 0x80L) > 0L;
        Boolean _100gbFd = (input & 0x100L) > 0L;
        Boolean _1tbFd = (input & 0x200L) > 0L;
        Boolean _other = (input & 0x400L) > 0L;
        Boolean _copper = (input & 0x800L) > 0L;
        Boolean _fiber = (input & 0x1000L) > 0L;
        Boolean _autoneg = (input & 0x2000L) > 0L;
        Boolean _pause = (input & 0x4000L) > 0L;
        Boolean _pauseAsym = (input & 0x8000L) > 0L;
        return new PortFeatures(_100gbFd, _100mbFd, _100mbHd, _10gbFd, _10mbFd, _10mbHd, _1gbFd, _1gbHd, _1tbFd, _40gbFd, _autoneg, _copper, _fiber, _other, _pause, _pauseAsym);
    }

    private static PortState createPortState(long input) {
        Boolean one = (input & 1L) > 0L;
        Boolean two = (input & 2L) > 0L;
        Boolean three = (input & 4L) > 0L;
        return new PortState(two, one, three);
    }

    private static List<Bands> decodeBandsList(ByteBuf input) {
        ArrayList<Bands> bandsList = new ArrayList<Bands>();
        BandsBuilder bandsBuilder = new BandsBuilder();
        MeterBandDropCaseBuilder dropCaseBuilder = new MeterBandDropCaseBuilder();
        MeterBandDropBuilder dropBand = new MeterBandDropBuilder();
        dropBand.setType(MeterBandType.forValue((int)input.readUnsignedShort()));
        input.skipBytes(2);
        dropBand.setRate(Long.valueOf(input.readUnsignedInt()));
        dropBand.setBurstSize(Long.valueOf(input.readUnsignedInt()));
        dropCaseBuilder.setMeterBandDrop(dropBand.build());
        bandsList.add(bandsBuilder.setMeterBand((MeterBand)dropCaseBuilder.build()).build());
        MeterBandDscpRemarkCaseBuilder dscpCaseBuilder = new MeterBandDscpRemarkCaseBuilder();
        MeterBandDscpRemarkBuilder dscpRemarkBand = new MeterBandDscpRemarkBuilder();
        dscpRemarkBand.setType(MeterBandType.forValue((int)input.readUnsignedShort()));
        input.skipBytes(2);
        dscpRemarkBand.setRate(Long.valueOf(input.readUnsignedInt()));
        dscpRemarkBand.setBurstSize(Long.valueOf(input.readUnsignedInt()));
        dscpRemarkBand.setPrecLevel(Short.valueOf((short)3));
        dscpCaseBuilder.setMeterBandDscpRemark(dscpRemarkBand.build());
        bandsList.add(bandsBuilder.setMeterBand((MeterBand)dscpCaseBuilder.build()).build());
        return bandsList;
    }

    private static List<MeterConfig> createMeterConfig() {
        MeterConfigBuilder builder = new MeterConfigBuilder();
        builder.setFlags(new MeterFlags(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setMeterId(new MeterId(Long.valueOf(1L)));
        builder.setBands(MultipartReplyMessageFactoryTest.createBandsList());
        ArrayList<MeterConfig> list = new ArrayList<MeterConfig>();
        list.add(builder.build());
        return list;
    }

    private static MeterBandTypeBitmap createMeterBandTypeBitmap(int input) {
        Boolean one = (input & 1) > 0;
        Boolean two = (input & 2) > 0;
        return new MeterBandTypeBitmap(one, two);
    }

    private static List<Bands> createBandsList() {
        ArrayList<Bands> bandsList = new ArrayList<Bands>();
        BandsBuilder bandsBuilder = new BandsBuilder();
        MeterBandDropCaseBuilder dropCaseBuilder = new MeterBandDropCaseBuilder();
        MeterBandDropBuilder dropBand = new MeterBandDropBuilder();
        dropBand.setType(MeterBandType.OFPMBTDROP);
        dropBand.setRate(Long.valueOf(1L));
        dropBand.setBurstSize(Long.valueOf(2L));
        dropCaseBuilder.setMeterBandDrop(dropBand.build());
        bandsList.add(bandsBuilder.setMeterBand((MeterBand)dropCaseBuilder.build()).build());
        MeterBandDscpRemarkCaseBuilder dscpCaseBuilder = new MeterBandDscpRemarkCaseBuilder();
        MeterBandDscpRemarkBuilder dscpRemarkBand = new MeterBandDscpRemarkBuilder();
        dscpRemarkBand.setType(MeterBandType.OFPMBTDSCPREMARK);
        dscpRemarkBand.setRate(Long.valueOf(1L));
        dscpRemarkBand.setBurstSize(Long.valueOf(2L));
        dscpRemarkBand.setPrecLevel(Short.valueOf((short)3));
        dscpCaseBuilder.setMeterBandDscpRemark(dscpRemarkBand.build());
        bandsList.add(bandsBuilder.setMeterBand((MeterBand)dscpCaseBuilder.build()).build());
        return bandsList;
    }

    private static MeterFlags createMeterFlags(int input) {
        Boolean one = (input & 1) > 0;
        Boolean two = (input & 2) > 0;
        Boolean three = (input & 4) > 0;
        Boolean four = (input & 8) > 0;
        return new MeterFlags(three, one, two, four);
    }

    private static List<MeterStats> createMeterStats() {
        MeterStatsBuilder builder = new MeterStatsBuilder();
        builder.setMeterId(new MeterId(Long.valueOf(1L)));
        builder.setFlowCount(Long.valueOf(1L));
        builder.setPacketInCount(BigInteger.valueOf(1L));
        builder.setByteInCount(BigInteger.valueOf(1L));
        builder.setDurationSec(Long.valueOf(1L));
        builder.setDurationNsec(Long.valueOf(1L));
        builder.setMeterBandStats(MultipartReplyMessageFactoryTest.createMeterBandStats());
        ArrayList<MeterStats> list = new ArrayList<MeterStats>();
        list.add(builder.build());
        return list;
    }

    private static List<MeterBandStats> createMeterBandStats() {
        MeterBandStatsBuilder builder = new MeterBandStatsBuilder();
        builder.setPacketBandCount(BigInteger.valueOf(1L));
        builder.setByteBandCount(BigInteger.valueOf(1L));
        ArrayList<MeterBandStats> list = new ArrayList<MeterBandStats>();
        list.add(builder.build());
        return list;
    }

    private static ActionType createActionType(int input) {
        Boolean one = (input & 1) > 0;
        Boolean two = (input & 2) > 0;
        Boolean three = (input & 4) > 0;
        Boolean four = (input & 8) > 0;
        Boolean five = (input & 0x10) > 0;
        Boolean six = (input & 0x20) > 0;
        Boolean seven = (input & 0x40) > 0;
        Boolean eight = (input & 0x80) > 0;
        Boolean nine = (input & 0x100) > 0;
        Boolean ten = (input & 0x200) > 0;
        Boolean eleven = (input & 0x400) > 0;
        Boolean twelve = (input & 0x800) > 0;
        Boolean thirteen = (input & 0x1000) > 0;
        Boolean fourteen = (input & 0x2000) > 0;
        Boolean fifthteen = (input & 0x4000) > 0;
        Boolean sixteen = (input & 0x8000) > 0;
        Boolean seventeen = (input & 0x10000) > 0;
        return new ActionType(three, two, five, thirteen, seventeen, eleven, one, nine, sixteen, seven, eight, fifthteen, six, fourteen, four, twelve, ten);
    }

    private static GroupCapabilities createGroupCapabilities(int input) {
        Boolean one = (input & 1) > 0;
        Boolean two = (input & 2) > 0;
        Boolean three = (input & 4) > 0;
        Boolean four = (input & 8) > 0;
        return new GroupCapabilities(three, four, two, one);
    }

    private static GroupTypes createGroupTypes(int input) {
        Boolean one = (input & 1) > 0;
        Boolean two = (input & 2) > 0;
        Boolean three = (input & 4) > 0;
        Boolean four = (input & 8) > 0;
        return new GroupTypes(one, four, three, two);
    }

    private static List<ActionType> createActionType() {
        ActionType actionType1 = new ActionType(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
        ActionType actionType2 = new ActionType(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        ActionType actionType3 = new ActionType(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
        ActionType actionType4 = new ActionType(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
        ArrayList<ActionType> list = new ArrayList<ActionType>();
        list.add(actionType1);
        list.add(actionType2);
        list.add(actionType3);
        list.add(actionType4);
        return list;
    }

    private static List<GroupDesc> createGroupDesc() {
        GroupDescBuilder builder = new GroupDescBuilder();
        builder.setType(GroupType.forValue((int)1));
        builder.setGroupId(new GroupId(Long.valueOf(1L)));
        builder.setBucketsList(MultipartReplyMessageFactoryTest.createBucketsList());
        ArrayList<GroupDesc> list = new ArrayList<GroupDesc>();
        list.add(builder.build());
        return list;
    }

    private static List<GroupStats> createGroupStats() {
        GroupStatsBuilder builder = new GroupStatsBuilder();
        builder.setGroupId(new GroupId(Long.valueOf(1L)));
        builder.setRefCount(Long.valueOf(1L));
        builder.setPacketCount(BigInteger.valueOf(1L));
        builder.setByteCount(BigInteger.valueOf(1L));
        builder.setDurationSec(Long.valueOf(1L));
        builder.setDurationNsec(Long.valueOf(1L));
        builder.setBucketStats(MultipartReplyMessageFactoryTest.createBucketStats());
        ArrayList<GroupStats> list = new ArrayList<GroupStats>();
        list.add(builder.build());
        return list;
    }

    private static List<BucketsList> createBucketsList() {
        BucketsListBuilder builder = new BucketsListBuilder();
        builder.setWeight(Integer.valueOf(1));
        builder.setWatchPort(new PortNumber(Long.valueOf(1L)));
        builder.setWatchGroup(Long.valueOf(1L));
        builder.setAction(MultipartReplyMessageFactoryTest.createActionList());
        ArrayList<BucketsList> list = new ArrayList<BucketsList>();
        list.add(builder.build());
        return list;
    }

    private static List<Action> createActionList() {
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        OutputActionCaseBuilder caseBuilder = new OutputActionCaseBuilder();
        OutputActionBuilder outputBuilder = new OutputActionBuilder();
        outputBuilder.setPort(new PortNumber(Long.valueOf(45L)));
        outputBuilder.setMaxLength(Integer.valueOf(55));
        caseBuilder.setOutputAction(outputBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)caseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetNwTtlCaseBuilder ttlCaseBuilder = new SetNwTtlCaseBuilder();
        SetNwTtlActionBuilder ttlActionBuilder = new SetNwTtlActionBuilder();
        ttlActionBuilder.setNwTtl(Short.valueOf((short)64));
        ttlCaseBuilder.setSetNwTtlAction(ttlActionBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)ttlCaseBuilder.build());
        actions.add(actionBuilder.build());
        return actions;
    }

    private static List<BucketStats> createBucketStats() {
        BucketStatsBuilder builder = new BucketStatsBuilder();
        builder.setPacketCount(BigInteger.valueOf(1L));
        builder.setByteCount(BigInteger.valueOf(1L));
        ArrayList<BucketStats> list = new ArrayList<BucketStats>();
        list.add(builder.build());
        return list;
    }

    private static List<QueueStats> createQueueStats() {
        QueueStatsBuilder builder = new QueueStatsBuilder();
        builder.setPortNo(Long.valueOf(1L));
        builder.setQueueId(Long.valueOf(1L));
        builder.setTxBytes(BigInteger.valueOf(1L));
        builder.setTxPackets(BigInteger.valueOf(1L));
        builder.setTxErrors(BigInteger.valueOf(1L));
        builder.setDurationSec(Long.valueOf(1L));
        builder.setDurationNsec(Long.valueOf(1L));
        ArrayList<QueueStats> list = new ArrayList<QueueStats>();
        list.add(builder.build());
        return list;
    }

    private static List<PortStats> createPortStats() {
        PortStatsBuilder builder = new PortStatsBuilder();
        builder.setPortNo(Long.valueOf(1L));
        builder.setRxPackets(BigInteger.valueOf(1L));
        builder.setTxPackets(BigInteger.valueOf(1L));
        builder.setRxBytes(BigInteger.valueOf(1L));
        builder.setTxBytes(BigInteger.valueOf(1L));
        builder.setRxDropped(BigInteger.valueOf(1L));
        builder.setTxDropped(BigInteger.valueOf(1L));
        builder.setRxErrors(BigInteger.valueOf(1L));
        builder.setTxErrors(BigInteger.valueOf(1L));
        builder.setRxFrameErr(BigInteger.valueOf(1L));
        builder.setRxOverErr(BigInteger.valueOf(1L));
        builder.setRxCrcErr(BigInteger.valueOf(1L));
        builder.setCollisions(BigInteger.valueOf(1L));
        builder.setDurationSec(Long.valueOf(1L));
        builder.setDurationNsec(Long.valueOf(1L));
        ArrayList<PortStats> list = new ArrayList<PortStats>();
        list.add(builder.build());
        return list;
    }

    private static List<TableStats> createTableStats() {
        TableStatsBuilder builder = new TableStatsBuilder();
        builder.setTableId(Short.valueOf((short)1));
        builder.setActiveCount(Long.valueOf(1L));
        builder.setLookupCount(BigInteger.valueOf(1L));
        builder.setMatchedCount(BigInteger.valueOf(1L));
        ArrayList<TableStats> list = new ArrayList<TableStats>();
        list.add(builder.build());
        return list;
    }

    private static List<FlowStats> createFlowStats() {
        FlowStatsBuilder builder = new FlowStatsBuilder();
        builder.setTableId(Short.valueOf((short)1));
        builder.setDurationSec(Long.valueOf(1L));
        builder.setDurationNsec(Long.valueOf(1L));
        builder.setPriority(Integer.valueOf(1));
        builder.setIdleTimeout(Integer.valueOf(1));
        builder.setHardTimeout(Integer.valueOf(1));
        builder.setCookie(BigInteger.valueOf(1234L));
        builder.setPacketCount(BigInteger.valueOf(1234L));
        builder.setByteCount(BigInteger.valueOf(1234L));
        MatchBuilder matchBuilder = new MatchBuilder();
        matchBuilder.setType(OxmMatchType.class);
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(InPhyPort.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        InPhyPortCaseBuilder inPhyPortCaseBuilder = new InPhyPortCaseBuilder();
        InPhyPortBuilder inPhyPortBuilder = new InPhyPortBuilder();
        inPhyPortBuilder.setPortNumber(new PortNumber(Long.valueOf(42L)));
        inPhyPortCaseBuilder.setInPhyPort(inPhyPortBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)inPhyPortCaseBuilder.build());
        entries.add(entriesBuilder.build());
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(IpEcn.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        IpEcnCaseBuilder ipEcnCaseBuilder = new IpEcnCaseBuilder();
        IpEcnBuilder ipEcnBuilder = new IpEcnBuilder();
        ipEcnBuilder.setEcn(Short.valueOf((short)4));
        ipEcnCaseBuilder.setIpEcn(ipEcnBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)ipEcnCaseBuilder.build());
        entries.add(entriesBuilder.build());
        matchBuilder.setMatchEntry(entries);
        builder.setMatch(matchBuilder.build());
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        InstructionBuilder builderInstruction = new InstructionBuilder();
        GotoTableCaseBuilder gotoCaseBuilder = new GotoTableCaseBuilder();
        GotoTableBuilder instructionBuilder = new GotoTableBuilder();
        instructionBuilder.setTableId(Short.valueOf((short)5));
        gotoCaseBuilder.setGotoTable(instructionBuilder.build());
        builderInstruction.setInstructionChoice((InstructionChoice)gotoCaseBuilder.build());
        instructions.add(builderInstruction.build());
        builderInstruction = new InstructionBuilder();
        WriteMetadataCaseBuilder metadataCaseBuilder = new WriteMetadataCaseBuilder();
        WriteMetadataBuilder metadataBuilder = new WriteMetadataBuilder();
        metadataBuilder.setMetadata(ByteBufUtils.hexStringToBytes((String)"00 01 02 03 04 05 06 07"));
        metadataBuilder.setMetadataMask(ByteBufUtils.hexStringToBytes((String)"07 06 05 04 03 02 01 00"));
        metadataCaseBuilder.setWriteMetadata(metadataBuilder.build());
        builderInstruction.setInstructionChoice((InstructionChoice)metadataCaseBuilder.build());
        instructions.add(builderInstruction.build());
        builderInstruction = new InstructionBuilder();
        builderInstruction.setInstructionChoice((InstructionChoice)new ClearActionsCaseBuilder().build());
        instructions.add(builderInstruction.build());
        builderInstruction = new InstructionBuilder();
        MeterCaseBuilder meterCaseBuilder = new MeterCaseBuilder();
        MeterBuilder meterBuilder = new MeterBuilder();
        meterBuilder.setMeterId(Long.valueOf(42L));
        meterCaseBuilder.setMeter(meterBuilder.build());
        builderInstruction.setInstructionChoice((InstructionChoice)meterCaseBuilder.build());
        instructions.add(builderInstruction.build());
        builderInstruction = new InstructionBuilder();
        WriteActionsCaseBuilder writeActionsCaseBuilder = new WriteActionsCaseBuilder();
        WriteActionsBuilder writeActionsBuilder = new WriteActionsBuilder();
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        OutputActionCaseBuilder caseBuilder = new OutputActionCaseBuilder();
        OutputActionBuilder outputBuilder = new OutputActionBuilder();
        outputBuilder.setPort(new PortNumber(Long.valueOf(45L)));
        outputBuilder.setMaxLength(Integer.valueOf(55));
        caseBuilder.setOutputAction(outputBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)caseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetNwTtlCaseBuilder ttlCaseBuilder = new SetNwTtlCaseBuilder();
        SetNwTtlActionBuilder ttlActionBuilder = new SetNwTtlActionBuilder();
        ttlActionBuilder.setNwTtl(Short.valueOf((short)64));
        ttlCaseBuilder.setSetNwTtlAction(ttlActionBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)ttlCaseBuilder.build());
        actions.add(actionBuilder.build());
        writeActionsBuilder.setAction(actions);
        writeActionsCaseBuilder.setWriteActions(writeActionsBuilder.build());
        builderInstruction.setInstructionChoice((InstructionChoice)writeActionsCaseBuilder.build());
        instructions.add(builderInstruction.build());
        builderInstruction = new InstructionBuilder();
        ApplyActionsCaseBuilder applyActionsCaseBuilder = new ApplyActionsCaseBuilder();
        ApplyActionsBuilder applyActionsBuilder = new ApplyActionsBuilder();
        actions = new ArrayList();
        actionBuilder = new ActionBuilder();
        PushVlanCaseBuilder vlanCaseBuilder = new PushVlanCaseBuilder();
        PushVlanActionBuilder vlanBuilder = new PushVlanActionBuilder();
        vlanBuilder.setEthertype(new EtherType(new EtherType(Integer.valueOf(14))));
        vlanCaseBuilder.setPushVlanAction(vlanBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)vlanCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice((ActionChoice)new PopPbbCaseBuilder().build());
        actions.add(actionBuilder.build());
        applyActionsBuilder.setAction(actions);
        applyActionsCaseBuilder.setApplyActions(applyActionsBuilder.build());
        builderInstruction.setInstructionChoice((InstructionChoice)applyActionsCaseBuilder.build());
        instructions.add(builderInstruction.build());
        builder.setInstruction(instructions);
        ArrayList<FlowStats> list = new ArrayList<FlowStats>();
        list.add(builder.build());
        return list;
    }

    private static MultipartRequestFlags createMultipartRequestFlags(int input) {
        Boolean one = (input & 1) > 0;
        return new MultipartRequestFlags(one);
    }

    private static MultipartReplyDescCase decodeDescBody(ByteBuf output) {
        MultipartReplyDescCaseBuilder descCase = new MultipartReplyDescCaseBuilder();
        MultipartReplyDescBuilder desc = new MultipartReplyDescBuilder();
        byte[] mfrDesc = new byte[256];
        output.readBytes(mfrDesc);
        desc.setMfrDesc(new String(mfrDesc).trim());
        byte[] hwDesc = new byte[256];
        output.readBytes(hwDesc);
        desc.setHwDesc(new String(hwDesc).trim());
        byte[] swDesc = new byte[256];
        output.readBytes(swDesc);
        desc.setSwDesc(new String(swDesc).trim());
        byte[] serialNumber = new byte[32];
        output.readBytes(serialNumber);
        desc.setSerialNum(new String(serialNumber).trim());
        byte[] dpDesc = new byte[256];
        output.readBytes(dpDesc);
        desc.setDpDesc(new String(dpDesc).trim());
        descCase.setMultipartReplyDesc(desc.build());
        return descCase.build();
    }
}

