/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestAggregateCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestFlowCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterConfigCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterConfigCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortStatsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestQueueCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.aggregate._case.MultipartRequestAggregateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.desc._case.MultipartRequestDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.flow._case.MultipartRequestFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.group._case.MultipartRequestGroupBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.meter._case.MultipartRequestMeterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.meter.config._case.MultipartRequestMeterConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.port.stats._case.MultipartRequestPortStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.queue._case.MultipartRequestQueueBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class MultipartRequestInputFactoryTest {
    public static final byte PADDING_IN_MULTIPART_REQUEST_MESSAGE = 4;
    private SerializerRegistry registry;
    private OFSerializer<MultipartRequestInput> multipartFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.multipartFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, MultipartRequestInput.class));
    }

    @Test
    public void testMultipartRequestFlowInputFactory() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setType(MultipartType.forValue((int)1));
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setMultipartRequestBody((MultipartRequestBody)MultipartRequestInputFactoryTest.createRequestFlow());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)18, 48);
        Assert.assertEquals((String)"Wrong type", (long)message.getType().getIntValue(), (long)out.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartRequestInputFactoryTest.decodeMultipartRequestFlags(out.readShort()));
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong flow", (Object)message.getMultipartRequestBody(), (Object)MultipartRequestInputFactoryTest.decodeRequestFlow(out));
    }

    private static MultipartRequestFlowCase createRequestFlow() {
        MultipartRequestFlowCaseBuilder caseBuilder = new MultipartRequestFlowCaseBuilder();
        MultipartRequestFlowBuilder builder = new MultipartRequestFlowBuilder();
        builder.setTableId(Short.valueOf((short)8));
        builder.setOutPort(Long.valueOf(85L));
        builder.setOutGroup(Long.valueOf(95L));
        byte[] cookie = new byte[]{0, 1, 1, 1, 1, 1, 1, 1};
        builder.setCookie(new BigInteger(1, cookie));
        byte[] cookieMask = new byte[]{0, 1, 1, 1, 1, 1, 1, 1};
        builder.setCookieMask(new BigInteger(1, cookieMask));
        caseBuilder.setMultipartRequestFlow(builder.build());
        return caseBuilder.build();
    }

    private static MultipartRequestFlowCase decodeRequestFlow(ByteBuf output) {
        int PADDING_IN_MULTIPART_REQUEST_FLOW_BODY_01 = 3;
        int PADDING_IN_MULTIPART_REQUEST_FLOW_BODY_02 = 4;
        MultipartRequestFlowCaseBuilder caseBuilder = new MultipartRequestFlowCaseBuilder();
        MultipartRequestFlowBuilder builder = new MultipartRequestFlowBuilder();
        builder.setTableId(Short.valueOf(output.readUnsignedByte()));
        output.skipBytes(3);
        builder.setOutPort(Long.valueOf(output.readUnsignedInt()));
        builder.setOutGroup(Long.valueOf(output.readUnsignedInt()));
        output.skipBytes(4);
        byte[] cookie = new byte[8];
        output.readBytes(cookie);
        builder.setCookie(new BigInteger(1, cookie));
        byte[] cookieMask = new byte[8];
        output.readBytes(cookieMask);
        builder.setCookieMask(new BigInteger(1, cookieMask));
        caseBuilder.setMultipartRequestFlow(builder.build());
        return caseBuilder.build();
    }

    @Test
    public void testMultipartRequestInputAggregateBodyFactory() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setType(MultipartType.forValue((int)2));
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setMultipartRequestBody((MultipartRequestBody)MultipartRequestInputFactoryTest.createRequestAggregate());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)18, 48);
        Assert.assertEquals((String)"Wrong type", (long)message.getType().getIntValue(), (long)out.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartRequestInputFactoryTest.decodeMultipartRequestFlags(out.readShort()));
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong aggregate", (Object)message.getMultipartRequestBody(), (Object)MultipartRequestInputFactoryTest.decodeRequestAggregate(out));
    }

    private static MultipartRequestFlags decodeMultipartRequestFlags(short input) {
        Boolean _oFPMPFREQMORE = (input & 1) > 0;
        return new MultipartRequestFlags(_oFPMPFREQMORE);
    }

    private static MultipartRequestAggregateCase createRequestAggregate() {
        MultipartRequestAggregateCaseBuilder caseBuilder = new MultipartRequestAggregateCaseBuilder();
        MultipartRequestAggregateBuilder builder = new MultipartRequestAggregateBuilder();
        builder.setTableId(Short.valueOf((short)8));
        builder.setOutPort(Long.valueOf(85L));
        builder.setOutGroup(Long.valueOf(95L));
        byte[] cookie = new byte[]{0, 1, 1, 1, 1, 1, 1, 1};
        builder.setCookie(new BigInteger(1, cookie));
        byte[] cookieMask = new byte[]{0, 1, 1, 1, 1, 1, 1, 1};
        builder.setCookieMask(new BigInteger(1, cookieMask));
        caseBuilder.setMultipartRequestAggregate(builder.build());
        return caseBuilder.build();
    }

    private static MultipartRequestAggregateCase decodeRequestAggregate(ByteBuf output) {
        int PADDING_IN_MULTIPART_REQUEST_AGGREGATE_BODY_01 = 3;
        int PADDING_IN_MULTIPART_REQUEST_AGGREGATE_BODY_02 = 4;
        MultipartRequestAggregateCaseBuilder caseBuilder = new MultipartRequestAggregateCaseBuilder();
        MultipartRequestAggregateBuilder builder = new MultipartRequestAggregateBuilder();
        builder.setTableId(Short.valueOf(output.readUnsignedByte()));
        output.skipBytes(3);
        builder.setOutPort(Long.valueOf(output.readUnsignedInt()));
        builder.setOutGroup(Long.valueOf(output.readUnsignedInt()));
        output.skipBytes(4);
        byte[] cookie = new byte[8];
        output.readBytes(cookie);
        builder.setCookie(new BigInteger(1, cookie));
        byte[] cookieMask = new byte[8];
        output.readBytes(cookieMask);
        builder.setCookieMask(new BigInteger(1, cookieMask));
        caseBuilder.setMultipartRequestAggregate(builder.build());
        return caseBuilder.build();
    }

    @Test
    public void testMultipartRequestInputTableFactory() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setType(MultipartType.forValue((int)3));
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)18, 16);
        Assert.assertEquals((String)"Wrong type", (long)message.getType().getIntValue(), (long)out.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartRequestInputFactoryTest.decodeMultipartRequestFlags(out.readShort()));
        out.skipBytes(4);
    }

    @Test
    public void testMultipartRequestPortStatsMessageFactory() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setType(MultipartType.forValue((int)4));
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setMultipartRequestBody((MultipartRequestBody)MultipartRequestInputFactoryTest.createRequestPortStats());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)18, 24);
        Assert.assertEquals((String)"Wrong type", (long)message.getType().getIntValue(), (long)out.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartRequestInputFactoryTest.decodeMultipartRequestFlags(out.readShort()));
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong portStatsBody", (Object)message.getMultipartRequestBody(), (Object)MultipartRequestInputFactoryTest.decodeRequestPortStats(out));
    }

    private static MultipartRequestPortStatsCase createRequestPortStats() {
        MultipartRequestPortStatsCaseBuilder caseBuilder = new MultipartRequestPortStatsCaseBuilder();
        MultipartRequestPortStatsBuilder builder = new MultipartRequestPortStatsBuilder();
        builder.setPortNo(Long.valueOf(2251L));
        caseBuilder.setMultipartRequestPortStats(builder.build());
        return caseBuilder.build();
    }

    private static MultipartRequestPortStatsCase decodeRequestPortStats(ByteBuf output) {
        int PADDING_IN_MULTIPART_REQUEST_PORTSTATS_BODY = 4;
        MultipartRequestPortStatsCaseBuilder caseBuilder = new MultipartRequestPortStatsCaseBuilder();
        MultipartRequestPortStatsBuilder builder = new MultipartRequestPortStatsBuilder();
        builder.setPortNo(Long.valueOf(output.readUnsignedInt()));
        output.skipBytes(4);
        caseBuilder.setMultipartRequestPortStats(builder.build());
        return caseBuilder.build();
    }

    @Test
    public void testMultipartRequestQueueMessageFactory() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setType(MultipartType.forValue((int)5));
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setMultipartRequestBody((MultipartRequestBody)MultipartRequestInputFactoryTest.createRequestQueue());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)18, 24);
        Assert.assertEquals((String)"Wrong type", (long)message.getType().getIntValue(), (long)out.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartRequestInputFactoryTest.decodeMultipartRequestFlags(out.readShort()));
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong queueBody", (Object)message.getMultipartRequestBody(), (Object)MultipartRequestInputFactoryTest.decodeRequestQueue(out));
    }

    private static MultipartRequestQueueCase createRequestQueue() {
        MultipartRequestQueueCaseBuilder caseBuilder = new MultipartRequestQueueCaseBuilder();
        MultipartRequestQueueBuilder builder = new MultipartRequestQueueBuilder();
        builder.setPortNo(Long.valueOf(2256L));
        builder.setQueueId(Long.valueOf(2211L));
        caseBuilder.setMultipartRequestQueue(builder.build());
        return caseBuilder.build();
    }

    private static MultipartRequestQueueCase decodeRequestQueue(ByteBuf output) {
        MultipartRequestQueueCaseBuilder caseBuilder = new MultipartRequestQueueCaseBuilder();
        MultipartRequestQueueBuilder builder = new MultipartRequestQueueBuilder();
        builder.setPortNo(Long.valueOf(output.readUnsignedInt()));
        builder.setQueueId(Long.valueOf(output.readUnsignedInt()));
        caseBuilder.setMultipartRequestQueue(builder.build());
        return caseBuilder.build();
    }

    @Test
    public void testMultipartRequestGroupMessageFactory() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setType(MultipartType.forValue((int)6));
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setMultipartRequestBody((MultipartRequestBody)MultipartRequestInputFactoryTest.createRequestGroup());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)18, 24);
        Assert.assertEquals((String)"Wrong type", (long)message.getType().getIntValue(), (long)out.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartRequestInputFactoryTest.decodeMultipartRequestFlags(out.readShort()));
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong groupBody", (Object)message.getMultipartRequestBody(), (Object)MultipartRequestInputFactoryTest.decodeRequestGroup(out));
    }

    private static MultipartRequestGroupCase createRequestGroup() {
        MultipartRequestGroupCaseBuilder caseBuilder = new MultipartRequestGroupCaseBuilder();
        MultipartRequestGroupBuilder builder = new MultipartRequestGroupBuilder();
        builder.setGroupId(new GroupId(Long.valueOf(2258L)));
        caseBuilder.setMultipartRequestGroup(builder.build());
        return caseBuilder.build();
    }

    private static MultipartRequestGroupCase decodeRequestGroup(ByteBuf output) {
        int PADDING_IN_MULTIPART_REQUEST_GROUP_BODY = 4;
        MultipartRequestGroupCaseBuilder caseBuilder = new MultipartRequestGroupCaseBuilder();
        MultipartRequestGroupBuilder builder = new MultipartRequestGroupBuilder();
        builder.setGroupId(new GroupId(Long.valueOf(output.readUnsignedInt())));
        output.skipBytes(4);
        caseBuilder.setMultipartRequestGroup(builder.build());
        return caseBuilder.build();
    }

    @Test
    public void testMultipartRequestMeterMessageFactory() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setType(MultipartType.forValue((int)9));
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setMultipartRequestBody((MultipartRequestBody)MultipartRequestInputFactoryTest.createRequestMeter());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)18, 24);
        Assert.assertEquals((String)"Wrong type", (long)message.getType().getIntValue(), (long)out.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartRequestInputFactoryTest.decodeMultipartRequestFlags(out.readShort()));
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong meterBody", (Object)message.getMultipartRequestBody(), (Object)MultipartRequestInputFactoryTest.decodeRequestMeter(out));
    }

    private static MultipartRequestMeterCase createRequestMeter() {
        MultipartRequestMeterCaseBuilder caseBuilder = new MultipartRequestMeterCaseBuilder();
        MultipartRequestMeterBuilder builder = new MultipartRequestMeterBuilder();
        builder.setMeterId(new MeterId(Long.valueOf(1121L)));
        caseBuilder.setMultipartRequestMeter(builder.build());
        return caseBuilder.build();
    }

    private static MultipartRequestMeterCase decodeRequestMeter(ByteBuf output) {
        int PADDING_IN_MULTIPART_REQUEST_METER_BODY = 4;
        MultipartRequestMeterCaseBuilder caseBuilder = new MultipartRequestMeterCaseBuilder();
        MultipartRequestMeterBuilder builder = new MultipartRequestMeterBuilder();
        builder.setMeterId(new MeterId(Long.valueOf(output.readUnsignedInt())));
        output.skipBytes(4);
        caseBuilder.setMultipartRequestMeter(builder.build());
        return caseBuilder.build();
    }

    @Test
    public void testMultipartRequestMeterConfigMessageFactory() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setType(MultipartType.forValue((int)10));
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setMultipartRequestBody((MultipartRequestBody)MultipartRequestInputFactoryTest.createRequestMeterConfig());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)18, 24);
        Assert.assertEquals((String)"Wrong type", (long)message.getType().getIntValue(), (long)out.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartRequestInputFactoryTest.decodeMultipartRequestFlags(out.readShort()));
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong meterConfigBody", (Object)message.getMultipartRequestBody(), (Object)MultipartRequestInputFactoryTest.decodeRequestMeterConfig(out));
    }

    private static MultipartRequestMeterConfigCase createRequestMeterConfig() {
        MultipartRequestMeterConfigCaseBuilder caseBuilder = new MultipartRequestMeterConfigCaseBuilder();
        MultipartRequestMeterConfigBuilder builder = new MultipartRequestMeterConfigBuilder();
        builder.setMeterId(new MeterId(Long.valueOf(1133L)));
        caseBuilder.setMultipartRequestMeterConfig(builder.build());
        return caseBuilder.build();
    }

    private static MultipartRequestMeterConfigCase decodeRequestMeterConfig(ByteBuf output) {
        int PADDING_IN_MULTIPART_REQUEST_METER_CONFIG_BODY = 4;
        MultipartRequestMeterConfigCaseBuilder caseBuilder = new MultipartRequestMeterConfigCaseBuilder();
        MultipartRequestMeterConfigBuilder builder = new MultipartRequestMeterConfigBuilder();
        builder.setMeterId(new MeterId(Long.valueOf(output.readUnsignedInt())));
        output.skipBytes(4);
        caseBuilder.setMultipartRequestMeterConfig(builder.build());
        return caseBuilder.build();
    }

    @Test
    public void testMultipartRequestDescMessageFactory() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setType(MultipartType.forValue((int)0));
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setMultipartRequestBody(MultipartRequestInputFactoryTest.createRequestDesc());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)18, 16);
        Assert.assertEquals((String)"Wrong type", (long)message.getType().getIntValue(), (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)MultipartRequestInputFactoryTest.decodeMultipartRequestFlags(out.readShort()));
    }

    private static MultipartRequestBody createRequestDesc() {
        MultipartRequestDescCaseBuilder caseBuilder = new MultipartRequestDescCaseBuilder();
        MultipartRequestDescBuilder builder = new MultipartRequestDescBuilder();
        caseBuilder.setMultipartRequestDesc(builder.build());
        return caseBuilder.build();
    }
}

