/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10BarrierInputMessageFactoryTest {
    private SerializerRegistry registry;
    private OFSerializer<BarrierInput> barrierFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.barrierFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(1, BarrierInput.class));
    }

    @Test
    public void test() throws Exception {
        BarrierInputBuilder bib = new BarrierInputBuilder();
        BufferHelper.setupHeader(bib, 1);
        BarrierInput bi = bib.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.barrierFactory.serialize((DataContainer)bi, out);
        BufferHelper.checkHeaderV10(out, (byte)18, 8);
    }
}

