/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierOutputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10BarrierReplyMessageFactoryTest {
    private OFSerializer<BarrierOutput> factory;
    private static final byte MESSAGE_TYPE = 19;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(1, BarrierOutput.class));
    }

    @Test
    public void testSerialize() throws Exception {
        BarrierOutputBuilder builder = new BarrierOutputBuilder();
        BufferHelper.setupHeader(builder, 1);
        BarrierOutput message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV10(serializedBuffer, (byte)19, 8);
    }
}

