/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ActionTypeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.CapabilitiesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortStateV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.features.reply.PhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.features.reply.PhyPortBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10FeaturesReplyMessageFactoryTest {
    private OFSerializer<GetFeaturesOutput> factory;
    private static final byte MESSAGE_TYPE = 6;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(1, GetFeaturesOutput.class));
    }

    @Test
    public void testSerialize() throws Exception {
        GetFeaturesOutputBuilder builder = new GetFeaturesOutputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setDatapathId(BigInteger.valueOf(1L));
        builder.setBuffers(Long.valueOf(1L));
        builder.setTables(Short.valueOf((short)1));
        builder.setCapabilitiesV10(new CapabilitiesV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setActionsV10(new ActionTypeV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)));
        builder.setPhyPort(OF10FeaturesReplyMessageFactoryTest.createPorts());
        GetFeaturesOutput message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV10(serializedBuffer, (byte)6, 80);
        Assert.assertEquals((String)"Wrong datapath id", (long)message.getDatapathId().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong n buffers", (long)message.getBuffers(), (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong n tables", (long)message.getTables().shortValue(), (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(3);
        Assert.assertEquals((String)"Wrong capabilities", (Object)message.getCapabilitiesV10(), (Object)OF10FeaturesReplyMessageFactoryTest.createCapabilities(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong actions", (Object)message.getActionsV10(), (Object)OF10FeaturesReplyMessageFactoryTest.createActionsV10(serializedBuffer.readInt()));
        PhyPort port = (PhyPort)message.getPhyPort().get(0);
        Assert.assertEquals((String)"Wrong port No", (long)port.getPortNo().intValue(), (long)serializedBuffer.readShort());
        byte[] address = new byte[6];
        serializedBuffer.readBytes(address);
        Assert.assertEquals((String)"Wrong MacAddress", (Object)port.getHwAddr().getValue().toLowerCase(), (Object)new MacAddress(ByteBufUtils.macAddressToString((byte[])address)).getValue().toLowerCase());
        byte[] name = new byte[16];
        serializedBuffer.readBytes(name);
        Assert.assertEquals((String)"Wrong name", (Object)port.getName(), (Object)new String(name).trim());
        Assert.assertEquals((String)"Wrong config", (Object)port.getConfigV10(), (Object)OF10FeaturesReplyMessageFactoryTest.createPortConfig(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong state", (Object)port.getStateV10(), (Object)OF10FeaturesReplyMessageFactoryTest.createPortState(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong current", (Object)port.getCurrentFeaturesV10(), (Object)OF10FeaturesReplyMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong advertised", (Object)port.getAdvertisedFeaturesV10(), (Object)OF10FeaturesReplyMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong supported", (Object)port.getSupportedFeaturesV10(), (Object)OF10FeaturesReplyMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong peer", (Object)port.getPeerFeaturesV10(), (Object)OF10FeaturesReplyMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
    }

    private static List<PhyPort> createPorts() {
        ArrayList<PhyPort> ports = new ArrayList<PhyPort>();
        PhyPortBuilder builder = new PhyPortBuilder();
        builder.setPortNo(Long.valueOf(1L));
        builder.setHwAddr(new MacAddress("94:de:80:a6:61:40"));
        builder.setName("Port name");
        builder.setConfigV10(new PortConfigV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)));
        builder.setStateV10(new PortStateV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setCurrentFeaturesV10(new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setAdvertisedFeaturesV10(new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setSupportedFeaturesV10(new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setPeerFeaturesV10(new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        ports.add(builder.build());
        return ports;
    }

    private static PortConfigV10 createPortConfig(long input) {
        Boolean _portDown = (input & 1L) > 0L;
        Boolean _noStp = (input & 2L) > 0L;
        Boolean _noRecv = (input & 4L) > 0L;
        Boolean _noRecvStp = (input & 8L) > 0L;
        Boolean _noFlood = (input & 0x10L) > 0L;
        Boolean _noFwd = (input & 0x20L) > 0L;
        Boolean _noPacketIn = (input & 0x40L) > 0L;
        return new PortConfigV10(_noFlood, _noFwd, _noPacketIn, _noRecv, _noRecvStp, _noStp, _portDown);
    }

    private static PortFeaturesV10 createPortFeatures(long input) {
        Boolean _10mbHd = (input & 1L) > 0L;
        Boolean _10mbFd = (input & 2L) > 0L;
        Boolean _100mbHd = (input & 4L) > 0L;
        Boolean _100mbFd = (input & 8L) > 0L;
        Boolean _1gbHd = (input & 0x10L) > 0L;
        Boolean _1gbFd = (input & 0x20L) > 0L;
        Boolean _10gbFd = (input & 0x40L) > 0L;
        Boolean _copper = (input & 0x80L) > 0L;
        Boolean _fiber = (input & 0x100L) > 0L;
        Boolean _autoneg = (input & 0x200L) > 0L;
        Boolean _pause = (input & 0x400L) > 0L;
        Boolean _pauseAsym = (input & 0x800L) > 0L;
        return new PortFeaturesV10(_100mbFd, _100mbHd, _10gbFd, _10mbFd, _10mbHd, _1gbFd, _1gbHd, _autoneg, _copper, _fiber, _pause, _pauseAsym);
    }

    private static PortStateV10 createPortState(long input) {
        Boolean _linkDown = (input & 1L) > 0L;
        Boolean _blocked = (input & 2L) > 0L;
        Boolean _live = (input & 4L) > 0L;
        Boolean _stpListen = (input & 8L) > 0L;
        Boolean _stpLearn = (input & 0x10L) > 0L;
        Boolean _stpForward = (input & 0x20L) > 0L;
        Boolean _stpBlock = (input & 0x40L) > 0L;
        Boolean _stpMask = (input & 0x80L) > 0L;
        return new PortStateV10(_blocked, _linkDown, _live, _stpBlock, _stpForward, _stpLearn, _stpListen, _stpMask);
    }

    private static CapabilitiesV10 createCapabilities(long input) {
        Boolean _oFPCFLOWSTATS = (input & 1L) > 0L;
        Boolean _oFPCTABLESTATS = (input & 2L) > 0L;
        Boolean _oFPCPORTSTATS = (input & 4L) > 0L;
        Boolean _oFPCSTP = (input & 8L) > 0L;
        Boolean _oFPCRESERVED = (input & 0x10L) > 0L;
        Boolean _oFPCIPREASM = (input & 0x20L) > 0L;
        Boolean _oFPCQUEUESTATS = (input & 0x40L) > 0L;
        Boolean _oFPCARPMATCHIP = (input & 0x80L) > 0L;
        return new CapabilitiesV10(_oFPCARPMATCHIP, _oFPCFLOWSTATS, _oFPCIPREASM, _oFPCPORTSTATS, _oFPCQUEUESTATS, _oFPCRESERVED, _oFPCSTP, _oFPCTABLESTATS);
    }

    private static ActionTypeV10 createActionsV10(long input) {
        Boolean _oFPATOUTPUT = (input & 1L) > 0L;
        Boolean _oFPATSETVLANVID = (input & 2L) > 0L;
        Boolean _oFPATSETVLANPCP = (input & 4L) > 0L;
        Boolean _oFPATSTRIPVLAN = (input & 8L) > 0L;
        Boolean _oFPATSETDLSRC = (input & 0x10L) > 0L;
        Boolean _oFPATSETDLDST = (input & 0x20L) > 0L;
        Boolean _oFPATSETNWSRC = (input & 0x40L) > 0L;
        Boolean _oFPATSETNWDST = (input & 0x80L) > 0L;
        Boolean _oFPATSETNWTOS = (input & 0x100L) > 0L;
        Boolean _oFPATSETTPSRC = (input & 0x200L) > 0L;
        Boolean _oFPATSETTPDST = (input & 0x400L) > 0L;
        Boolean _oFPATENQUEUE = (input & 0x800L) > 0L;
        Boolean _oFPATVENDOR = (input & 0x1000L) > 0L;
        return new ActionTypeV10(_oFPATENQUEUE, _oFPATOUTPUT, _oFPATSETDLDST, _oFPATSETDLSRC, _oFPATSETNWDST, _oFPATSETNWSRC, _oFPATSETNWTOS, _oFPATSETTPDST, _oFPATSETTPSRC, _oFPATSETVLANPCP, _oFPATSETVLANVID, _oFPATSTRIPVLAN, _oFPATVENDOR);
    }
}

