/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigInteger;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetNwDstCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetTpSrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.nw.dst._case.SetNwDstActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.tp.src._case.SetTpSrcActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlagsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10FlowModInputMessageFactoryTest {
    private SerializerRegistry registry;
    private OFSerializer<FlowModInput> flowModFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.flowModFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(1, FlowModInput.class));
    }

    @Test
    public void testFlowModInputMessageFactory() throws Exception {
        FlowModInputBuilder builder = new FlowModInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        MatchV10Builder matchBuilder = new MatchV10Builder();
        matchBuilder.setWildcards(new FlowWildcardsV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
        matchBuilder.setNwSrcMask(Short.valueOf((short)0));
        matchBuilder.setNwDstMask(Short.valueOf((short)0));
        matchBuilder.setInPort(Integer.valueOf(58));
        matchBuilder.setDlSrc(new MacAddress("01:01:01:01:01:01"));
        matchBuilder.setDlDst(new MacAddress("ff:ff:ff:ff:ff:ff"));
        matchBuilder.setDlVlan(Integer.valueOf(18));
        matchBuilder.setDlVlanPcp(Short.valueOf((short)5));
        matchBuilder.setDlType(Integer.valueOf(42));
        matchBuilder.setNwTos(Short.valueOf((short)4));
        matchBuilder.setNwProto(Short.valueOf((short)7));
        matchBuilder.setNwSrc(new Ipv4Address("8.8.8.8"));
        matchBuilder.setNwDst(new Ipv4Address("16.16.16.16"));
        matchBuilder.setTpSrc(Integer.valueOf(6653));
        matchBuilder.setTpDst(Integer.valueOf(6633));
        builder.setMatchV10(matchBuilder.build());
        byte[] cookie = new byte[]{-1, 1, 4, 1, 6, 0, 7, 1};
        builder.setCookie(new BigInteger(1, cookie));
        builder.setCommand(FlowModCommand.forValue((int)0));
        builder.setIdleTimeout(Integer.valueOf(12));
        builder.setHardTimeout(Integer.valueOf(16));
        builder.setPriority(Integer.valueOf(1));
        builder.setBufferId(Long.valueOf(2L));
        builder.setOutPort(new PortNumber(Long.valueOf(4422L)));
        builder.setFlagsV10(new FlowModFlagsV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)));
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        SetNwDstCaseBuilder nwDstCaseBuilder = new SetNwDstCaseBuilder();
        SetNwDstActionBuilder nwDstBuilder = new SetNwDstActionBuilder();
        nwDstBuilder.setIpAddress(new Ipv4Address("2.2.2.2"));
        nwDstCaseBuilder.setSetNwDstAction(nwDstBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)nwDstCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetTpSrcCaseBuilder tpSrcCaseBuilder = new SetTpSrcCaseBuilder();
        SetTpSrcActionBuilder tpSrcBuilder = new SetTpSrcActionBuilder();
        tpSrcBuilder.setPort(new PortNumber(Long.valueOf(42L)));
        tpSrcCaseBuilder.setSetTpSrcAction(tpSrcBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)tpSrcCaseBuilder.build());
        actions.add(actionBuilder.build());
        builder.setAction(actions);
        FlowModInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.flowModFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV10(out, (byte)14, 88);
        Assert.assertEquals((String)"Wrong wildcards", (long)3678463L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong inPort", (long)58L, (long)out.readUnsignedShort());
        byte[] dlSrc = new byte[6];
        out.readBytes(dlSrc);
        Assert.assertEquals((String)"Wrong dlSrc", (Object)"01:01:01:01:01:01", (Object)ByteBufUtils.macAddressToString((byte[])dlSrc));
        byte[] dlDst = new byte[6];
        out.readBytes(dlDst);
        Assert.assertEquals((String)"Wrong dlDst", (Object)"FF:FF:FF:FF:FF:FF", (Object)ByteBufUtils.macAddressToString((byte[])dlDst));
        Assert.assertEquals((String)"Wrong dlVlan", (long)18L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong dlVlanPcp", (long)5L, (long)out.readUnsignedByte());
        out.skipBytes(1);
        Assert.assertEquals((String)"Wrong dlType", (long)42L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong nwTos", (long)4L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong nwProto", (long)7L, (long)out.readUnsignedByte());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong nwSrc", (long)0x8080808L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong nwDst", (long)0x10101010L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong tpSrc", (long)6653L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong tpDst", (long)6633L, (long)out.readUnsignedShort());
        byte[] cookieRead = new byte[8];
        out.readBytes(cookieRead);
        Assert.assertArrayEquals((String)"Wrong cookie", (byte[])cookie, (byte[])cookieRead);
        Assert.assertEquals((String)"Wrong command", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong idleTimeOut", (long)12L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong hardTimeOut", (long)16L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong priority", (long)1L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong bufferId", (long)2L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong outPort", (long)4422L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)3L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action - type", (long)7L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action - length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)0x2020202L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong action - type", (long)9L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action - length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)42L, (long)out.readUnsignedShort());
        out.skipBytes(2);
    }
}

