/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessageBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10FlowRemovedMessageFactoryTest {
    private OFSerializer<FlowRemovedMessage> factory;
    private static final byte MESSAGE_TYPE = 11;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(1, FlowRemovedMessage.class));
    }

    @Test
    public void testSerialize() throws Exception {
        FlowRemovedMessageBuilder builder = new FlowRemovedMessageBuilder();
        BufferHelper.setupHeader(builder, 1);
        MatchV10Builder matchBuilder = new MatchV10Builder();
        matchBuilder.setWildcards(new FlowWildcardsV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
        matchBuilder.setNwSrcMask(Short.valueOf((short)0));
        matchBuilder.setNwDstMask(Short.valueOf((short)0));
        matchBuilder.setInPort(Integer.valueOf(58));
        matchBuilder.setDlSrc(new MacAddress("01:01:01:01:01:01"));
        matchBuilder.setDlDst(new MacAddress("ff:ff:ff:ff:ff:ff"));
        matchBuilder.setDlVlan(Integer.valueOf(18));
        matchBuilder.setDlVlanPcp(Short.valueOf((short)5));
        matchBuilder.setDlType(Integer.valueOf(42));
        matchBuilder.setNwTos(Short.valueOf((short)4));
        matchBuilder.setNwProto(Short.valueOf((short)7));
        matchBuilder.setNwSrc(new Ipv4Address("8.8.8.8"));
        matchBuilder.setNwDst(new Ipv4Address("16.16.16.16"));
        matchBuilder.setTpSrc(Integer.valueOf(6653));
        matchBuilder.setTpDst(Integer.valueOf(6633));
        builder.setMatchV10(matchBuilder.build());
        byte[] cookie = new byte[]{-1, 1, 4, 1, 1, 1, 4, 1};
        builder.setCookie(new BigInteger(1, cookie));
        builder.setPriority(Integer.valueOf(1));
        builder.setReason(FlowRemovedReason.forValue((int)1));
        builder.setDurationSec(Long.valueOf(1L));
        builder.setDurationNsec(Long.valueOf(1L));
        builder.setIdleTimeout(Integer.valueOf(12));
        builder.setPacketCount(BigInteger.valueOf(1L));
        builder.setByteCount(BigInteger.valueOf(2L));
        FlowRemovedMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV10(serializedBuffer, (byte)11, 88);
        Assert.assertEquals((String)"Wrong wildcards", (long)3678463L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong inPort", (long)58L, (long)serializedBuffer.readUnsignedShort());
        byte[] dlSrc = new byte[6];
        serializedBuffer.readBytes(dlSrc);
        Assert.assertEquals((String)"Wrong dlSrc", (Object)"01:01:01:01:01:01", (Object)ByteBufUtils.macAddressToString((byte[])dlSrc));
        byte[] dlDst = new byte[6];
        serializedBuffer.readBytes(dlDst);
        Assert.assertEquals((String)"Wrong dlDst", (Object)"FF:FF:FF:FF:FF:FF", (Object)ByteBufUtils.macAddressToString((byte[])dlDst));
        Assert.assertEquals((String)"Wrong dlVlan", (long)18L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong dlVlanPcp", (long)5L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(1);
        Assert.assertEquals((String)"Wrong dlType", (long)42L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong nwTos", (long)4L, (long)serializedBuffer.readUnsignedByte());
        Assert.assertEquals((String)"Wrong nwProto", (long)7L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(2);
        Assert.assertEquals((String)"Wrong nwSrc", (long)0x8080808L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong nwDst", (long)0x10101010L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong tpSrc", (long)6653L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong tpDst", (long)6633L, (long)serializedBuffer.readUnsignedShort());
        byte[] cookieRead = new byte[8];
        serializedBuffer.readBytes(cookieRead);
        Assert.assertArrayEquals((String)"Wrong cookie", (byte[])cookie, (byte[])cookieRead);
        Assert.assertEquals((String)"Wrong priority", (long)1L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong reason", (long)1L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(1);
        Assert.assertEquals((String)"Wrong duration", (long)1L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong duration nsec", (long)1L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong idle timeout", (long)12L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(2);
        Assert.assertEquals((String)"Wrong packet count", (long)1L, (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong byte count", (long)2L, (long)serializedBuffer.readLong());
    }
}

