/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessageBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10PacketInMessageFactoryTest {
    private OFSerializer<PacketInMessage> factory;
    private static final byte MESSAGE_TYPE = 10;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(1, PacketInMessage.class));
    }

    @Test
    public void testSerialize() throws Exception {
        PacketInMessageBuilder builder = new PacketInMessageBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setBufferId(Long.valueOf(1L));
        builder.setTotalLen(Integer.valueOf(1));
        builder.setInPort(Integer.valueOf(1));
        builder.setReason(PacketInReason.forValue((int)0));
        byte[] data = ByteBufUtils.hexStringToBytes((String)"00 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14");
        builder.setData(data);
        PacketInMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV10(serializedBuffer, (byte)10, 34);
        Assert.assertEquals((String)"Wrong buffer id", (long)message.getBufferId(), (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong total len", (long)message.getTotalLen().intValue(), (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong port in", (long)message.getInPort().intValue(), (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong reason", (long)message.getReason().getIntValue(), (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(1);
        byte[] readData = new byte[serializedBuffer.readableBytes()];
        serializedBuffer.readBytes(readData);
        Assert.assertArrayEquals((String)"Wrong data", (byte[])message.getData(), (byte[])readData);
    }
}

