/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.StripVlanCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.output.action._case.OutputActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10PacketOutInputMessageFactoryTest {
    private SerializerRegistry registry;
    private OFSerializer<PacketOutInput> packetOutFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.packetOutFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(1, PacketOutInput.class));
    }

    @Test
    public void testPacketOutInputMessage() throws Exception {
        PacketOutInputBuilder builder = new PacketOutInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setBufferId(Long.valueOf(256L));
        builder.setInPort(new PortNumber(Long.valueOf(257L)));
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        OutputActionCaseBuilder caseBuilder = new OutputActionCaseBuilder();
        OutputActionBuilder outputBuilder = new OutputActionBuilder();
        outputBuilder.setPort(new PortNumber(Long.valueOf(42L)));
        outputBuilder.setMaxLength(Integer.valueOf(50));
        caseBuilder.setOutputAction(outputBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)caseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice((ActionChoice)new StripVlanCaseBuilder().build());
        builder.setAction(actions);
        actions.add(actionBuilder.build());
        builder.setAction(actions);
        builder.setData(ByteBufUtils.hexStringToBytes((String)"00 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14"));
        PacketOutInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.packetOutFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV10(out, (byte)13, 48);
        Assert.assertEquals((String)"Wrong BufferId", (long)256L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong PortNumber", (long)257L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong actions length", (long)16L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action type", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong port", (long)42L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong maxlength", (long)50L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action type", (long)3L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        byte[] readData = new byte[out.readableBytes()];
        out.readBytes(readData);
        Assert.assertArrayEquals((String)"Wrong data", (byte[])message.getData(), (byte[])readData);
        Assert.assertTrue((String)"Unread data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPacketOutInputWithNoData() throws Exception {
        PacketOutInputBuilder builder = new PacketOutInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setBufferId(Long.valueOf(256L));
        builder.setInPort(new PortNumber(Long.valueOf(257L)));
        ArrayList actions = new ArrayList();
        builder.setAction(actions);
        builder.setData(null);
        PacketOutInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.packetOutFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV10(out, (byte)13, 16);
        out.skipBytes(8);
        Assert.assertTrue((String)"Unread data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }
}

