/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10PortModInputMessageFactoryTest {
    private SerializerRegistry registry;
    private OFSerializer<PortModInput> portModFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.portModFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(1, PortModInput.class));
    }

    @Test
    public void testPortModInput() throws Exception {
        PortModInputBuilder builder = new PortModInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setPortNo(new PortNumber(Long.valueOf(6633L)));
        builder.setHwAddress(new MacAddress("08:00:27:00:B0:EB"));
        builder.setConfigV10(new PortConfigV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true)));
        builder.setMaskV10(new PortConfigV10(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setAdvertiseV10(new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)));
        PortModInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.portModFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV10(out, (byte)15, 32);
        Assert.assertEquals((String)"Wrong PortNo", (long)message.getPortNo().getValue(), (long)out.readUnsignedShort());
        byte[] address = new byte[6];
        out.readBytes(address);
        Assert.assertEquals((String)"Wrong MacAddress", (Object)message.getHwAddress(), (Object)new MacAddress(ByteBufUtils.macAddressToString((byte[])address)));
        Assert.assertEquals((String)"Wrong config", (long)21L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong mask", (long)98L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong advertise", (long)652L, (long)out.readUnsignedInt());
        out.skipBytes(4);
    }
}

