/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortStateV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessageBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10PortStatusMessageFactoryTest {
    private OFSerializer<PortStatusMessage> factory;
    private static final byte MESSAGE_TYPE = 12;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(1, PortStatusMessage.class));
    }

    @Test
    public void testSerialize() throws Exception {
        PortStatusMessageBuilder builder = new PortStatusMessageBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setReason(PortReason.forValue((int)1));
        builder.setPortNo(Long.valueOf(1L));
        builder.setHwAddr(new MacAddress("94:de:80:a6:61:40"));
        builder.setName("Port name");
        builder.setConfigV10(new PortConfigV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)));
        builder.setStateV10(new PortStateV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setCurrentFeaturesV10(new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setAdvertisedFeaturesV10(new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setSupportedFeaturesV10(new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setPeerFeaturesV10(new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        PortStatusMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV10(serializedBuffer, (byte)12, 64);
        Assert.assertEquals((String)"Wrong reason", (long)message.getReason().getIntValue(), (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(7);
        Assert.assertEquals((String)"Wrong port No", (long)message.getPortNo().intValue(), (long)serializedBuffer.readShort());
        byte[] address = new byte[6];
        serializedBuffer.readBytes(address);
        Assert.assertEquals((String)"Wrong MacAddress", (Object)message.getHwAddr().getValue().toLowerCase(), (Object)new MacAddress(ByteBufUtils.macAddressToString((byte[])address)).getValue().toLowerCase());
        byte[] name = new byte[16];
        serializedBuffer.readBytes(name);
        Assert.assertEquals((String)"Wrong name", (Object)message.getName(), (Object)new String(name).trim());
        Assert.assertEquals((String)"Wrong config", (Object)message.getConfigV10(), (Object)OF10PortStatusMessageFactoryTest.createPortConfig(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong state", (Object)message.getStateV10(), (Object)OF10PortStatusMessageFactoryTest.createPortState(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong current", (Object)message.getCurrentFeaturesV10(), (Object)OF10PortStatusMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong advertised", (Object)message.getAdvertisedFeaturesV10(), (Object)OF10PortStatusMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong supported", (Object)message.getSupportedFeaturesV10(), (Object)OF10PortStatusMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong peer", (Object)message.getPeerFeaturesV10(), (Object)OF10PortStatusMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
    }

    private static PortConfigV10 createPortConfig(long input) {
        Boolean _portDown = (input & 1L) > 0L;
        Boolean _noStp = (input & 2L) > 0L;
        Boolean _noRecv = (input & 4L) > 0L;
        Boolean _noRecvStp = (input & 8L) > 0L;
        Boolean _noFlood = (input & 0x10L) > 0L;
        Boolean _noFwd = (input & 0x20L) > 0L;
        Boolean _noPacketIn = (input & 0x40L) > 0L;
        return new PortConfigV10(_noFlood, _noFwd, _noPacketIn, _noRecv, _noRecvStp, _noStp, _portDown);
    }

    private static PortFeaturesV10 createPortFeatures(long input) {
        Boolean _10mbHd = (input & 1L) > 0L;
        Boolean _10mbFd = (input & 2L) > 0L;
        Boolean _100mbHd = (input & 4L) > 0L;
        Boolean _100mbFd = (input & 8L) > 0L;
        Boolean _1gbHd = (input & 0x10L) > 0L;
        Boolean _1gbFd = (input & 0x20L) > 0L;
        Boolean _10gbFd = (input & 0x40L) > 0L;
        Boolean _copper = (input & 0x80L) > 0L;
        Boolean _fiber = (input & 0x100L) > 0L;
        Boolean _autoneg = (input & 0x200L) > 0L;
        Boolean _pause = (input & 0x400L) > 0L;
        Boolean _pauseAsym = (input & 0x800L) > 0L;
        return new PortFeaturesV10(_100mbFd, _100mbHd, _10gbFd, _10mbFd, _10mbHd, _1gbFd, _1gbHd, _autoneg, _copper, _fiber, _pause, _pauseAsym);
    }

    private static PortStateV10 createPortState(long input) {
        Boolean _linkDown = (input & 1L) > 0L;
        Boolean _blocked = (input & 2L) > 0L;
        Boolean _live = (input & 4L) > 0L;
        Boolean _stpListen = (input & 8L) > 0L;
        Boolean _stpLearn = (input & 0x10L) > 0L;
        Boolean _stpForward = (input & 0x20L) > 0L;
        Boolean _stpBlock = (input & 0x40L) > 0L;
        Boolean _stpMask = (input & 0x80L) > 0L;
        return new PortStateV10(_blocked, _linkDown, _live, _stpBlock, _stpForward, _stpLearn, _stpListen, _stpMask);
    }
}

