/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10QueueGetConfigInputMessageFactoryTest {
    private SerializerRegistry registry;
    private OFSerializer<GetQueueConfigInput> queueFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.queueFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(1, GetQueueConfigInput.class));
    }

    @Test
    public void test() throws Exception {
        GetQueueConfigInputBuilder builder = new GetQueueConfigInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setPort(new PortNumber(Long.valueOf(6653L)));
        GetQueueConfigInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.queueFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV10(out, (byte)20, 12);
        Assert.assertEquals((String)"Wrong port", (long)6653L, (long)out.readUnsignedShort());
        out.skipBytes(2);
    }
}

