/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.RateQueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.RateQueuePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.QueuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueuePropertyBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10QueueGetConfigReplyMessageFactoryTest {
    private OFSerializer<GetQueueConfigOutput> factory;
    private static final byte MESSAGE_TYPE = 21;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(1, GetQueueConfigOutput.class));
    }

    @Test
    public void testSerialize() throws Exception {
        GetQueueConfigOutputBuilder builder = new GetQueueConfigOutputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setPort(new PortNumber(Long.valueOf(1L)));
        builder.setQueues(this.createQueues());
        GetQueueConfigOutput message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV10(serializedBuffer, (byte)21, 40);
        Assert.assertEquals((String)"Wrong port", (long)message.getPort().getValue(), (long)serializedBuffer.readShort());
        serializedBuffer.skipBytes(6);
        Assert.assertEquals((String)"Wrong queue Id", (long)((Queues)message.getQueues().get(0)).getQueueId().getValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong length", (long)24L, (long)serializedBuffer.readShort());
        serializedBuffer.skipBytes(2);
        List properties = ((Queues)message.getQueues().get(0)).getQueueProperty();
        Assert.assertEquals((String)"Wrong property", (long)((QueueProperty)properties.get(0)).getProperty().getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong property length", (long)16L, (long)serializedBuffer.readShort());
        serializedBuffer.skipBytes(4);
        RateQueueProperty rateQueueProperty = (RateQueueProperty)((QueueProperty)properties.get(0)).getAugmentation(RateQueueProperty.class);
        Assert.assertEquals((String)"Wrong rate", (long)rateQueueProperty.getRate().intValue(), (long)serializedBuffer.readShort());
        serializedBuffer.skipBytes(6);
    }

    private List<Queues> createQueues() {
        ArrayList<Queues> list = new ArrayList<Queues>();
        QueuesBuilder builder = new QueuesBuilder();
        builder.setQueueId(new QueueId(Long.valueOf(1L)));
        builder.setQueueProperty(OF10QueueGetConfigReplyMessageFactoryTest.createPropertiesList());
        list.add(builder.build());
        return list;
    }

    private static List<QueueProperty> createPropertiesList() {
        ArrayList<QueueProperty> propertiesList = new ArrayList<QueueProperty>();
        QueuePropertyBuilder pb = new QueuePropertyBuilder();
        pb.setProperty(QueueProperties.forValue((int)1));
        RateQueuePropertyBuilder rateBuilder = new RateQueuePropertyBuilder();
        rateBuilder.setRate(Integer.valueOf(5));
        pb.addAugmentation(RateQueueProperty.class, (Augmentation)rateBuilder.build());
        propertiesList.add(pb.build());
        return propertiesList;
    }
}

