/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.output.action._case.OutputActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.MultipartReplyBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyAggregateCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyFlowCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortStatsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyQueueCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.aggregate._case.MultipartReplyAggregateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.desc._case.MultipartReplyDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.MultipartReplyFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.MultipartReplyPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.MultipartReplyPortStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.MultipartReplyQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.MultipartReplyQueueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.MultipartReplyTableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStatsBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10StatsReplyMessageFactoryTest {
    private OFSerializer<MultipartReplyMessage> factory;
    private static final byte MESSAGE_TYPE = 17;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(1, MultipartReplyMessage.class));
    }

    @Test
    public void testDescBodySerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)0));
        MultipartReplyDescCaseBuilder descCase = new MultipartReplyDescCaseBuilder();
        MultipartReplyDescBuilder desc = new MultipartReplyDescBuilder();
        desc.setMfrDesc("Test");
        desc.setHwDesc("Test");
        desc.setSwDesc("Test");
        desc.setSerialNum("12345");
        desc.setDpDesc("Test");
        descCase.setMultipartReplyDesc(desc.build());
        builder.setMultipartReplyBody((MultipartReplyBody)descCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV10(serializedBuffer, (byte)17, 1068);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPDESC.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)OF10StatsReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        Assert.assertEquals((String)"Wrong desc body", (Object)message.getMultipartReplyBody(), (Object)OF10StatsReplyMessageFactoryTest.decodeDescBody(serializedBuffer));
    }

    @Test
    public void testFlowBodySerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)1));
        MultipartReplyFlowCaseBuilder flowCase = new MultipartReplyFlowCaseBuilder();
        MultipartReplyFlowBuilder flow = new MultipartReplyFlowBuilder();
        flow.setFlowStats(OF10StatsReplyMessageFactoryTest.createFlowStats());
        flowCase.setMultipartReplyFlow(flow.build());
        builder.setMultipartReplyBody((MultipartReplyBody)flowCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV10(serializedBuffer, (byte)17, 108);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPFLOW.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)OF10StatsReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        FlowStats flowStats = (FlowStats)flow.getFlowStats().get(0);
        Assert.assertEquals((String)"Wrong length", (long)96L, (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong Table ID", (long)flowStats.getTableId().intValue(), (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(1);
        Assert.assertEquals((String)"Wrong wildcards", (long)3678463L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong inPort", (long)58L, (long)serializedBuffer.readUnsignedShort());
        byte[] dlSrc = new byte[6];
        serializedBuffer.readBytes(dlSrc);
        Assert.assertEquals((String)"Wrong dlSrc", (Object)"01:01:01:01:01:01", (Object)ByteBufUtils.macAddressToString((byte[])dlSrc));
        byte[] dlDst = new byte[6];
        serializedBuffer.readBytes(dlDst);
        Assert.assertEquals((String)"Wrong dlDst", (Object)"FF:FF:FF:FF:FF:FF", (Object)ByteBufUtils.macAddressToString((byte[])dlDst));
        Assert.assertEquals((String)"Wrong dlVlan", (long)18L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong dlVlanPcp", (long)5L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(1);
        Assert.assertEquals((String)"Wrong dlType", (long)42L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong nwTos", (long)4L, (long)serializedBuffer.readUnsignedByte());
        Assert.assertEquals((String)"Wrong nwProto", (long)7L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(2);
        Assert.assertEquals((String)"Wrong nwSrc", (long)0x8080808L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong nwDst", (long)0x10101010L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong tpSrc", (long)6653L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong tpDst", (long)6633L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong duration sec", (long)flowStats.getDurationSec().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong duration nsec", (long)flowStats.getDurationNsec().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong priority", (long)flowStats.getPriority().intValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong idle timeout", (long)flowStats.getIdleTimeout().intValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong hard timeout", (long)flowStats.getHardTimeout().intValue(), (long)serializedBuffer.readShort());
        serializedBuffer.skipBytes(6);
        Assert.assertEquals((String)"Wrong cookie", (long)flowStats.getCookie().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong Packet count", (long)flowStats.getPacketCount().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong Byte count", (long)flowStats.getByteCount().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong action type", (long)0L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong port", (long)42L, (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong maxlength", (long)50L, (long)serializedBuffer.readUnsignedShort());
    }

    @Test
    public void testAggregateBodySerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)2));
        MultipartReplyAggregateCaseBuilder aggregateCase = new MultipartReplyAggregateCaseBuilder();
        MultipartReplyAggregateBuilder aggregate = new MultipartReplyAggregateBuilder();
        aggregate.setPacketCount(BigInteger.valueOf(1234L));
        aggregate.setByteCount(BigInteger.valueOf(1234L));
        aggregate.setFlowCount(Long.valueOf(1L));
        aggregateCase.setMultipartReplyAggregate(aggregate.build());
        builder.setMultipartReplyBody((MultipartReplyBody)aggregateCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV10(serializedBuffer, (byte)17, 36);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPAGGREGATE.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)OF10StatsReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        Assert.assertEquals((String)"Wrong Packet count", (long)1234L, (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong Byte count", (long)1234L, (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong flow count", (long)1L, (long)serializedBuffer.readInt());
        serializedBuffer.skipBytes(4);
    }

    @Test
    public void testTableBodySerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)3));
        MultipartReplyTableCaseBuilder tableCase = new MultipartReplyTableCaseBuilder();
        MultipartReplyTableBuilder table = new MultipartReplyTableBuilder();
        table.setTableStats(OF10StatsReplyMessageFactoryTest.createTableStats());
        tableCase.setMultipartReplyTable(table.build());
        builder.setMultipartReplyBody((MultipartReplyBody)tableCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV10(serializedBuffer, (byte)17, 60);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPTABLE.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)OF10StatsReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        Assert.assertEquals((String)"Wrong table id", (long)1L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(3);
        Assert.assertEquals((String)"Wrong name", (Object)"Table name", (Object)ByteBufUtils.decodeNullTerminatedString((ByteBuf)serializedBuffer, (int)16));
        Assert.assertEquals((String)"Wrong wildcards", (long)0x3000FFL, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong max entries", (long)1L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong active count", (long)1L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong lookup count", (long)1234L, (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong matched count", (long)1234L, (long)serializedBuffer.readLong());
    }

    @Test
    public void testPortStatsBodySerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)4));
        MultipartReplyPortStatsCaseBuilder portStatsCase = new MultipartReplyPortStatsCaseBuilder();
        MultipartReplyPortStatsBuilder portStats = new MultipartReplyPortStatsBuilder();
        portStats.setPortStats(OF10StatsReplyMessageFactoryTest.createPortStats());
        portStatsCase.setMultipartReplyPortStats(portStats.build());
        builder.setMultipartReplyBody((MultipartReplyBody)portStatsCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV10(serializedBuffer, (byte)17, 118);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPPORTSTATS.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)OF10StatsReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        MultipartReplyPortStatsCase body = (MultipartReplyPortStatsCase)message.getMultipartReplyBody();
        MultipartReplyPortStats messageOutput = body.getMultipartReplyPortStats();
        PortStats portStatsOutput = (PortStats)messageOutput.getPortStats().get(0);
        Assert.assertEquals((String)"Wrong port no", (long)portStatsOutput.getPortNo().intValue(), (long)serializedBuffer.readInt());
        serializedBuffer.skipBytes(6);
        Assert.assertEquals((String)"Wrong rx packets", (long)portStatsOutput.getRxPackets().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong tx packets", (long)portStatsOutput.getTxPackets().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong rx bytes", (long)portStatsOutput.getRxBytes().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong tx bytes", (long)portStatsOutput.getTxBytes().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong rx dropped", (long)portStatsOutput.getRxDropped().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong tx dropped", (long)portStatsOutput.getTxDropped().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong rx errors", (long)portStatsOutput.getRxErrors().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong tx errors", (long)portStatsOutput.getTxErrors().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong rx frame err", (long)portStatsOutput.getRxFrameErr().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong rx over err", (long)portStatsOutput.getRxOverErr().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong rx crc err", (long)portStatsOutput.getRxCrcErr().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong collisions", (long)portStatsOutput.getCollisions().longValue(), (long)serializedBuffer.readLong());
    }

    @Test
    public void testQueueBodySerialize() throws Exception {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        builder.setType(MultipartType.forValue((int)5));
        MultipartReplyQueueCaseBuilder queueCase = new MultipartReplyQueueCaseBuilder();
        MultipartReplyQueueBuilder queue = new MultipartReplyQueueBuilder();
        queue.setQueueStats(OF10StatsReplyMessageFactoryTest.createQueueStats());
        queueCase.setMultipartReplyQueue(queue.build());
        builder.setMultipartReplyBody((MultipartReplyBody)queueCase.build());
        MultipartReplyMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV10(serializedBuffer, (byte)17, 44);
        Assert.assertEquals((String)"Wrong type", (long)MultipartType.OFPMPQUEUE.getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)OF10StatsReplyMessageFactoryTest.createMultipartRequestFlags(serializedBuffer.readShort()));
        MultipartReplyQueueCase body = (MultipartReplyQueueCase)message.getMultipartReplyBody();
        MultipartReplyQueue messageOutput = body.getMultipartReplyQueue();
        QueueStats queueStats = (QueueStats)messageOutput.getQueueStats().get(0);
        Assert.assertEquals((String)"Wrong length", (long)32L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(2);
        Assert.assertEquals((String)"Wrong queue id", (long)queueStats.getQueueId().intValue(), (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong tx bytes", (long)queueStats.getTxBytes().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong tx packets", (long)queueStats.getTxPackets().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong tx errors", (long)queueStats.getTxErrors().longValue(), (long)serializedBuffer.readLong());
    }

    private static List<QueueStats> createQueueStats() {
        QueueStatsBuilder builder = new QueueStatsBuilder();
        builder.setQueueId(Long.valueOf(1L));
        builder.setTxBytes(BigInteger.valueOf(1L));
        builder.setTxPackets(BigInteger.valueOf(1L));
        builder.setTxErrors(BigInteger.valueOf(1L));
        ArrayList<QueueStats> list = new ArrayList<QueueStats>();
        list.add(builder.build());
        return list;
    }

    private static List<PortStats> createPortStats() {
        PortStatsBuilder builder = new PortStatsBuilder();
        builder.setPortNo(Long.valueOf(1L));
        builder.setRxPackets(BigInteger.valueOf(1L));
        builder.setTxPackets(BigInteger.valueOf(1L));
        builder.setRxBytes(BigInteger.valueOf(1L));
        builder.setTxBytes(BigInteger.valueOf(1L));
        builder.setRxDropped(BigInteger.valueOf(1L));
        builder.setTxDropped(BigInteger.valueOf(1L));
        builder.setRxErrors(BigInteger.valueOf(1L));
        builder.setTxErrors(BigInteger.valueOf(1L));
        builder.setRxFrameErr(BigInteger.valueOf(1L));
        builder.setRxOverErr(BigInteger.valueOf(1L));
        builder.setRxCrcErr(BigInteger.valueOf(1L));
        builder.setCollisions(BigInteger.valueOf(1L));
        ArrayList<PortStats> list = new ArrayList<PortStats>();
        list.add(builder.build());
        return list;
    }

    private static List<TableStats> createTableStats() {
        TableStatsBuilder builder = new TableStatsBuilder();
        builder.setTableId(Short.valueOf((short)1));
        builder.setName("Table name");
        builder.setWildcards(new FlowWildcardsV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
        builder.setMaxEntries(Long.valueOf(1L));
        builder.setActiveCount(Long.valueOf(1L));
        builder.setLookupCount(BigInteger.valueOf(1234L));
        builder.setMatchedCount(BigInteger.valueOf(1234L));
        ArrayList<TableStats> list = new ArrayList<TableStats>();
        list.add(builder.build());
        return list;
    }

    private static List<FlowStats> createFlowStats() {
        FlowStatsBuilder builder = new FlowStatsBuilder();
        builder.setTableId(Short.valueOf((short)1));
        MatchV10Builder matchBuilder = new MatchV10Builder();
        matchBuilder.setWildcards(new FlowWildcardsV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
        matchBuilder.setNwSrcMask(Short.valueOf((short)0));
        matchBuilder.setNwDstMask(Short.valueOf((short)0));
        matchBuilder.setInPort(Integer.valueOf(58));
        matchBuilder.setDlSrc(new MacAddress("01:01:01:01:01:01"));
        matchBuilder.setDlDst(new MacAddress("ff:ff:ff:ff:ff:ff"));
        matchBuilder.setDlVlan(Integer.valueOf(18));
        matchBuilder.setDlVlanPcp(Short.valueOf((short)5));
        matchBuilder.setDlType(Integer.valueOf(42));
        matchBuilder.setNwTos(Short.valueOf((short)4));
        matchBuilder.setNwProto(Short.valueOf((short)7));
        matchBuilder.setNwSrc(new Ipv4Address("8.8.8.8"));
        matchBuilder.setNwDst(new Ipv4Address("16.16.16.16"));
        matchBuilder.setTpSrc(Integer.valueOf(6653));
        matchBuilder.setTpDst(Integer.valueOf(6633));
        builder.setMatchV10(matchBuilder.build());
        builder.setDurationSec(Long.valueOf(1L));
        builder.setDurationNsec(Long.valueOf(2L));
        builder.setPriority(Integer.valueOf(1));
        builder.setIdleTimeout(Integer.valueOf(1));
        builder.setHardTimeout(Integer.valueOf(1));
        builder.setCookie(BigInteger.valueOf(1234L));
        builder.setPacketCount(BigInteger.valueOf(1234L));
        builder.setByteCount(BigInteger.valueOf(1234L));
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        OutputActionCaseBuilder caseBuilder = new OutputActionCaseBuilder();
        OutputActionBuilder outputBuilder = new OutputActionBuilder();
        outputBuilder.setPort(new PortNumber(Long.valueOf(42L)));
        outputBuilder.setMaxLength(Integer.valueOf(50));
        caseBuilder.setOutputAction(outputBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)caseBuilder.build());
        actions.add(actionBuilder.build());
        builder.setAction(actions);
        ArrayList<FlowStats> list = new ArrayList<FlowStats>();
        list.add(builder.build());
        return list;
    }

    private static MultipartRequestFlags createMultipartRequestFlags(int input) {
        Boolean one = (input & 1) > 0;
        return new MultipartRequestFlags(one);
    }

    private static MultipartReplyDescCase decodeDescBody(ByteBuf output) {
        MultipartReplyDescCaseBuilder descCase = new MultipartReplyDescCaseBuilder();
        MultipartReplyDescBuilder desc = new MultipartReplyDescBuilder();
        byte[] mfrDesc = new byte[256];
        output.readBytes(mfrDesc);
        desc.setMfrDesc(new String(mfrDesc).trim());
        byte[] hwDesc = new byte[256];
        output.readBytes(hwDesc);
        desc.setHwDesc(new String(hwDesc).trim());
        byte[] swDesc = new byte[256];
        output.readBytes(swDesc);
        desc.setSwDesc(new String(swDesc).trim());
        byte[] serialNumber = new byte[32];
        output.readBytes(serialNumber);
        desc.setSerialNum(new String(serialNumber).trim());
        byte[] dpDesc = new byte[256];
        output.readBytes(dpDesc);
        desc.setDpDesc(new String(dpDesc).trim());
        descCase.setMultipartReplyDesc(desc.build());
        return descCase.build();
    }
}

