/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestFlowCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortStatsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestQueueCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.desc._case.MultipartRequestDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.flow._case.MultipartRequestFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.port.stats._case.MultipartRequestPortStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.queue._case.MultipartRequestQueueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table._case.MultipartRequestTableBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10StatsRequestInputFactoryTest {
    private SerializerRegistry registry;
    private OFSerializer<MultipartRequestInput> multipartFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.multipartFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(1, MultipartRequestInput.class));
    }

    @Test
    public void testDesc() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setType(MultipartType.OFPMPDESC);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestDescCaseBuilder caseBuilder = new MultipartRequestDescCaseBuilder();
        MultipartRequestDescBuilder descBuilder = new MultipartRequestDescBuilder();
        caseBuilder.setMultipartRequestDesc(descBuilder.build());
        builder.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV10(out, (byte)16, 12);
        Assert.assertEquals((String)"Wrong type", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)0L, (long)out.readUnsignedShort());
        Assert.assertTrue((String)"Unread data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFlow() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setType(MultipartType.OFPMPFLOW);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestFlowCaseBuilder caseBuilder = new MultipartRequestFlowCaseBuilder();
        MultipartRequestFlowBuilder flowBuilder = new MultipartRequestFlowBuilder();
        MatchV10Builder matchBuilder = new MatchV10Builder();
        matchBuilder.setWildcards(new FlowWildcardsV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
        matchBuilder.setNwSrcMask(Short.valueOf((short)8));
        matchBuilder.setNwDstMask(Short.valueOf((short)16));
        matchBuilder.setInPort(Integer.valueOf(51));
        matchBuilder.setDlSrc(new MacAddress("00:01:02:03:04:05"));
        matchBuilder.setDlDst(new MacAddress("05:04:03:02:01:00"));
        matchBuilder.setDlVlan(Integer.valueOf(52));
        matchBuilder.setDlVlanPcp(Short.valueOf((short)53));
        matchBuilder.setDlType(Integer.valueOf(54));
        matchBuilder.setNwTos(Short.valueOf((short)55));
        matchBuilder.setNwProto(Short.valueOf((short)56));
        matchBuilder.setNwSrc(new Ipv4Address("10.0.0.1"));
        matchBuilder.setNwDst(new Ipv4Address("10.0.0.2"));
        matchBuilder.setTpSrc(Integer.valueOf(57));
        matchBuilder.setTpDst(Integer.valueOf(58));
        flowBuilder.setMatchV10(matchBuilder.build());
        flowBuilder.setTableId(Short.valueOf((short)1));
        flowBuilder.setOutPort(Long.valueOf(42L));
        caseBuilder.setMultipartRequestFlow(flowBuilder.build());
        builder.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV10(out, (byte)16, 56);
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong wildcards", (long)3414271L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong in-port", (long)51L, (long)out.readUnsignedShort());
        byte[] dlSrc = new byte[6];
        out.readBytes(dlSrc);
        Assert.assertEquals((String)"Wrong dl-src", (Object)"00:01:02:03:04:05", (Object)ByteBufUtils.macAddressToString((byte[])dlSrc));
        byte[] dlDst = new byte[6];
        out.readBytes(dlDst);
        Assert.assertEquals((String)"Wrong dl-dst", (Object)"05:04:03:02:01:00", (Object)ByteBufUtils.macAddressToString((byte[])dlDst));
        Assert.assertEquals((String)"Wrong dl-vlan", (long)52L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong dl-vlan-pcp", (long)53L, (long)out.readUnsignedByte());
        out.skipBytes(1);
        Assert.assertEquals((String)"Wrong dl-type", (long)54L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong nw-tos", (long)55L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong nw-proto", (long)56L, (long)out.readUnsignedByte());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong nw-src", (long)0xA000001L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong nw-dst", (long)0xA000002L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong tp-src", (long)57L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong tp-dst", (long)58L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong table-id", (long)1L, (long)out.readUnsignedByte());
        out.skipBytes(1);
        Assert.assertEquals((String)"Wrong out-port", (long)42L, (long)out.readUnsignedShort());
        Assert.assertTrue((String)"Unread data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAggregate() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setType(MultipartType.OFPMPAGGREGATE);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestFlowCaseBuilder caseBuilder = new MultipartRequestFlowCaseBuilder();
        MultipartRequestFlowBuilder flowBuilder = new MultipartRequestFlowBuilder();
        MatchV10Builder matchBuilder = new MatchV10Builder();
        matchBuilder.setWildcards(new FlowWildcardsV10(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)));
        matchBuilder.setNwSrcMask(Short.valueOf((short)32));
        matchBuilder.setNwDstMask(Short.valueOf((short)32));
        matchBuilder.setInPort(Integer.valueOf(51));
        matchBuilder.setDlSrc(new MacAddress("00:01:02:03:04:05"));
        matchBuilder.setDlDst(new MacAddress("05:04:03:02:01:00"));
        matchBuilder.setDlVlan(Integer.valueOf(52));
        matchBuilder.setDlVlanPcp(Short.valueOf((short)53));
        matchBuilder.setDlType(Integer.valueOf(54));
        matchBuilder.setNwTos(Short.valueOf((short)55));
        matchBuilder.setNwProto(Short.valueOf((short)56));
        matchBuilder.setNwSrc(new Ipv4Address("10.0.0.1"));
        matchBuilder.setNwDst(new Ipv4Address("10.0.0.2"));
        matchBuilder.setTpSrc(Integer.valueOf(57));
        matchBuilder.setTpDst(Integer.valueOf(58));
        flowBuilder.setMatchV10(matchBuilder.build());
        flowBuilder.setTableId(Short.valueOf((short)42));
        flowBuilder.setOutPort(Long.valueOf(6653L));
        caseBuilder.setMultipartRequestFlow(flowBuilder.build());
        builder.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV10(out, (byte)16, 56);
        Assert.assertEquals((String)"Wrong type", (long)2L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong wildcards", (long)0L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong in-port", (long)51L, (long)out.readUnsignedShort());
        byte[] dlSrc = new byte[6];
        out.readBytes(dlSrc);
        Assert.assertEquals((String)"Wrong dl-src", (Object)"00:01:02:03:04:05", (Object)ByteBufUtils.macAddressToString((byte[])dlSrc));
        byte[] dlDst = new byte[6];
        out.readBytes(dlDst);
        Assert.assertEquals((String)"Wrong dl-dst", (Object)"05:04:03:02:01:00", (Object)ByteBufUtils.macAddressToString((byte[])dlDst));
        Assert.assertEquals((String)"Wrong dl-vlan", (long)52L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong dl-vlan-pcp", (long)53L, (long)out.readUnsignedByte());
        out.skipBytes(1);
        Assert.assertEquals((String)"Wrong dl-type", (long)54L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong nw-tos", (long)55L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong nw-proto", (long)56L, (long)out.readUnsignedByte());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong nw-src", (long)0xA000001L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong nw-dst", (long)0xA000002L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong tp-src", (long)57L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong tp-dst", (long)58L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong table-id", (long)42L, (long)out.readUnsignedByte());
        out.skipBytes(1);
        Assert.assertEquals((String)"Wrong out-port", (long)6653L, (long)out.readUnsignedShort());
        Assert.assertTrue((String)"Unread data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTable() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setType(MultipartType.OFPMPTABLE);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestTableCaseBuilder caseBuilder = new MultipartRequestTableCaseBuilder();
        MultipartRequestTableBuilder tableBuilder = new MultipartRequestTableBuilder();
        caseBuilder.setMultipartRequestTable(tableBuilder.build());
        builder.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV10(out, (byte)16, 12);
        Assert.assertEquals((String)"Wrong type", (long)3L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)0L, (long)out.readUnsignedShort());
        Assert.assertTrue((String)"Unread data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPort() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setType(MultipartType.OFPMPPORTSTATS);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestPortStatsCaseBuilder caseBuilder = new MultipartRequestPortStatsCaseBuilder();
        MultipartRequestPortStatsBuilder portBuilder = new MultipartRequestPortStatsBuilder();
        portBuilder.setPortNo(Long.valueOf(15L));
        caseBuilder.setMultipartRequestPortStats(portBuilder.build());
        builder.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV10(out, (byte)16, 20);
        Assert.assertEquals((String)"Wrong type", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong port-no", (long)15L, (long)out.readUnsignedShort());
        out.skipBytes(6);
        Assert.assertTrue((String)"Unread data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueue() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setType(MultipartType.OFPMPQUEUE);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestQueueCaseBuilder caseBuilder = new MultipartRequestQueueCaseBuilder();
        MultipartRequestQueueBuilder queueBuilder = new MultipartRequestQueueBuilder();
        queueBuilder.setPortNo(Long.valueOf(15L));
        queueBuilder.setQueueId(Long.valueOf(16L));
        caseBuilder.setMultipartRequestQueue(queueBuilder.build());
        builder.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV10(out, (byte)16, 20);
        Assert.assertEquals((String)"Wrong type", (long)5L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong port-no", (long)15L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong queue-id", (long)16L, (long)out.readUnsignedInt());
        Assert.assertTrue((String)"Unread data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }
}

