/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigInteger;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.IpEcn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.InPhyPortCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.IpEcnCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.in.phy.port._case.InPhyPortBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ip.ecn._case.IpEcnBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessageBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class PacketInMessageFactoryTest {
    private OFSerializer<PacketInMessage> factory;
    private static final byte MESSAGE_TYPE = 10;
    private static final byte PADDING = 2;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(4, PacketInMessage.class));
    }

    @Test
    public void testSerialize() throws Exception {
        PacketInMessageBuilder builder = new PacketInMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setBufferId(Long.valueOf(256L));
        builder.setTotalLen(Integer.valueOf(10));
        builder.setReason(PacketInReason.forValue((int)0));
        builder.setTableId(new TableId(Long.valueOf(1L)));
        byte[] cookie = new byte[]{-1, 1, 4, 1, 6, 0, 7, 1};
        builder.setCookie(new BigInteger(1, cookie));
        MatchBuilder matchBuilder = new MatchBuilder();
        matchBuilder.setType(OxmMatchType.class);
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(InPhyPort.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        InPhyPortCaseBuilder inPhyPortCaseBuilder = new InPhyPortCaseBuilder();
        InPhyPortBuilder inPhyPortBuilder = new InPhyPortBuilder();
        inPhyPortBuilder.setPortNumber(new PortNumber(Long.valueOf(42L)));
        inPhyPortCaseBuilder.setInPhyPort(inPhyPortBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)inPhyPortCaseBuilder.build());
        entries.add(entriesBuilder.build());
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(IpEcn.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        IpEcnCaseBuilder ipEcnCaseBuilder = new IpEcnCaseBuilder();
        IpEcnBuilder ipEcnBuilder = new IpEcnBuilder();
        ipEcnBuilder.setEcn(Short.valueOf((short)4));
        ipEcnCaseBuilder.setIpEcn(ipEcnBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)ipEcnCaseBuilder.build());
        entries.add(entriesBuilder.build());
        matchBuilder.setMatchEntry(entries);
        builder.setMatch(matchBuilder.build());
        byte[] data = ByteBufUtils.hexStringToBytes((String)"00 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14");
        builder.setData(data);
        PacketInMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)10, 66);
        Assert.assertEquals((String)"Wrong BufferId", (long)message.getBufferId(), (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong actions length", (long)message.getTotalLen().intValue(), (long)serializedBuffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong reason", (long)message.getReason().getIntValue(), (long)serializedBuffer.readUnsignedByte());
        Assert.assertEquals((String)"Wrong tableId", (long)message.getTableId().getValue().intValue(), (long)serializedBuffer.readUnsignedByte());
        cookie = new byte[8];
        serializedBuffer.readBytes(cookie);
        Assert.assertEquals((String)"Wrong cookie", (Object)message.getCookie(), (Object)new BigInteger(1, cookie));
        Assert.assertEquals((String)"Wrong match type", (long)1L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(2);
        Assert.assertEquals((String)"Wrong oxm class", (long)32768L, (long)serializedBuffer.readUnsignedShort());
        short fieldAndMask = serializedBuffer.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm hasMask", (long)0L, (long)(fieldAndMask & 1));
        Assert.assertEquals((String)"Wrong oxm field", (long)1L, (long)(fieldAndMask >> 1));
        serializedBuffer.skipBytes(1);
        Assert.assertEquals((String)"Wrong oxm value", (long)42L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong oxm class", (long)32768L, (long)serializedBuffer.readUnsignedShort());
        fieldAndMask = serializedBuffer.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm hasMask", (long)0L, (long)(fieldAndMask & 1));
        Assert.assertEquals((String)"Wrong oxm field", (long)9L, (long)(fieldAndMask >> 1));
        serializedBuffer.skipBytes(1);
        Assert.assertEquals((String)"Wrong oxm value", (long)4L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(7);
        serializedBuffer.skipBytes(2);
        byte[] readData = new byte[serializedBuffer.readableBytes()];
        serializedBuffer.readBytes(readData);
        Assert.assertArrayEquals((String)"Wrong data", (byte[])message.getData(), (byte[])readData);
    }
}

