/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PopVlanCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PushVlanCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.push.vlan._case.PushVlanActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class PacketOutInputMessageFactoryTest {
    private static final byte MESSAGE_TYPE = 13;
    private static final byte PADDING_IN_PACKET_OUT_MESSAGE = 6;
    private static final int PADDING_IN_ACTION_HEADER = 4;
    private SerializerRegistry registry;
    private OFSerializer<PacketOutInput> packetOutFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.packetOutFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, PacketOutInput.class));
    }

    @Test
    public void testPacketOutInputMessage() throws Exception {
        PacketOutInputBuilder builder = new PacketOutInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setBufferId(Long.valueOf(256L));
        builder.setInPort(new PortNumber(Long.valueOf(256L)));
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        PushVlanCaseBuilder pushVlanCaseBuilder = new PushVlanCaseBuilder();
        PushVlanActionBuilder pushVlanBuilder = new PushVlanActionBuilder();
        pushVlanBuilder.setEthertype(new EtherType(new EtherType(Integer.valueOf(25))));
        pushVlanCaseBuilder.setPushVlanAction(pushVlanBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)pushVlanCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice((ActionChoice)new PopVlanCaseBuilder().build());
        actions.add(actionBuilder.build());
        builder.setAction(actions);
        builder.setData(ByteBufUtils.hexStringToBytes((String)"00 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14"));
        PacketOutInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.packetOutFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)13, 56);
        Assert.assertEquals((String)"Wrong BufferId", (long)message.getBufferId(), (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong PortNumber", (long)message.getInPort().getValue(), (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong ActionsLength", (long)16L, (long)out.readUnsignedShort());
        out.skipBytes(6);
        Assert.assertEquals((String)"Wrong action type", (long)17L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ethertype", (long)25L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong action type", (long)18L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        byte[] readData = new byte[out.readableBytes()];
        out.readBytes(readData);
        Assert.assertArrayEquals((String)"Wrong data", (byte[])message.getData(), (byte[])readData);
    }

    @Test
    public void testPacketOutInputWithNoData() throws Exception {
        PacketOutInputBuilder builder = new PacketOutInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setBufferId(Long.valueOf(256L));
        builder.setInPort(new PortNumber(Long.valueOf(256L)));
        ArrayList actions = new ArrayList();
        builder.setAction(actions);
        builder.setData(null);
        PacketOutInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.packetOutFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)13, 24);
        out.skipBytes(16);
        Assert.assertTrue((String)"Unexpected data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }
}

