/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class PortModInputMessageFactoryTest {
    private static final byte MESSAGE_TYPE = 16;
    private static final byte PADDING_IN_PORT_MOD_MESSAGE_01 = 4;
    private static final byte PADDING_IN_PORT_MOD_MESSAGE_02 = 2;
    private static final byte PADDING_IN_PORT_MOD_MESSAGE_03 = 4;
    private static final int MESSAGE_LENGTH = 40;
    private SerializerRegistry registry;
    private OFSerializer<PortModInput> portModFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.portModFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, PortModInput.class));
    }

    @Test
    public void testPortModInput() throws Exception {
        PortModInputBuilder builder = new PortModInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setPortNo(new PortNumber(Long.valueOf(9L)));
        builder.setHwAddress(new MacAddress("08:00:27:00:B0:EB"));
        builder.setConfig(new PortConfig(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setMask(new PortConfig(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)));
        builder.setAdvertise(new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)));
        PortModInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.portModFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)16, 40);
        Assert.assertEquals((String)"Wrong PortNo", (long)message.getPortNo().getValue(), (long)out.readUnsignedInt());
        out.skipBytes(4);
        byte[] address = new byte[6];
        out.readBytes(address);
        Assert.assertEquals((String)"Wrong MacAddress", (Object)message.getHwAddress().getValue(), (Object)new MacAddress(ByteBufUtils.macAddressToString((byte[])address)).getValue());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong config", (Object)message.getConfig(), (Object)PortModInputMessageFactoryTest.createPortConfig(out.readInt()));
        Assert.assertEquals((String)"Wrong mask", (Object)message.getMask(), (Object)PortModInputMessageFactoryTest.createPortConfig(out.readInt()));
        Assert.assertEquals((String)"Wrong advertise", (Object)message.getAdvertise(), (Object)PortModInputMessageFactoryTest.createPortFeatures(out.readInt()));
        out.skipBytes(4);
    }

    private static PortConfig createPortConfig(long input) {
        Boolean _portDown = (input & 1L) > 0L;
        Boolean _noRecv = (input & 4L) > 0L;
        Boolean _noFwd = (input & 0x20L) > 0L;
        Boolean _noPacketIn = (input & 0x40L) > 0L;
        return new PortConfig(_noFwd, _noPacketIn, _noRecv, _portDown);
    }

    private static PortFeatures createPortFeatures(long input) {
        Boolean _10mbHd = (input & 1L) > 0L;
        Boolean _10mbFd = (input & 2L) > 0L;
        Boolean _100mbHd = (input & 4L) > 0L;
        Boolean _100mbFd = (input & 8L) > 0L;
        Boolean _1gbHd = (input & 0x10L) > 0L;
        Boolean _1gbFd = (input & 0x20L) > 0L;
        Boolean _10gbFd = (input & 0x40L) > 0L;
        Boolean _40gbFd = (input & 0x80L) > 0L;
        Boolean _100gbFd = (input & 0x100L) > 0L;
        Boolean _1tbFd = (input & 0x200L) > 0L;
        Boolean _other = (input & 0x400L) > 0L;
        Boolean _copper = (input & 0x800L) > 0L;
        Boolean _fiber = (input & 0x1000L) > 0L;
        Boolean _autoneg = (input & 0x2000L) > 0L;
        Boolean _pause = (input & 0x4000L) > 0L;
        Boolean _pauseAsym = (input & 0x8000L) > 0L;
        return new PortFeatures(_100gbFd, _100mbFd, _100mbHd, _10gbFd, _10mbFd, _10mbHd, _1gbFd, _1gbHd, _1tbFd, _40gbFd, _autoneg, _copper, _fiber, _other, _pause, _pauseAsym);
    }
}

