/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessageBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class PortStatusMessageFactoryTest {
    private OFSerializer<PortStatusMessage> factory;
    private static final byte MESSAGE_TYPE = 12;
    private static final byte PADDING = 7;
    private static final byte PORT_PADDING_1 = 4;
    private static final byte PORT_PADDING_2 = 2;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(4, PortStatusMessage.class));
    }

    @Test
    public void testSerialize() throws Exception {
        PortStatusMessageBuilder builder = new PortStatusMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setReason(PortReason.forValue((int)1));
        builder.setPortNo(Long.valueOf(1L));
        builder.setHwAddr(new MacAddress("94:de:80:a6:61:40"));
        builder.setName("Port name");
        builder.setConfig(new PortConfig(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setState(new PortState(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)));
        builder.setCurrentFeatures(new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setAdvertisedFeatures(new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setSupportedFeatures(new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setPeerFeatures(new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        builder.setCurrSpeed(Long.valueOf(1234L));
        builder.setMaxSpeed(Long.valueOf(1234L));
        PortStatusMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)12, 80);
        Assert.assertEquals((String)"Wrong reason", (long)message.getReason().getIntValue(), (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(7);
        Assert.assertEquals((String)"Wrong PortNo", (long)message.getPortNo().intValue(), (long)serializedBuffer.readUnsignedInt());
        serializedBuffer.skipBytes(4);
        byte[] address = new byte[6];
        serializedBuffer.readBytes(address);
        Assert.assertEquals((String)"Wrong MacAddress", (Object)message.getHwAddr().getValue().toLowerCase(), (Object)new MacAddress(ByteBufUtils.macAddressToString((byte[])address)).getValue().toLowerCase());
        serializedBuffer.skipBytes(2);
        byte[] name = new byte[16];
        serializedBuffer.readBytes(name);
        Assert.assertEquals((String)"Wrong name", (Object)message.getName(), (Object)new String(name).trim());
        Assert.assertEquals((String)"Wrong config", (Object)message.getConfig(), (Object)PortStatusMessageFactoryTest.createPortConfig(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong state", (Object)message.getState(), (Object)PortStatusMessageFactoryTest.createPortState(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong current", (Object)message.getCurrentFeatures(), (Object)PortStatusMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong advertised", (Object)message.getAdvertisedFeatures(), (Object)PortStatusMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong supported", (Object)message.getSupportedFeatures(), (Object)PortStatusMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong peer", (Object)message.getPeerFeatures(), (Object)PortStatusMessageFactoryTest.createPortFeatures(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong Current speed", (long)message.getCurrSpeed(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong Max speed", (long)message.getMaxSpeed(), (long)serializedBuffer.readInt());
    }

    private static PortConfig createPortConfig(long input) {
        Boolean _portDown = (input & 1L) > 0L;
        Boolean _noRecv = (input & 4L) > 0L;
        Boolean _noFwd = (input & 0x20L) > 0L;
        Boolean _noPacketIn = (input & 0x40L) > 0L;
        return new PortConfig(_noFwd, _noPacketIn, _noRecv, _portDown);
    }

    private static PortFeatures createPortFeatures(long input) {
        Boolean _10mbHd = (input & 1L) > 0L;
        Boolean _10mbFd = (input & 2L) > 0L;
        Boolean _100mbHd = (input & 4L) > 0L;
        Boolean _100mbFd = (input & 8L) > 0L;
        Boolean _1gbHd = (input & 0x10L) > 0L;
        Boolean _1gbFd = (input & 0x20L) > 0L;
        Boolean _10gbFd = (input & 0x40L) > 0L;
        Boolean _40gbFd = (input & 0x80L) > 0L;
        Boolean _100gbFd = (input & 0x100L) > 0L;
        Boolean _1tbFd = (input & 0x200L) > 0L;
        Boolean _other = (input & 0x400L) > 0L;
        Boolean _copper = (input & 0x800L) > 0L;
        Boolean _fiber = (input & 0x1000L) > 0L;
        Boolean _autoneg = (input & 0x2000L) > 0L;
        Boolean _pause = (input & 0x4000L) > 0L;
        Boolean _pauseAsym = (input & 0x8000L) > 0L;
        return new PortFeatures(_100gbFd, _100mbFd, _100mbHd, _10gbFd, _10mbFd, _10mbHd, _1gbFd, _1gbHd, _1tbFd, _40gbFd, _autoneg, _copper, _fiber, _other, _pause, _pauseAsym);
    }

    private static PortState createPortState(long input) {
        Boolean one = (input & 1L) > 0L;
        Boolean two = (input & 2L) > 0L;
        Boolean three = (input & 4L) > 0L;
        return new PortState(two, one, three);
    }
}

