/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.RateQueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.RateQueuePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.QueuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueuePropertyBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class QueueGetConfigReplyMessageFactoryTest {
    private OFSerializer<GetQueueConfigOutput> factory;
    private static final byte MESSAGE_TYPE = 23;
    private static final byte PADDING = 4;
    private static final byte QUEUE_PADDING = 6;
    private static final byte PROPERTY_HEADER_PADDING = 4;
    private static final byte PROPERTY_RATE_PADDING = 6;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(4, GetQueueConfigOutput.class));
    }

    @Test
    public void testSerialize() throws Exception {
        GetQueueConfigOutputBuilder builder = new GetQueueConfigOutputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setPort(new PortNumber(Long.valueOf(66051L)));
        builder.setQueues(QueueGetConfigReplyMessageFactoryTest.createQueuesList());
        GetQueueConfigOutput message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)23, 80);
        Assert.assertEquals((String)"Wrong port", (long)message.getPort().getValue(), (long)serializedBuffer.readInt());
        serializedBuffer.skipBytes(4);
        Assert.assertEquals((String)"Wrong queue Id", (long)((Queues)message.getQueues().get(0)).getQueueId().getValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong port", (long)((Queues)message.getQueues().get(0)).getPort().getValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong length", (long)32L, (long)serializedBuffer.readShort());
        serializedBuffer.skipBytes(6);
        List properties = ((Queues)message.getQueues().get(0)).getQueueProperty();
        Assert.assertEquals((String)"Wrong property", (long)((QueueProperty)properties.get(0)).getProperty().getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong property length", (long)16L, (long)serializedBuffer.readShort());
        serializedBuffer.skipBytes(4);
        RateQueueProperty rateQueueProperty = (RateQueueProperty)((QueueProperty)properties.get(0)).getAugmentation(RateQueueProperty.class);
        Assert.assertEquals((String)"Wrong rate", (long)rateQueueProperty.getRate().intValue(), (long)serializedBuffer.readShort());
        serializedBuffer.skipBytes(6);
        Assert.assertEquals((String)"Wrong queue Id", (long)((Queues)message.getQueues().get(1)).getQueueId().getValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong queue Id", (long)((Queues)message.getQueues().get(1)).getPort().getValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong length", (long)32L, (long)serializedBuffer.readShort());
        serializedBuffer.skipBytes(6);
        List propertiesTwo = ((Queues)message.getQueues().get(1)).getQueueProperty();
        Assert.assertEquals((String)"Wrong property", (long)((QueueProperty)propertiesTwo.get(0)).getProperty().getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong property length", (long)16L, (long)serializedBuffer.readShort());
        serializedBuffer.skipBytes(4);
        RateQueueProperty rateQueuePropertyTwo = (RateQueueProperty)((QueueProperty)propertiesTwo.get(0)).getAugmentation(RateQueueProperty.class);
        Assert.assertEquals((String)"Wrong rate", (long)rateQueuePropertyTwo.getRate().intValue(), (long)serializedBuffer.readShort());
        serializedBuffer.skipBytes(6);
    }

    private static List<Queues> createQueuesList() {
        ArrayList<Queues> queuesList = new ArrayList<Queues>();
        for (int i = 1; i < 3; ++i) {
            QueuesBuilder qb = new QueuesBuilder();
            qb.setQueueId(new QueueId(Long.valueOf(i)));
            qb.setPort(new PortNumber(Long.valueOf(i)));
            qb.setQueueProperty(QueueGetConfigReplyMessageFactoryTest.createPropertiesList());
            queuesList.add(qb.build());
        }
        return queuesList;
    }

    private static List<QueueProperty> createPropertiesList() {
        ArrayList<QueueProperty> propertiesList = new ArrayList<QueueProperty>();
        QueuePropertyBuilder pb = new QueuePropertyBuilder();
        pb.setProperty(QueueProperties.forValue((int)2));
        RateQueuePropertyBuilder rateBuilder = new RateQueuePropertyBuilder();
        rateBuilder.setRate(Integer.valueOf(5));
        pb.addAugmentation(RateQueueProperty.class, (Augmentation)rateBuilder.build());
        propertiesList.add(pb.build());
        return propertiesList;
    }
}

