/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ControllerRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestOutputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class RoleReplyMessageFactoryTest {
    private OFSerializer<RoleRequestOutput> factory;
    private static final byte MESSAGE_TYPE = 25;
    private static final byte PADDING = 4;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(4, RoleRequestOutput.class));
    }

    @Test
    public void testSerialize() throws Exception {
        RoleRequestOutputBuilder builder = new RoleRequestOutputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setRole(ControllerRole.forValue((int)0));
        builder.setGenerationId(BigInteger.valueOf(1L));
        RoleRequestOutput message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)25, 24);
        Assert.assertEquals((String)"Wrong role", (long)message.getRole().getIntValue(), (long)ControllerRole.forValue((int)((int)serializedBuffer.readUnsignedInt())).getIntValue());
        serializedBuffer.skipBytes(4);
        byte[] genId = new byte[8];
        serializedBuffer.readBytes(genId);
        Assert.assertEquals((String)"Wrong generation ID", (Object)message.getGenerationId(), (Object)new BigInteger(1, genId));
    }
}

