/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ControllerRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class RoleRequestInputMessageFactoryTest {
    private static final byte MESSAGE_TYPE = 24;
    private static final int MESSAGE_LENGTH = 24;
    private static final byte PADDING_IN_ROLE_REQUEST_MESSAGE = 4;
    private SerializerRegistry registry;
    private OFSerializer<RoleRequestInput> roleFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.roleFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, RoleRequestInput.class));
    }

    @Test
    public void testRoleRequestInputMessage() throws Exception {
        RoleRequestInputBuilder builder = new RoleRequestInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setRole(ControllerRole.forValue((int)2));
        byte[] generationId = new byte[]{-1, 1, 1, 1, 1, 1, 1, 1};
        builder.setGenerationId(new BigInteger(1, generationId));
        RoleRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.roleFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)24, 24);
        Assert.assertEquals((String)"Wrong role", (long)message.getRole().getIntValue(), (long)ControllerRole.forValue((int)((int)out.readUnsignedInt())).getIntValue());
        out.skipBytes(4);
        byte[] genId = new byte[8];
        out.readBytes(genId);
        Assert.assertEquals((String)"Wrong generation ID", (Object)message.getGenerationId(), (Object)new BigInteger(1, genId));
    }
}

