/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetAsyncInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.FlowRemovedMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.FlowRemovedMaskBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PacketInMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PacketInMaskBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PortStatusMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PortStatusMaskBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class SetAsyncInputMessageFactoryTest {
    private SerializerRegistry registry;
    private OFSerializer<SetAsyncInput> setAsyncFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.setAsyncFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, SetAsyncInput.class));
    }

    @Test
    public void testSetAsyncInputMessage() throws Exception {
        SetAsyncInputBuilder builder = new SetAsyncInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setPacketInMask(SetAsyncInputMessageFactoryTest.createPacketInMask());
        builder.setPortStatusMask(SetAsyncInputMessageFactoryTest.createPortStatusMask());
        builder.setFlowRemovedMask(SetAsyncInputMessageFactoryTest.createFlowRemowedMask());
        SetAsyncInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.setAsyncFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)28, 32);
        Assert.assertEquals((String)"Wrong packetInMask", (long)7L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong packetInMask", (long)0L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong portStatusMask", (long)7L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong portStatusMask", (long)0L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong flowRemovedMask", (long)15L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong flowRemovedMask", (long)0L, (long)out.readUnsignedInt());
    }

    private static List<PacketInMask> createPacketInMask() {
        ArrayList<PacketInMask> masks = new ArrayList<PacketInMask>();
        PacketInMaskBuilder builder = new PacketInMaskBuilder();
        ArrayList<PacketInReason> packetInReasonList = new ArrayList<PacketInReason>();
        packetInReasonList.add(PacketInReason.OFPRNOMATCH);
        packetInReasonList.add(PacketInReason.OFPRACTION);
        packetInReasonList.add(PacketInReason.OFPRINVALIDTTL);
        builder.setMask(packetInReasonList);
        masks.add(builder.build());
        builder = new PacketInMaskBuilder();
        packetInReasonList = new ArrayList();
        builder.setMask(packetInReasonList);
        masks.add(builder.build());
        return masks;
    }

    private static List<PortStatusMask> createPortStatusMask() {
        ArrayList<PortStatusMask> masks = new ArrayList<PortStatusMask>();
        PortStatusMaskBuilder builder = new PortStatusMaskBuilder();
        ArrayList<PortReason> portReasonList = new ArrayList<PortReason>();
        portReasonList.add(PortReason.OFPPRADD);
        portReasonList.add(PortReason.OFPPRDELETE);
        portReasonList.add(PortReason.OFPPRMODIFY);
        builder.setMask(portReasonList);
        masks.add(builder.build());
        builder = new PortStatusMaskBuilder();
        portReasonList = new ArrayList();
        builder.setMask(portReasonList);
        masks.add(builder.build());
        return masks;
    }

    private static List<FlowRemovedMask> createFlowRemowedMask() {
        ArrayList<FlowRemovedMask> masks = new ArrayList<FlowRemovedMask>();
        FlowRemovedMaskBuilder builder = new FlowRemovedMaskBuilder();
        ArrayList<FlowRemovedReason> flowRemovedReasonList = new ArrayList<FlowRemovedReason>();
        flowRemovedReasonList.add(FlowRemovedReason.OFPRRIDLETIMEOUT);
        flowRemovedReasonList.add(FlowRemovedReason.OFPRRHARDTIMEOUT);
        flowRemovedReasonList.add(FlowRemovedReason.OFPRRDELETE);
        flowRemovedReasonList.add(FlowRemovedReason.OFPRRGROUPDELETE);
        builder.setMask(flowRemovedReasonList);
        masks.add(builder.build());
        builder = new FlowRemovedMaskBuilder();
        flowRemovedReasonList = new ArrayList();
        builder.setMask(flowRemovedReasonList);
        masks.add(builder.build());
        return masks;
    }

    @Test
    public void testSetAsyncInputWithNullMasks() throws Exception {
        SetAsyncInputBuilder builder = new SetAsyncInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setPacketInMask(null);
        builder.setPortStatusMask(null);
        builder.setFlowRemovedMask(null);
        SetAsyncInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.setAsyncFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)28, 8);
        Assert.assertTrue((String)"Unexpected data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }
}

