/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.SwitchConfigFlag;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetConfigInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class SetConfigMessageFactoryTest {
    private static final byte MESSAGE_TYPE = 9;
    private static final int MESSAGE_LENGTH = 12;
    private SerializerRegistry registry;
    private OFSerializer<SetConfigInput> setConfigFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.setConfigFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, SetConfigInput.class));
    }

    @Test
    public void testSetConfigMessageV13() throws Exception {
        SetConfigInputBuilder builder = new SetConfigInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        SwitchConfigFlag flag = SwitchConfigFlag.FRAGNORMAL;
        builder.setFlags(flag);
        builder.setMissSendLen(Integer.valueOf(10));
        SetConfigInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.setConfigFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)9, 12);
        Assert.assertEquals((String)"Wrong flags", (long)SwitchConfigFlag.FRAGNORMAL.getIntValue(), (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong missSendLen", (long)10L, (long)out.readUnsignedShort());
    }

    @Test
    public void testSetConfigMessageV10() throws Exception {
        SetConfigInputBuilder builder = new SetConfigInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        SwitchConfigFlag flag = SwitchConfigFlag.OFPCFRAGDROP;
        builder.setFlags(flag);
        builder.setMissSendLen(Integer.valueOf(85));
        SetConfigInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.setConfigFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV10(out, (byte)9, 12);
        Assert.assertEquals((String)"Wrong flags", (long)SwitchConfigFlag.OFPCFRAGDROP.getIntValue(), (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong missSendLen", (long)85L, (long)out.readUnsignedShort());
    }
}

