/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableModInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class TableModInputMessageFactoryTest {
    private static final byte MESSAGE_TYPE = 17;
    private static final byte PADDING_IN_TABLE_MOD_MESSAGE = 3;
    private SerializerRegistry registry;
    private OFSerializer<TableModInput> tableModFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.tableModFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, TableModInput.class));
    }

    @Test
    public void testTableModInput() throws Exception {
        TableModInputBuilder builder = new TableModInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setTableId(new TableId(Long.valueOf(9L)));
        builder.setConfig(new TableConfig(Boolean.valueOf(true)));
        TableModInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.tableModFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)17, 16);
        Assert.assertEquals((String)"Wrong TableID", (long)message.getTableId().getValue().intValue(), (long)out.readUnsignedByte());
        out.skipBytes(3);
        Assert.assertEquals((String)"Wrong TableConfig", (long)8L, (long)out.readUnsignedInt());
    }
}

