/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.VendorInputMessageFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterOfMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.experimenter.core.ExperimenterDataOfChoice;
import org.opendaylight.yangtools.yang.binding.DataContainer;

@RunWith(value=MockitoJUnitRunner.class)
public class VendorInputMessageFactoryTest {
    @Mock
    SerializerRegistry registry;
    @Mock
    OFSerializer<ExperimenterDataOfChoice> foundSerializer;
    @Mock
    ExperimenterDataOfChoice vendorData;
    VendorInputMessageFactory serializer;

    @Test
    public void test() {
        Mockito.when((Object)this.registry.getSerializer((MessageTypeKey)Matchers.any())).thenReturn((Object)this.serializer);
        VendorInputMessageFactory factory = new VendorInputMessageFactory();
        factory.injectSerializerRegistry(this.registry);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        ExperimenterInputBuilder builder = new ExperimenterInputBuilder();
        builder.setVersion(Short.valueOf((short)1));
        builder.setXid(Long.valueOf(12345L));
        builder.setExperimenter(new ExperimenterId(Long.valueOf(42L)));
        builder.setExpType(Long.valueOf(84L));
        builder.setExperimenterDataOfChoice(this.vendorData);
        ExperimenterInput experimenterInput = builder.build();
        Mockito.when((Object)this.registry.getSerializer((MessageTypeKey)Matchers.any())).thenReturn(this.foundSerializer);
        factory.serialize((ExperimenterOfMessage)experimenterInput, buffer);
        ((OFSerializer)Mockito.verify(this.foundSerializer, (VerificationMode)Mockito.times((int)1))).serialize((DataContainer)experimenterInput.getExperimenterDataOfChoice(), buffer);
    }
}

