/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.group.features._case.MultipartRequestGroupFeaturesBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class MultipartRequestGroupFeaturesTest {
    private SerializerRegistry registry;
    private OFSerializer<MultipartRequestInput> multipartFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.multipartFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, MultipartRequestInput.class));
    }

    @Test
    public void test() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setType(MultipartType.OFPMPGROUPFEATURES);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestGroupFeaturesCaseBuilder caseBuilder = new MultipartRequestGroupFeaturesCaseBuilder();
        MultipartRequestGroupFeaturesBuilder featuresBuilder = new MultipartRequestGroupFeaturesBuilder();
        featuresBuilder.setEmpty(Boolean.valueOf(true));
        caseBuilder.setMultipartRequestGroupFeatures(featuresBuilder.build());
        builder.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)18, 16);
        Assert.assertEquals((String)"Wrong type", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)0L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertTrue((String)"Unexpected data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }
}

