/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigInteger;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.MultipartRequestInputFactory;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ActionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ActionRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ExperimenterIdTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ExperimenterIdTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.InstructionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.InstructionRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.NextTableRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.NextTableRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.OxmRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.OxmRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.table.features.properties.container.table.feature.properties.NextTableIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.table.features.properties.container.table.feature.properties.NextTableIdsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.InstructionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ClearActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.GotoTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.MeterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.WriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.WriteMetadataCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.InstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableFeaturesPropType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.IpEcn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.IpProto;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.MultipartRequestTableFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.multipart.request.table.features.TableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.multipart.request.table.features.TableFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeatureProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeaturePropertiesBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataContainer;

@RunWith(value=MockitoJUnitRunner.class)
public class MultipartRequestTableFeaturesTest {
    private static final byte PADDING_IN_MULTIPART_REQUEST_MESSAGE = 4;
    private SerializerRegistry registry;
    private OFSerializer<MultipartRequestInput> multipartFactory;
    @Mock
    SerializerRegistry mockRegistry;
    @Mock
    OFSerializer<TableFeatureProperties> serializer;

    @Before
    public void startUp() {
        Mockito.when((Object)this.mockRegistry.getSerializer((MessageTypeKey)Matchers.any())).thenReturn(this.serializer);
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.multipartFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, MultipartRequestInput.class));
    }

    @Test
    public void testMultipartRequestTableFeaturesMessageFactory() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setType(MultipartType.forValue((int)12));
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        MultipartRequestTableFeaturesCaseBuilder caseBuilder = new MultipartRequestTableFeaturesCaseBuilder();
        MultipartRequestTableFeaturesBuilder featuresBuilder = new MultipartRequestTableFeaturesBuilder();
        ArrayList<TableFeatures> tableFeaturesList = new ArrayList<TableFeatures>();
        TableFeaturesBuilder tableFeaturesBuilder = new TableFeaturesBuilder();
        tableFeaturesBuilder.setTableId(Short.valueOf((short)8));
        tableFeaturesBuilder.setName("AAAABBBBCCCCDDDDEEEEFFFFGGGG");
        tableFeaturesBuilder.setMetadataMatch(new BigInteger(new byte[]{0, 1, 2, 3, 1, 4, 8, 1}));
        tableFeaturesBuilder.setMetadataWrite(new BigInteger(new byte[]{0, 7, 1, 5, 1, 0, 3, 1}));
        tableFeaturesBuilder.setConfig(new TableConfig(Boolean.valueOf(true)));
        tableFeaturesBuilder.setMaxEntries(Long.valueOf(65L));
        ArrayList<TableFeatureProperties> properties = new ArrayList<TableFeatureProperties>();
        TableFeaturePropertiesBuilder propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTNEXTTABLES);
        NextTableRelatedTableFeaturePropertyBuilder nextPropBuilder = new NextTableRelatedTableFeaturePropertyBuilder();
        ArrayList<NextTableIds> nextIds = new ArrayList<NextTableIds>();
        nextIds.add(new NextTableIdsBuilder().setTableId(Short.valueOf((short)1)).build());
        nextIds.add(new NextTableIdsBuilder().setTableId(Short.valueOf((short)2)).build());
        nextPropBuilder.setNextTableIds(nextIds);
        propBuilder.addAugmentation(NextTableRelatedTableFeatureProperty.class, (Augmentation)nextPropBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTNEXTTABLESMISS);
        nextPropBuilder = new NextTableRelatedTableFeaturePropertyBuilder();
        nextIds = new ArrayList();
        nextPropBuilder.setNextTableIds(nextIds);
        propBuilder.addAugmentation(NextTableRelatedTableFeatureProperty.class, (Augmentation)nextPropBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTINSTRUCTIONS);
        InstructionRelatedTableFeaturePropertyBuilder insPropBuilder = new InstructionRelatedTableFeaturePropertyBuilder();
        ArrayList<Instruction> insIds = new ArrayList<Instruction>();
        InstructionBuilder insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new WriteActionsCaseBuilder().build());
        insIds.add(insBuilder.build());
        insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new GotoTableCaseBuilder().build());
        insIds.add(insBuilder.build());
        insPropBuilder.setInstruction(insIds);
        propBuilder.addAugmentation(InstructionRelatedTableFeatureProperty.class, (Augmentation)insPropBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTINSTRUCTIONSMISS);
        insPropBuilder = new InstructionRelatedTableFeaturePropertyBuilder();
        insIds = new ArrayList();
        insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new WriteMetadataCaseBuilder().build());
        insIds.add(insBuilder.build());
        insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new ApplyActionsCaseBuilder().build());
        insIds.add(insBuilder.build());
        insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new MeterCaseBuilder().build());
        insIds.add(insBuilder.build());
        insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new ClearActionsCaseBuilder().build());
        insIds.add(insBuilder.build());
        insBuilder = new InstructionBuilder();
        insBuilder.setInstructionChoice((InstructionChoice)new GotoTableCaseBuilder().build());
        insIds.add(insBuilder.build());
        insPropBuilder.setInstruction(insIds);
        propBuilder.addAugmentation(InstructionRelatedTableFeatureProperty.class, (Augmentation)insPropBuilder.build());
        properties.add(propBuilder.build());
        tableFeaturesBuilder.setTableFeatureProperties(properties);
        tableFeaturesList.add(tableFeaturesBuilder.build());
        tableFeaturesBuilder = new TableFeaturesBuilder();
        tableFeaturesBuilder.setTableId(Short.valueOf((short)8));
        tableFeaturesBuilder.setName("AAAABBBBCCCCDDDDEEEEFFFFGGGG");
        tableFeaturesBuilder.setMetadataMatch(new BigInteger(new byte[]{0, 1, 2, 3, 1, 4, 8, 1}));
        tableFeaturesBuilder.setMetadataWrite(new BigInteger(new byte[]{0, 7, 1, 5, 1, 0, 3, 1}));
        tableFeaturesBuilder.setConfig(new TableConfig(Boolean.valueOf(true)));
        tableFeaturesBuilder.setMaxEntries(Long.valueOf(67L));
        properties = new ArrayList();
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTWRITEACTIONS);
        ActionRelatedTableFeaturePropertyBuilder actBuilder = new ActionRelatedTableFeaturePropertyBuilder();
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice((ActionChoice)new OutputActionCaseBuilder().build());
        actions.add(actionBuilder.build());
        actBuilder.setAction(actions);
        propBuilder.addAugmentation(ActionRelatedTableFeatureProperty.class, (Augmentation)actBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTWRITEACTIONSMISS);
        actBuilder = new ActionRelatedTableFeaturePropertyBuilder();
        actions = new ArrayList();
        actBuilder.setAction(actions);
        propBuilder.addAugmentation(ActionRelatedTableFeatureProperty.class, (Augmentation)actBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTAPPLYACTIONS);
        actBuilder = new ActionRelatedTableFeaturePropertyBuilder();
        actions = new ArrayList();
        actBuilder.setAction(actions);
        propBuilder.addAugmentation(ActionRelatedTableFeatureProperty.class, (Augmentation)actBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTAPPLYACTIONSMISS);
        actBuilder = new ActionRelatedTableFeaturePropertyBuilder();
        actions = new ArrayList();
        actBuilder.setAction(actions);
        propBuilder.addAugmentation(ActionRelatedTableFeatureProperty.class, (Augmentation)actBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTMATCH);
        OxmRelatedTableFeaturePropertyBuilder oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(InPhyPort.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        entries.add(entriesBuilder.build());
        entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(InPort.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        entries.add(entriesBuilder.build());
        oxmBuilder.setMatchEntry(entries);
        propBuilder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTWILDCARDS);
        oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
        entries = new ArrayList();
        oxmBuilder.setMatchEntry(entries);
        propBuilder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTWRITESETFIELD);
        oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
        entries = new ArrayList();
        oxmBuilder.setMatchEntry(entries);
        propBuilder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTWRITESETFIELDMISS);
        oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
        entries = new ArrayList();
        oxmBuilder.setMatchEntry(entries);
        propBuilder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTAPPLYSETFIELD);
        oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
        entries = new ArrayList();
        entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(IpProto.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        entries.add(entriesBuilder.build());
        entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(IpEcn.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        entries.add(entriesBuilder.build());
        oxmBuilder.setMatchEntry(entries);
        propBuilder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTAPPLYSETFIELDMISS);
        oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
        entries = new ArrayList();
        oxmBuilder.setMatchEntry(entries);
        propBuilder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
        properties.add(propBuilder.build());
        tableFeaturesBuilder.setTableFeatureProperties(properties);
        tableFeaturesList.add(tableFeaturesBuilder.build());
        featuresBuilder.setTableFeatures(tableFeaturesList);
        caseBuilder.setMultipartRequestTableFeatures(featuresBuilder.build());
        builder.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.multipartFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)18, 296);
        Assert.assertEquals((String)"Wrong type", (long)12L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)1L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong length", (long)120L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong registry-id", (long)8L, (long)out.readUnsignedByte());
        out.skipBytes(5);
        Assert.assertEquals((String)"Wrong name", (Object)"AAAABBBBCCCCDDDDEEEEFFFFGGGG", (Object)ByteBufUtils.decodeNullTerminatedString((ByteBuf)out, (int)32));
        byte[] metadataMatch = new byte[8];
        out.readBytes(metadataMatch);
        Assert.assertArrayEquals((String)"Wrong metadata-match", (byte[])new byte[]{0, 1, 2, 3, 1, 4, 8, 1}, (byte[])metadataMatch);
        byte[] metadataWrite = new byte[8];
        out.readBytes(metadataWrite);
        Assert.assertArrayEquals((String)"Wrong metadata-write", (byte[])new byte[]{0, 7, 1, 5, 1, 0, 3, 1}, (byte[])metadataWrite);
        Assert.assertEquals((String)"Wrong config", (long)8L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong max-entries", (long)65L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong property type", (long)2L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)6L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong next-registry-id", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong next-registry-id", (long)2L, (long)out.readUnsignedByte());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong property type", (long)3L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)12L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)3L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)1L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)1L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)24L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)2L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)6L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)5L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction type", (long)1L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong length", (long)160L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong registry-id", (long)8L, (long)out.readUnsignedByte());
        out.skipBytes(5);
        Assert.assertEquals((String)"Wrong name", (Object)"AAAABBBBCCCCDDDDEEEEFFFFGGGG", (Object)ByteBufUtils.decodeNullTerminatedString((ByteBuf)out, (int)32));
        metadataMatch = new byte[8];
        out.readBytes(metadataMatch);
        Assert.assertArrayEquals((String)"Wrong metadata-match", (byte[])new byte[]{0, 1, 2, 3, 1, 4, 8, 1}, (byte[])metadataMatch);
        metadataWrite = new byte[8];
        out.readBytes(metadataWrite);
        Assert.assertArrayEquals((String)"Wrong metadata-write", (byte[])new byte[]{0, 7, 1, 5, 1, 0, 3, 1}, (byte[])metadataWrite);
        Assert.assertEquals((String)"Wrong config", (long)8L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong max-entries", (long)67L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong property type", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action type", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property type", (long)5L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)6L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)7L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)12L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match field&mask", (long)2L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match length", (long)4L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match field&mask", (long)0L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match length", (long)4L, (long)out.readUnsignedByte());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)10L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)12L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)13L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)14L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)12L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match field&mask", (long)20L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match length", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match field&mask", (long)18L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match length", (long)1L, (long)out.readUnsignedByte());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong property type", (long)15L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong property length", (long)4L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertTrue((String)"Unread data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultipartRequestTableFeaturesExperimenter() throws Exception {
        MultipartRequestInputFactory factory = new MultipartRequestInputFactory();
        factory.injectSerializerRegistry(this.mockRegistry);
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setType(MultipartType.forValue((int)12));
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(true)));
        MultipartRequestTableFeaturesCaseBuilder caseBuilder = new MultipartRequestTableFeaturesCaseBuilder();
        MultipartRequestTableFeaturesBuilder featuresBuilder = new MultipartRequestTableFeaturesBuilder();
        ArrayList<TableFeatures> tableFeaturesList = new ArrayList<TableFeatures>();
        TableFeaturesBuilder tableFeaturesBuilder = new TableFeaturesBuilder();
        tableFeaturesBuilder.setTableId(Short.valueOf((short)8));
        tableFeaturesBuilder.setName("AAAABBBBCCCCDDDDEEEEFFFFGGGG");
        tableFeaturesBuilder.setMetadataMatch(new BigInteger(new byte[]{0, 1, 2, 3, 1, 4, 8, 1}));
        tableFeaturesBuilder.setMetadataWrite(new BigInteger(new byte[]{0, 7, 1, 5, 1, 0, 3, 1}));
        tableFeaturesBuilder.setConfig(new TableConfig(Boolean.valueOf(true)));
        tableFeaturesBuilder.setMaxEntries(Long.valueOf(65L));
        ArrayList<TableFeatureProperties> properties = new ArrayList<TableFeatureProperties>();
        TableFeaturePropertiesBuilder propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTEXPERIMENTER);
        ExperimenterIdTableFeaturePropertyBuilder expBuilder = new ExperimenterIdTableFeaturePropertyBuilder();
        expBuilder.setExperimenter(new ExperimenterId(Long.valueOf(42L)));
        propBuilder.addAugmentation(ExperimenterIdTableFeatureProperty.class, (Augmentation)expBuilder.build());
        properties.add(propBuilder.build());
        propBuilder = new TableFeaturePropertiesBuilder();
        propBuilder.setType(TableFeaturesPropType.OFPTFPTEXPERIMENTERMISS);
        expBuilder = new ExperimenterIdTableFeaturePropertyBuilder();
        expBuilder.setExperimenter(new ExperimenterId(Long.valueOf(43L)));
        propBuilder.addAugmentation(ExperimenterIdTableFeatureProperty.class, (Augmentation)expBuilder.build());
        properties.add(propBuilder.build());
        tableFeaturesBuilder.setTableFeatureProperties(properties);
        tableFeaturesList.add(tableFeaturesBuilder.build());
        featuresBuilder.setTableFeatures(tableFeaturesList);
        caseBuilder.setMultipartRequestTableFeatures(featuresBuilder.build());
        builder.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        factory.serialize(message, out);
        BufferHelper.checkHeaderV13(out, (byte)18, 80);
        Assert.assertEquals((String)"Wrong type", (long)12L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)1L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong length", (long)64L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong registry-id", (long)8L, (long)out.readUnsignedByte());
        out.skipBytes(5);
        Assert.assertEquals((String)"Wrong name", (Object)"AAAABBBBCCCCDDDDEEEEFFFFGGGG", (Object)ByteBufUtils.decodeNullTerminatedString((ByteBuf)out, (int)32));
        byte[] metadataMatch = new byte[8];
        out.readBytes(metadataMatch);
        Assert.assertArrayEquals((String)"Wrong metadata-match", (byte[])new byte[]{0, 1, 2, 3, 1, 4, 8, 1}, (byte[])metadataMatch);
        byte[] metadataWrite = new byte[8];
        out.readBytes(metadataWrite);
        Assert.assertArrayEquals((String)"Wrong metadata-write", (byte[])new byte[]{0, 7, 1, 5, 1, 0, 3, 1}, (byte[])metadataWrite);
        Assert.assertEquals((String)"Wrong config", (long)8L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong max-entries", (long)65L, (long)out.readUnsignedInt());
        ((OFSerializer)Mockito.verify(this.serializer, (VerificationMode)Mockito.times((int)2))).serialize((DataContainer)Matchers.any(TableFeatureProperties.class), (ByteBuf)Matchers.any(ByteBuf.class));
    }
}

