/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestAggregateCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.aggregate._case.MultipartRequestAggregateBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10StatsRequestAggregateTest {
    private SerializerRegistry registry;
    private OFSerializer<MultipartRequestInput> statsFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.statsFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(1, MultipartRequestInput.class));
    }

    @Test
    public void test() throws Exception {
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setType(MultipartType.OFPMPAGGREGATE);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestAggregateCaseBuilder caseBuilder = new MultipartRequestAggregateCaseBuilder();
        MultipartRequestAggregateBuilder aggBuilder = new MultipartRequestAggregateBuilder();
        MatchV10Builder matchBuilder = new MatchV10Builder();
        matchBuilder.setWildcards(new FlowWildcardsV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
        matchBuilder.setNwSrcMask(Short.valueOf((short)8));
        matchBuilder.setNwDstMask(Short.valueOf((short)16));
        matchBuilder.setInPort(Integer.valueOf(51));
        matchBuilder.setDlSrc(new MacAddress("00:01:02:03:04:05"));
        matchBuilder.setDlDst(new MacAddress("05:04:03:02:01:00"));
        matchBuilder.setDlVlan(Integer.valueOf(52));
        matchBuilder.setDlVlanPcp(Short.valueOf((short)53));
        matchBuilder.setDlType(Integer.valueOf(54));
        matchBuilder.setNwTos(Short.valueOf((short)55));
        matchBuilder.setNwProto(Short.valueOf((short)56));
        matchBuilder.setNwSrc(new Ipv4Address("10.0.0.1"));
        matchBuilder.setNwDst(new Ipv4Address("10.0.0.2"));
        matchBuilder.setTpSrc(Integer.valueOf(57));
        matchBuilder.setTpDst(Integer.valueOf(58));
        aggBuilder.setMatchV10(matchBuilder.build());
        aggBuilder.setTableId(Short.valueOf((short)5));
        aggBuilder.setOutPort(Long.valueOf(42L));
        caseBuilder.setMultipartRequestAggregate(aggBuilder.build());
        builder.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.statsFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV10(out, (byte)16, 56);
        Assert.assertEquals((String)"Wrong type", (long)2L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)0L, (long)out.readUnsignedShort());
        out.skipBytes(40);
        Assert.assertEquals((String)"Wrong table-id", (long)5L, (long)out.readUnsignedByte());
        out.skipBytes(1);
        Assert.assertEquals((String)"Wrong out port", (long)42L, (long)out.readUnsignedShort());
    }
}

