/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.OF10StatsRequestInputFactory;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.experimenter.core.ExperimenterDataOfChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestExperimenterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.experimenter._case.MultipartRequestExperimenterBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

@RunWith(value=MockitoJUnitRunner.class)
public class OF10StatsRequestExperimenterTest {
    @Mock
    SerializerRegistry mockRegistry;
    @Mock
    OFSerializer<ExperimenterDataOfChoice> serializer;
    @Mock
    private ExperimenterDataOfChoice vendorData;

    @Test
    public void testExperimenter() throws Exception {
        Mockito.when((Object)this.mockRegistry.getSerializer((MessageTypeKey)Matchers.any())).thenReturn(this.serializer);
        OF10StatsRequestInputFactory multipartFactory = new OF10StatsRequestInputFactory();
        multipartFactory.injectSerializerRegistry(this.mockRegistry);
        MultipartRequestInputBuilder builder = new MultipartRequestInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setType(MultipartType.OFPMPEXPERIMENTER);
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf(false)));
        MultipartRequestExperimenterCaseBuilder caseBuilder = new MultipartRequestExperimenterCaseBuilder();
        MultipartRequestExperimenterBuilder expBuilder = new MultipartRequestExperimenterBuilder();
        expBuilder.setExperimenter(new ExperimenterId(Long.valueOf(42L)));
        expBuilder.setExpType(Long.valueOf(21L));
        expBuilder.setExperimenterDataOfChoice(this.vendorData);
        caseBuilder.setMultipartRequestExperimenter(expBuilder.build());
        builder.setMultipartRequestBody((MultipartRequestBody)caseBuilder.build());
        MultipartRequestInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        multipartFactory.serialize(message, out);
        BufferHelper.checkHeaderV10(out, (byte)16, 16);
        Assert.assertEquals((String)"Wrong type", (long)65535L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong flags", (long)0L, (long)out.readUnsignedShort());
        ((OFSerializer)Mockito.verify(this.serializer, (VerificationMode)Mockito.times((int)1))).serialize((DataContainer)this.vendorData, out);
    }
}

