/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.OxmArpShaSerializer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ArpSha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpShaCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.arp.sha._case.ArpShaBuilder;

public class OxmArpShaSerializerTest {
    OxmArpShaSerializer serializer = new OxmArpShaSerializer();

    @Test
    public void testSerializeWithoutMask() {
        MatchEntryBuilder builder = OxmArpShaSerializerTest.prepareMatchEntry(false, "00:01:02:03:04:05");
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serialize(builder.build(), buffer);
        OxmArpShaSerializerTest.checkHeader(buffer, false);
        byte[] address = new byte[6];
        buffer.readBytes(address);
        Assert.assertArrayEquals((String)"Wrong address", (byte[])new byte[]{0, 1, 2, 3, 4, 5}, (byte[])address);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeWithMask() {
        MatchEntryBuilder builder = OxmArpShaSerializerTest.prepareMatchEntry(true, "00:01:02:03:04:0A");
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serialize(builder.build(), buffer);
        OxmArpShaSerializerTest.checkHeader(buffer, true);
        byte[] address = new byte[6];
        buffer.readBytes(address);
        Assert.assertArrayEquals((String)"Wrong address", (byte[])new byte[]{0, 1, 2, 3, 4, 10}, (byte[])address);
        byte[] tmp = new byte[6];
        buffer.readBytes(tmp);
        Assert.assertArrayEquals((String)"Wrong mask", (byte[])new byte[]{15, 15, 0, 0, 10, 10}, (byte[])tmp);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeHeaderWithoutMask() {
        MatchEntryBuilder builder = OxmArpShaSerializerTest.prepareHeader(false);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serializeHeader(builder.build(), buffer);
        OxmArpShaSerializerTest.checkHeader(buffer, false);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeHeaderWithMask() {
        MatchEntryBuilder builder = OxmArpShaSerializerTest.prepareHeader(true);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serializeHeader(builder.build(), buffer);
        OxmArpShaSerializerTest.checkHeader(buffer, true);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetOxmClassCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)this.serializer.getOxmClassCode());
    }

    @Test
    public void getOxmFieldCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)24L, (long)this.serializer.getOxmFieldCode());
    }

    @Test
    public void testGetValueLength() {
        Assert.assertEquals((String)"Wrong value length", (long)6L, (long)this.serializer.getValueLength());
    }

    private static MatchEntryBuilder prepareMatchEntry(boolean hasMask, String value) {
        MatchEntryBuilder builder = OxmArpShaSerializerTest.prepareHeader(hasMask);
        ArpShaCaseBuilder casebuilder = new ArpShaCaseBuilder();
        ArpShaBuilder valueBuilder = new ArpShaBuilder();
        if (hasMask) {
            valueBuilder.setMask(new byte[]{15, 15, 0, 0, 10, 10});
        }
        valueBuilder.setMacAddress(new MacAddress(value));
        casebuilder.setArpSha(valueBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)casebuilder.build());
        return builder;
    }

    private static MatchEntryBuilder prepareHeader(boolean hasMask) {
        MatchEntryBuilder builder = new MatchEntryBuilder();
        builder.setOxmClass(OpenflowBasicClass.class);
        builder.setOxmMatchField(ArpSha.class);
        builder.setHasMask(Boolean.valueOf(hasMask));
        return builder;
    }

    private static void checkHeader(ByteBuf buffer, boolean hasMask) {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)buffer.readUnsignedShort());
        short fieldAndMask = buffer.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm-field", (long)24L, (long)(fieldAndMask >>> 1));
        Assert.assertEquals((String)"Wrong hasMask", (Object)hasMask, (Object)((fieldAndMask & 1) != 0 ? 1 : 0));
        if (hasMask) {
            Assert.assertEquals((String)"Wrong length", (long)12L, (long)buffer.readUnsignedByte());
        } else {
            Assert.assertEquals((String)"Wrong length", (long)6L, (long)buffer.readUnsignedByte());
        }
    }
}

