/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.OxmIcmpv4TypeSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Icmpv4Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Icmpv4TypeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv4.type._case.Icmpv4TypeBuilder;

public class OxmIcmpv4TypeSerializerTest {
    OxmIcmpv4TypeSerializer serializer = new OxmIcmpv4TypeSerializer();

    @Test
    public void testSerialize() {
        MatchEntryBuilder builder = OxmIcmpv4TypeSerializerTest.prepareIcmpv4TypeMatchEntry((short)128);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serialize(builder.build(), buffer);
        OxmIcmpv4TypeSerializerTest.checkHeader(buffer, false);
        Assert.assertEquals((String)"Wrong value", (long)128L, (long)buffer.readUnsignedByte());
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeHeader() {
        MatchEntryBuilder builder = OxmIcmpv4TypeSerializerTest.prepareIcmpv4TypeHeader(false);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serializeHeader(builder.build(), buffer);
        OxmIcmpv4TypeSerializerTest.checkHeader(buffer, false);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetOxmClassCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)this.serializer.getOxmClassCode());
    }

    @Test
    public void getOxmFieldCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)19L, (long)this.serializer.getOxmFieldCode());
    }

    @Test
    public void testGetValueLength() {
        Assert.assertEquals((String)"Wrong value length", (long)1L, (long)this.serializer.getValueLength());
    }

    private static MatchEntryBuilder prepareIcmpv4TypeMatchEntry(short value) {
        MatchEntryBuilder builder = OxmIcmpv4TypeSerializerTest.prepareIcmpv4TypeHeader(false);
        Icmpv4TypeCaseBuilder casebuilder = new Icmpv4TypeCaseBuilder();
        Icmpv4TypeBuilder valueBuilder = new Icmpv4TypeBuilder();
        valueBuilder.setIcmpv4Type(Short.valueOf(value));
        casebuilder.setIcmpv4Type(valueBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)casebuilder.build());
        return builder;
    }

    private static MatchEntryBuilder prepareIcmpv4TypeHeader(boolean hasMask) {
        MatchEntryBuilder builder = new MatchEntryBuilder();
        builder.setOxmClass(OpenflowBasicClass.class);
        builder.setOxmMatchField(Icmpv4Type.class);
        builder.setHasMask(Boolean.valueOf(hasMask));
        return builder;
    }

    private static void checkHeader(ByteBuf buffer, boolean hasMask) {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)buffer.readUnsignedShort());
        short fieldAndMask = buffer.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm-field", (long)19L, (long)(fieldAndMask >>> 1));
        Assert.assertEquals((String)"Wrong hasMask", (Object)hasMask, (Object)((fieldAndMask & 1) != 0 ? 1 : 0));
        Assert.assertEquals((String)"Wrong length", (long)1L, (long)buffer.readUnsignedByte());
    }
}

