/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.OxmIcmpv6CodeSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Icmpv6Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Icmpv6CodeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv6.code._case.Icmpv6CodeBuilder;

public class OxmIcmpv6CodeSerializerTest {
    OxmIcmpv6CodeSerializer serializer = new OxmIcmpv6CodeSerializer();

    @Test
    public void testSerialize() {
        MatchEntryBuilder builder = OxmIcmpv6CodeSerializerTest.prepareIcmpv6CodeMatchEntry((short)101);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serialize(builder.build(), buffer);
        OxmIcmpv6CodeSerializerTest.checkHeader(buffer, false);
        Assert.assertEquals((String)"Wrong value", (long)101L, (long)buffer.readUnsignedByte());
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeHeader() {
        MatchEntryBuilder builder = OxmIcmpv6CodeSerializerTest.prepareIcmpv6CodeHeader(false);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serializeHeader(builder.build(), buffer);
        OxmIcmpv6CodeSerializerTest.checkHeader(buffer, false);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetOxmClassCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)this.serializer.getOxmClassCode());
    }

    @Test
    public void getOxmFieldCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)30L, (long)this.serializer.getOxmFieldCode());
    }

    @Test
    public void testGetValueLength() {
        Assert.assertEquals((String)"Wrong value length", (long)1L, (long)this.serializer.getValueLength());
    }

    private static MatchEntryBuilder prepareIcmpv6CodeMatchEntry(short value) {
        MatchEntryBuilder builder = OxmIcmpv6CodeSerializerTest.prepareIcmpv6CodeHeader(false);
        Icmpv6CodeCaseBuilder casebuilder = new Icmpv6CodeCaseBuilder();
        Icmpv6CodeBuilder valueBuilder = new Icmpv6CodeBuilder();
        valueBuilder.setIcmpv6Code(Short.valueOf(value));
        casebuilder.setIcmpv6Code(valueBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)casebuilder.build());
        return builder;
    }

    private static MatchEntryBuilder prepareIcmpv6CodeHeader(boolean hasMask) {
        MatchEntryBuilder builder = new MatchEntryBuilder();
        builder.setOxmClass(OpenflowBasicClass.class);
        builder.setOxmMatchField(Icmpv6Code.class);
        builder.setHasMask(Boolean.valueOf(hasMask));
        return builder;
    }

    private static void checkHeader(ByteBuf buffer, boolean hasMask) {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)buffer.readUnsignedShort());
        short fieldAndMask = buffer.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm-field", (long)30L, (long)(fieldAndMask >>> 1));
        Assert.assertEquals((String)"Wrong hasMask", (Object)hasMask, (Object)((fieldAndMask & 1) != 0 ? 1 : 0));
        Assert.assertEquals((String)"Wrong length", (long)1L, (long)buffer.readUnsignedByte());
    }
}

