/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.OxmIpv6ExtHdrSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Ipv6ExthdrFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Exthdr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6ExthdrCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.exthdr._case.Ipv6ExthdrBuilder;

public class OxmIpv6ExtHdrSerializerTest {
    OxmIpv6ExtHdrSerializer serializer = new OxmIpv6ExtHdrSerializer();

    @Test
    public void testSerializeWithoutMask() {
        MatchEntryBuilder builder = OxmIpv6ExtHdrSerializerTest.prepareIpv6ExtHdrMatchEntry(false, new Ipv6ExthdrFlags(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)));
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serialize(builder.build(), buffer);
        OxmIpv6ExtHdrSerializerTest.checkHeader(buffer, false);
        Assert.assertEquals((String)"Wrong value", (long)358L, (long)buffer.readUnsignedShort());
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeWithMask() {
        MatchEntryBuilder builder = OxmIpv6ExtHdrSerializerTest.prepareIpv6ExtHdrMatchEntry(true, new Ipv6ExthdrFlags(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serialize(builder.build(), buffer);
        OxmIpv6ExtHdrSerializerTest.checkHeader(buffer, true);
        Assert.assertEquals((String)"Wrong value", (long)153L, (long)buffer.readUnsignedShort());
        byte[] tmp = new byte[2];
        buffer.readBytes(tmp);
        Assert.assertArrayEquals((String)"Wrong mask", (byte[])new byte[]{0, 15}, (byte[])tmp);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeHeaderWithoutMask() {
        MatchEntryBuilder builder = OxmIpv6ExtHdrSerializerTest.prepareIpv6ExtHdrHeader(false);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serializeHeader(builder.build(), buffer);
        OxmIpv6ExtHdrSerializerTest.checkHeader(buffer, false);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeHeaderWithMask() {
        MatchEntryBuilder builder = OxmIpv6ExtHdrSerializerTest.prepareIpv6ExtHdrHeader(true);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serializeHeader(builder.build(), buffer);
        OxmIpv6ExtHdrSerializerTest.checkHeader(buffer, true);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetOxmClassCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)this.serializer.getOxmClassCode());
    }

    @Test
    public void getOxmFieldCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)39L, (long)this.serializer.getOxmFieldCode());
    }

    @Test
    public void testGetValueLength() {
        Assert.assertEquals((String)"Wrong value length", (long)2L, (long)this.serializer.getValueLength());
    }

    private static MatchEntryBuilder prepareIpv6ExtHdrMatchEntry(boolean hasMask, Ipv6ExthdrFlags flags) {
        MatchEntryBuilder builder = OxmIpv6ExtHdrSerializerTest.prepareIpv6ExtHdrHeader(hasMask);
        Ipv6ExthdrCaseBuilder casebuilder = new Ipv6ExthdrCaseBuilder();
        Ipv6ExthdrBuilder valueBuilder = new Ipv6ExthdrBuilder();
        if (hasMask) {
            valueBuilder.setMask(new byte[]{0, 15});
        }
        valueBuilder.setPseudoField(flags);
        casebuilder.setIpv6Exthdr(valueBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)casebuilder.build());
        return builder;
    }

    private static MatchEntryBuilder prepareIpv6ExtHdrHeader(boolean hasMask) {
        MatchEntryBuilder builder = new MatchEntryBuilder();
        builder.setOxmClass(OpenflowBasicClass.class);
        builder.setOxmMatchField(Ipv6Exthdr.class);
        builder.setHasMask(Boolean.valueOf(hasMask));
        return builder;
    }

    private static void checkHeader(ByteBuf buffer, boolean hasMask) {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)buffer.readUnsignedShort());
        short fieldAndMask = buffer.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm-field", (long)39L, (long)(fieldAndMask >>> 1));
        Assert.assertEquals((String)"Wrong hasMask", (Object)hasMask, (Object)((fieldAndMask & 1) != 0 ? 1 : 0));
        if (hasMask) {
            Assert.assertEquals((String)"Wrong length", (long)4L, (long)buffer.readUnsignedByte());
        } else {
            Assert.assertEquals((String)"Wrong length", (long)2L, (long)buffer.readUnsignedByte());
        }
    }
}

