/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.OxmIpv6NdSllSerializer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6NdSll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6NdSllCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.nd.sll._case.Ipv6NdSllBuilder;

public class OxmIpv6NdSllSerializerTest {
    OxmIpv6NdSllSerializer serializer = new OxmIpv6NdSllSerializer();

    @Test
    public void testSerialize() {
        MatchEntryBuilder builder = OxmIpv6NdSllSerializerTest.prepareMatchEntry("00:01:02:03:04:05");
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serialize(builder.build(), buffer);
        OxmIpv6NdSllSerializerTest.checkHeader(buffer, false);
        byte[] address = new byte[6];
        buffer.readBytes(address);
        Assert.assertArrayEquals((String)"Wrong address", (byte[])new byte[]{0, 1, 2, 3, 4, 5}, (byte[])address);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeHeader() {
        MatchEntryBuilder builder = OxmIpv6NdSllSerializerTest.prepareHeader(false);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serializeHeader(builder.build(), buffer);
        OxmIpv6NdSllSerializerTest.checkHeader(buffer, false);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetOxmClassCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)this.serializer.getOxmClassCode());
    }

    @Test
    public void getOxmFieldCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32L, (long)this.serializer.getOxmFieldCode());
    }

    @Test
    public void testGetValueLength() {
        Assert.assertEquals((String)"Wrong value length", (long)6L, (long)this.serializer.getValueLength());
    }

    private static MatchEntryBuilder prepareMatchEntry(String value) {
        MatchEntryBuilder builder = OxmIpv6NdSllSerializerTest.prepareHeader(false);
        Ipv6NdSllCaseBuilder casebuilder = new Ipv6NdSllCaseBuilder();
        Ipv6NdSllBuilder valueBuilder = new Ipv6NdSllBuilder();
        valueBuilder.setMacAddress(new MacAddress(value));
        casebuilder.setIpv6NdSll(valueBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)casebuilder.build());
        return builder;
    }

    private static MatchEntryBuilder prepareHeader(boolean hasMask) {
        MatchEntryBuilder builder = new MatchEntryBuilder();
        builder.setOxmClass(OpenflowBasicClass.class);
        builder.setOxmMatchField(Ipv6NdSll.class);
        builder.setHasMask(Boolean.valueOf(hasMask));
        return builder;
    }

    private static void checkHeader(ByteBuf buffer, boolean hasMask) {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)buffer.readUnsignedShort());
        short fieldAndMask = buffer.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm-field", (long)32L, (long)(fieldAndMask >>> 1));
        Assert.assertEquals((String)"Wrong hasMask", (Object)hasMask, (Object)((fieldAndMask & 1) != 0 ? 1 : 0));
        Assert.assertEquals((String)"Wrong length", (long)6L, (long)buffer.readUnsignedByte());
    }
}

