/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.OxmIpv6SrcSerializer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6SrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.src._case.Ipv6SrcBuilder;

public class OxmIpv6SrcSerializerTest {
    OxmIpv6SrcSerializer serializer = new OxmIpv6SrcSerializer();

    @Test
    public void testSerializeWithoutMask() {
        MatchEntryBuilder builder = OxmIpv6SrcSerializerTest.prepareMatchEntry(false, "aaaa:bbbb:1111:2222::");
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serialize(builder.build(), buffer);
        OxmIpv6SrcSerializerTest.checkHeader(buffer, false);
        Assert.assertEquals((String)"Wrong ipv6 address", (long)43690L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)48059L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)4369L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)8738L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)buffer.readUnsignedShort());
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerialize() {
        MatchEntryBuilder builder = OxmIpv6SrcSerializerTest.prepareMatchEntry(false, "::aaaa:bbbb:1111:2222");
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serialize(builder.build(), buffer);
        OxmIpv6SrcSerializerTest.checkHeader(buffer, false);
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)43690L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)48059L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)4369L, (long)buffer.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)8738L, (long)buffer.readUnsignedShort());
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    private static MatchEntryBuilder prepareMatchEntry(boolean hasMask, String value) {
        MatchEntryBuilder builder = OxmIpv6SrcSerializerTest.prepareHeader(hasMask);
        Ipv6SrcCaseBuilder caseBuilder = new Ipv6SrcCaseBuilder();
        Ipv6SrcBuilder srcBuilder = new Ipv6SrcBuilder();
        srcBuilder.setIpv6Address(new Ipv6Address(value));
        if (hasMask) {
            srcBuilder.setMask(new byte[]{15, 15, 0, 0});
        }
        caseBuilder.setIpv6Src(srcBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
        return builder;
    }

    private static MatchEntryBuilder prepareHeader(boolean hasMask) {
        MatchEntryBuilder builder = new MatchEntryBuilder();
        builder.setOxmClass(OpenflowBasicClass.class);
        builder.setOxmMatchField(Ipv6Src.class);
        builder.setHasMask(Boolean.valueOf(hasMask));
        return builder;
    }

    private static void checkHeader(ByteBuf buffer, boolean hasMask) {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)buffer.readUnsignedShort());
        short fieldAndMask = buffer.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm-field", (long)26L, (long)(fieldAndMask >>> 1));
        Assert.assertEquals((String)"Wrong hasMask", (Object)hasMask, (Object)((fieldAndMask & 1) != 0 ? 1 : 0));
        if (hasMask) {
            Assert.assertEquals((String)"Wrong length", (long)32L, (long)buffer.readUnsignedByte());
        } else {
            Assert.assertEquals((String)"Wrong length", (long)16L, (long)buffer.readUnsignedByte());
        }
    }
}

