/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.OxmMetadataSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.MetadataCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.metadata._case.MetadataBuilder;

public class OxmMetadataSerializerTest {
    OxmMetadataSerializer serializer = new OxmMetadataSerializer();

    @Test
    public void testSerializeWithoutMask() {
        MatchEntryBuilder builder = OxmMetadataSerializerTest.prepareMatchEntry(false, new byte[]{0, 1, 2, 3, 4, 5, 6, 7});
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serialize(builder.build(), buffer);
        OxmMetadataSerializerTest.checkHeader(buffer, false);
        byte[] address = new byte[8];
        buffer.readBytes(address);
        Assert.assertArrayEquals((String)"Wrong address", (byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7}, (byte[])address);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeWithMask() {
        MatchEntryBuilder builder = OxmMetadataSerializerTest.prepareMatchEntry(true, new byte[]{8, 9, 10, 11, 12, 13, 14, 15});
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serialize(builder.build(), buffer);
        OxmMetadataSerializerTest.checkHeader(buffer, true);
        byte[] address = new byte[8];
        buffer.readBytes(address);
        Assert.assertArrayEquals((String)"Wrong address", (byte[])new byte[]{8, 9, 10, 11, 12, 13, 14, 15}, (byte[])address);
        byte[] tmp = new byte[8];
        buffer.readBytes(tmp);
        Assert.assertArrayEquals((String)"Wrong mask", (byte[])new byte[]{30, 30, 25, 25, 15, 15, 0, 0}, (byte[])tmp);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeHeaderWithoutMask() {
        MatchEntryBuilder builder = OxmMetadataSerializerTest.prepareHeader(false);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serializeHeader(builder.build(), buffer);
        OxmMetadataSerializerTest.checkHeader(buffer, false);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeHeaderWithMask() {
        MatchEntryBuilder builder = OxmMetadataSerializerTest.prepareHeader(true);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serializeHeader(builder.build(), buffer);
        OxmMetadataSerializerTest.checkHeader(buffer, true);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetOxmClassCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)this.serializer.getOxmClassCode());
    }

    @Test
    public void getOxmFieldCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)2L, (long)this.serializer.getOxmFieldCode());
    }

    @Test
    public void testGetValueLength() {
        Assert.assertEquals((String)"Wrong value length", (long)8L, (long)this.serializer.getValueLength());
    }

    private static MatchEntryBuilder prepareMatchEntry(boolean hasMask, byte[] value) {
        MatchEntryBuilder builder = OxmMetadataSerializerTest.prepareHeader(hasMask);
        MetadataCaseBuilder casebuilder = new MetadataCaseBuilder();
        MetadataBuilder valueBuilder = new MetadataBuilder();
        if (hasMask) {
            valueBuilder.setMask(new byte[]{30, 30, 25, 25, 15, 15, 0, 0});
        }
        valueBuilder.setMetadata(value);
        casebuilder.setMetadata(valueBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)casebuilder.build());
        return builder;
    }

    private static MatchEntryBuilder prepareHeader(boolean hasMask) {
        MatchEntryBuilder builder = new MatchEntryBuilder();
        builder.setOxmClass(OpenflowBasicClass.class);
        builder.setOxmMatchField(Metadata.class);
        builder.setHasMask(Boolean.valueOf(hasMask));
        return builder;
    }

    private static void checkHeader(ByteBuf buffer, boolean hasMask) {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)buffer.readUnsignedShort());
        short fieldAndMask = buffer.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm-field", (long)2L, (long)(fieldAndMask >>> 1));
        Assert.assertEquals((String)"Wrong hasMask", (Object)hasMask, (Object)((fieldAndMask & 1) != 0 ? 1 : 0));
        if (hasMask) {
            Assert.assertEquals((String)"Wrong length", (long)16L, (long)buffer.readUnsignedByte());
        } else {
            Assert.assertEquals((String)"Wrong length", (long)8L, (long)buffer.readUnsignedByte());
        }
    }
}

