/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.OxmPbbIsidSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.PbbIsid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.PbbIsidCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.pbb.isid._case.PbbIsidBuilder;

public class OxmPbbIsidSerializerTest {
    OxmPbbIsidSerializer serializer = new OxmPbbIsidSerializer();

    @Test
    public void testSerializeWithMask() {
        MatchEntryBuilder builder = OxmPbbIsidSerializerTest.preparePbbIsidMatchEntry(false, 12345L);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serialize(builder.build(), buffer);
        OxmPbbIsidSerializerTest.checkHeader(buffer, false);
        Assert.assertEquals((String)"Wrong value", (long)12345L, (long)buffer.readUnsignedMedium());
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeWithoutMask() {
        MatchEntryBuilder builder = OxmPbbIsidSerializerTest.preparePbbIsidMatchEntry(true, 6789L);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serialize(builder.build(), buffer);
        OxmPbbIsidSerializerTest.checkHeader(buffer, true);
        Assert.assertEquals((String)"Wrong value", (long)6789L, (long)buffer.readUnsignedMedium());
        byte[] tmp = new byte[3];
        buffer.readBytes(tmp);
        Assert.assertArrayEquals((String)"Wrong mask", (byte[])new byte[]{0, 15, 10}, (byte[])tmp);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeHeaderWithoutMask() {
        MatchEntryBuilder builder = OxmPbbIsidSerializerTest.preparePbbIsidHeader(false);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serializeHeader(builder.build(), buffer);
        OxmPbbIsidSerializerTest.checkHeader(buffer, false);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeHeaderWithMask() {
        MatchEntryBuilder builder = OxmPbbIsidSerializerTest.preparePbbIsidHeader(true);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        this.serializer.serializeHeader(builder.build(), buffer);
        OxmPbbIsidSerializerTest.checkHeader(buffer, true);
        Assert.assertTrue((String)"Unexpected data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetOxmClassCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)this.serializer.getOxmClassCode());
    }

    @Test
    public void getOxmFieldCode() {
        Assert.assertEquals((String)"Wrong oxm-class", (long)37L, (long)this.serializer.getOxmFieldCode());
    }

    @Test
    public void testGetValueLength() {
        Assert.assertEquals((String)"Wrong value length", (long)3L, (long)this.serializer.getValueLength());
    }

    private static MatchEntryBuilder preparePbbIsidMatchEntry(boolean hasMask, long value) {
        MatchEntryBuilder builder = OxmPbbIsidSerializerTest.preparePbbIsidHeader(hasMask);
        PbbIsidCaseBuilder casebuilder = new PbbIsidCaseBuilder();
        PbbIsidBuilder valueBuilder = new PbbIsidBuilder();
        if (hasMask) {
            valueBuilder.setMask(new byte[]{0, 15, 10});
        }
        valueBuilder.setIsid(Long.valueOf(value));
        casebuilder.setPbbIsid(valueBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)casebuilder.build());
        return builder;
    }

    private static MatchEntryBuilder preparePbbIsidHeader(boolean hasMask) {
        MatchEntryBuilder builder = new MatchEntryBuilder();
        builder.setOxmClass(OpenflowBasicClass.class);
        builder.setOxmMatchField(PbbIsid.class);
        builder.setHasMask(Boolean.valueOf(hasMask));
        return builder;
    }

    private static void checkHeader(ByteBuf buffer, boolean hasMask) {
        Assert.assertEquals((String)"Wrong oxm-class", (long)32768L, (long)buffer.readUnsignedShort());
        short fieldAndMask = buffer.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm-field", (long)37L, (long)(fieldAndMask >>> 1));
        Assert.assertEquals((String)"Wrong hasMask", (Object)hasMask, (Object)((fieldAndMask & 1) != 0 ? 1 : 0));
        if (hasMask) {
            Assert.assertEquals((String)"Wrong length", (long)6L, (long)buffer.readUnsignedByte());
        } else {
            Assert.assertEquals((String)"Wrong length", (long)3L, (long)buffer.readUnsignedByte());
        }
    }
}

