/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMakerFactory;
import org.opendaylight.openflowjava.protocol.impl.util.ListDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.CopyTtlInCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.CopyTtlOutCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.DecMplsTtlCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.DecNwTtlCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.GroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PopMplsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PopPbbCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PopVlanCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PushMplsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PushPbbCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PushVlanCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetFieldCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetMplsTtlCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetNwTtlCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.InPhyPortCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionsDeserializerTest {
    private static final Logger LOG = LoggerFactory.getLogger(ActionsDeserializerTest.class);
    private DeserializerRegistry registry;

    @Before
    public void startUp() {
        this.registry = new DeserializerRegistryImpl();
        this.registry.init();
    }

    @Test
    public void test() {
        ByteBuf message = BufferHelper.buildBuffer("00 00 00 10 00 00 00 01 00 02 00 00 00 00 00 00 00 0B 00 08 00 00 00 00 00 0C 00 08 00 00 00 00 00 0F 00 08 03 00 00 00 00 10 00 08 00 00 00 00 00 11 00 08 00 04 00 00 00 12 00 08 00 00 00 00 00 13 00 08 00 05 00 00 00 14 00 08 00 06 00 00 00 15 00 08 00 00 00 07 00 16 00 08 00 00 00 08 00 17 00 08 09 00 00 00 00 18 00 08 00 00 00 00 00 19 00 10 80 00 02 04 00 00 00 0B 00 00 00 00 00 1A 00 08 00 0A 00 00 00 1B 00 08 00 00 00 00");
        message.skipBytes(4);
        LOG.info("bytes: {}", (Object)message.readableBytes());
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createActionsKeyMaker((short)4);
        List actions = ListDeserializer.deserializeList((short)4, (int)message.readableBytes(), (ByteBuf)message, (CodeKeyMaker)keyMaker, (DeserializerRegistry)this.registry);
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(0)).getActionChoice() instanceof OutputActionCase));
        Assert.assertEquals((String)"Wrong action port", (long)1L, (long)((OutputActionCase)((Action)actions.get(0)).getActionChoice()).getOutputAction().getPort().getValue().intValue());
        Assert.assertEquals((String)"Wrong action max-length", (long)2L, (long)((OutputActionCase)((Action)actions.get(0)).getActionChoice()).getOutputAction().getMaxLength().intValue());
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(1)).getActionChoice() instanceof CopyTtlOutCase));
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(2)).getActionChoice() instanceof CopyTtlInCase));
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(3)).getActionChoice() instanceof SetMplsTtlCase));
        Assert.assertEquals((String)"Wrong action value", (long)3L, (long)((SetMplsTtlCase)((Action)actions.get(3)).getActionChoice()).getSetMplsTtlAction().getMplsTtl().shortValue());
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(4)).getActionChoice() instanceof DecMplsTtlCase));
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(5)).getActionChoice() instanceof PushVlanCase));
        Assert.assertEquals((String)"Wrong action value", (long)4L, (long)((PushVlanCase)((Action)actions.get(5)).getActionChoice()).getPushVlanAction().getEthertype().getValue().intValue());
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(6)).getActionChoice() instanceof PopVlanCase));
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(7)).getActionChoice() instanceof PushMplsCase));
        Assert.assertEquals((String)"Wrong action value", (long)5L, (long)((PushMplsCase)((Action)actions.get(7)).getActionChoice()).getPushMplsAction().getEthertype().getValue().intValue());
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(8)).getActionChoice() instanceof PopMplsCase));
        Assert.assertEquals((String)"Wrong action value", (long)6L, (long)((PopMplsCase)((Action)actions.get(8)).getActionChoice()).getPopMplsAction().getEthertype().getValue().intValue());
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(9)).getActionChoice() instanceof SetQueueCase));
        Assert.assertEquals((String)"Wrong action value", (long)7L, (long)((SetQueueCase)((Action)actions.get(9)).getActionChoice()).getSetQueueAction().getQueueId().intValue());
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(10)).getActionChoice() instanceof GroupCase));
        Assert.assertEquals((String)"Wrong action value", (long)8L, (long)((GroupCase)((Action)actions.get(10)).getActionChoice()).getGroupAction().getGroupId().intValue());
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(11)).getActionChoice() instanceof SetNwTtlCase));
        Assert.assertEquals((String)"Wrong action value", (long)9L, (long)((SetNwTtlCase)((Action)actions.get(11)).getActionChoice()).getSetNwTtlAction().getNwTtl().intValue());
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(12)).getActionChoice() instanceof DecNwTtlCase));
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(13)).getActionChoice() instanceof SetFieldCase));
        List entries = ((SetFieldCase)((Action)actions.get(13)).getActionChoice()).getSetFieldAction().getMatchEntry();
        Assert.assertEquals((String)"Wrong number of fields", (long)1L, (long)entries.size());
        Assert.assertEquals((String)"Wrong match entry class", (Object)"org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass", (Object)((MatchEntry)entries.get(0)).getOxmClass().getName());
        Assert.assertEquals((String)"Wrong match entry field", (Object)"org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPhyPort", (Object)((MatchEntry)entries.get(0)).getOxmMatchField().getName());
        Assert.assertEquals((String)"Wrong match entry mask", (Object)false, (Object)((MatchEntry)entries.get(0)).isHasMask());
        Assert.assertEquals((String)"Wrong match entry value", (long)11L, (long)((InPhyPortCase)((MatchEntry)entries.get(0)).getMatchEntryValue()).getInPhyPort().getPortNumber().getValue().intValue());
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(14)).getActionChoice() instanceof PushPbbCase));
        Assert.assertEquals((String)"Wrong action value", (long)10L, (long)((PushPbbCase)((Action)actions.get(14)).getActionChoice()).getPushPbbAction().getEthertype().getValue().intValue());
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(15)).getActionChoice() instanceof PopPbbCase));
        Assert.assertTrue((String)"Unread data in message", (message.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDeserializeHeader() {
        ByteBuf message = BufferHelper.buildBuffer("00 00 00 04 00 19 00 04");
        message.skipBytes(4);
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createActionsKeyMaker((short)4);
        List actions = ListDeserializer.deserializeHeaders((short)4, (int)message.readableBytes(), (ByteBuf)message, (CodeKeyMaker)keyMaker, (DeserializerRegistry)this.registry);
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(0)).getActionChoice() instanceof OutputActionCase));
        Assert.assertNull((String)"Wrong action port", (Object)((OutputActionCase)((Action)actions.get(0)).getActionChoice()).getOutputAction());
        Assert.assertNull((String)"Wrong action max-length", (Object)((OutputActionCase)((Action)actions.get(0)).getActionChoice()).getOutputAction());
        Assert.assertTrue((String)"Wrong action type", (boolean)(((Action)actions.get(1)).getActionChoice() instanceof SetFieldCase));
        Assert.assertNull((String)"Wrong action oxm field", (Object)((SetFieldCase)((Action)actions.get(1)).getActionChoice()).getSetFieldAction());
    }
}

