/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataObject;

public abstract class BufferHelper {
    public static final Long DEFAULT_XID = 16909060L;
    private static final byte[] XID = new byte[]{1, 2, 3, 4};

    public static ByteBuf buildBuffer(byte[] payload) {
        ByteBuf bb = UnpooledByteBufAllocator.DEFAULT.buffer();
        bb.writeBytes(XID);
        bb.writeBytes(payload);
        return bb;
    }

    public static ByteBuf buildBuffer(String payload) {
        return BufferHelper.buildBuffer(ByteBufUtils.hexStringToBytes((String)payload));
    }

    public static ByteBuf buildBuffer() {
        ByteBuf bb = UnpooledByteBufAllocator.DEFAULT.buffer();
        bb.writeBytes(XID);
        bb.writeBytes(new byte[0]);
        return bb;
    }

    public static void checkHeaderV13(ByteBuf input, byte msgType, int length) {
        BufferHelper.checkHeader(input, msgType, length, (short)4);
    }

    public static void checkHeaderV10(ByteBuf input, byte msgType, int length) {
        BufferHelper.checkHeader(input, msgType, length, (short)1);
    }

    private static void checkHeader(ByteBuf input, byte msgType, int length, Short version) {
        Assert.assertEquals((String)"Wrong version", (Object)version, (Object)input.readByte());
        Assert.assertEquals((String)"Wrong type", (long)msgType, (long)input.readByte());
        Assert.assertEquals((String)"Wrong length", (long)length, (long)input.readUnsignedShort());
        Assert.assertEquals((String)"Wrong Xid", (Object)DEFAULT_XID, (Object)input.readUnsignedInt());
    }

    public static void checkHeaderV13(OfHeader ofHeader) {
        BufferHelper.checkHeader(ofHeader, (short)4);
    }

    public static void checkHeaderV10(OfHeader ofHeader) {
        BufferHelper.checkHeader(ofHeader, (short)1);
    }

    private static void checkHeader(OfHeader ofHeader, Short version) {
        Assert.assertEquals((String)"Wrong version", (Object)version, (Object)ofHeader.getVersion());
        Assert.assertEquals((String)"Wrong Xid", (Object)DEFAULT_XID, (Object)ofHeader.getXid());
    }

    public static void setupHeader(Object builder, int version) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method m = builder.getClass().getMethod("setVersion", Short.class);
        m.invoke(builder, (short)version);
        Method m2 = builder.getClass().getMethod("setXid", Long.class);
        m2.invoke(builder, DEFAULT_XID);
    }

    public static <E extends DataObject> E deserialize(OFDeserializer<E> decoder, ByteBuf bb) {
        return (E)((DataObject)decoder.deserialize(bb));
    }
}

