/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.keys.ActionDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.InstructionDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMakerFactory;

public class CodeKeyMakerFactoryTest {
    @Test
    public void testMatchEntriesKeyMaker() {
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createMatchEntriesKeyMaker((short)4);
        Assert.assertNotNull((String)"Null key maker", (Object)keyMaker);
        ByteBuf buffer = BufferHelper.buildBuffer("80 00 00 04 00 00 00 01");
        buffer.skipBytes(4);
        MessageCodeKey codeKey = keyMaker.make(buffer);
        Assert.assertNotNull((String)"Null key", (Object)codeKey);
        Assert.assertEquals((String)"Wrong key", (Object)new MatchEntryDeserializerKey(4, 32768, 0), (Object)codeKey);
        Assert.assertEquals((String)"Buffer index modified", (long)8L, (long)buffer.readableBytes());
    }

    @Test
    public void testExperimenterMatchEntriesKeyMaker() {
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createMatchEntriesKeyMaker((short)4);
        Assert.assertNotNull((String)"Null key maker", (Object)keyMaker);
        ByteBuf buffer = BufferHelper.buildBuffer("FF FF 00 04 00 00 00 01");
        buffer.skipBytes(4);
        MessageCodeKey codeKey = keyMaker.make(buffer);
        Assert.assertNotNull((String)"Null key", (Object)codeKey);
        MatchEntryDeserializerKey comparationKey = new MatchEntryDeserializerKey(4, 65535, 0);
        comparationKey.setExperimenterId(Long.valueOf(1L));
        Assert.assertEquals((String)"Wrong key", (Object)comparationKey, (Object)codeKey);
        Assert.assertEquals((String)"Buffer index modified", (long)8L, (long)buffer.readableBytes());
    }

    @Test
    public void testActionKeyMaker() {
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createActionsKeyMaker((short)4);
        Assert.assertNotNull((String)"Null key maker", (Object)keyMaker);
        ByteBuf buffer = BufferHelper.buildBuffer("00 00 00 10 00 00 00 01 00 02 00 00 00 00 00 00");
        buffer.skipBytes(4);
        MessageCodeKey codeKey = keyMaker.make(buffer);
        Assert.assertNotNull((String)"Null key", (Object)codeKey);
        Assert.assertEquals((String)"Wrong key", (Object)new ActionDeserializerKey(4, 0, null), (Object)codeKey);
        Assert.assertEquals((String)"Buffer index modified", (long)16L, (long)buffer.readableBytes());
    }

    @Test
    public void testExperimenterActionKeyMaker() {
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createActionsKeyMaker((short)4);
        Assert.assertNotNull((String)"Null key maker", (Object)keyMaker);
        ByteBuf buffer = BufferHelper.buildBuffer("FF FF 00 08 00 00 00 01");
        buffer.skipBytes(4);
        MessageCodeKey codeKey = keyMaker.make(buffer);
        Assert.assertNotNull((String)"Null key", (Object)codeKey);
        Assert.assertEquals((String)"Wrong key", (Object)new ActionDeserializerKey(4, 65535, Long.valueOf(1L)), (Object)codeKey);
        Assert.assertEquals((String)"Buffer index modified", (long)8L, (long)buffer.readableBytes());
    }

    @Test
    public void testInstructionKeyMaker() {
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createInstructionsKeyMaker((short)4);
        Assert.assertNotNull((String)"Null key maker", (Object)keyMaker);
        ByteBuf buffer = BufferHelper.buildBuffer("00 00 00 08");
        buffer.skipBytes(4);
        MessageCodeKey codeKey = keyMaker.make(buffer);
        Assert.assertNotNull((String)"Null key", (Object)codeKey);
        Assert.assertEquals((String)"Wrong key", (Object)new InstructionDeserializerKey(4, 0, null), (Object)codeKey);
        Assert.assertEquals((String)"Buffer index modified", (long)4L, (long)buffer.readableBytes());
    }

    @Test
    public void testExperimenterInstructionKeyMaker() {
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createInstructionsKeyMaker((short)4);
        Assert.assertNotNull((String)"Null key maker", (Object)keyMaker);
        ByteBuf buffer = BufferHelper.buildBuffer("FF FF 00 08 00 00 00 01");
        buffer.skipBytes(4);
        MessageCodeKey codeKey = keyMaker.make(buffer);
        Assert.assertNotNull((String)"Null key", (Object)codeKey);
        Assert.assertEquals((String)"Wrong key", (Object)new InstructionDeserializerKey(4, 65535, Long.valueOf(1L)), (Object)codeKey);
        Assert.assertEquals((String)"Buffer index modified", (long)8L, (long)buffer.readableBytes());
    }
}

