/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMakerFactory;
import org.opendaylight.openflowjava.protocol.impl.util.ListDeserializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.GroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetMplsTtlCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ApplyActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ClearActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.GotoTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.MeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.WriteActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.WriteMetadataCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;

public class InstructionsDeserializerTest {
    private DeserializerRegistry registry;

    @Before
    public void startUp() {
        this.registry = new DeserializerRegistryImpl();
        this.registry.init();
    }

    @Test
    public void test() {
        ByteBuf message = BufferHelper.buildBuffer("00 01 00 08 0A 00 00 00 00 02 00 18 00 00 00 00 00 00 00 00 00 00 00 20 00 00 00 00 00 00 00 30 00 05 00 08 00 00 00 00 00 06 00 08 00 01 02 03 00 03 00 20 00 00 00 00 00 00 00 10 00 00 00 25 00 35 00 00 00 00 00 00 00 16 00 08 00 00 00 50 00 04 00 18 00 00 00 00 00 15 00 08 00 00 00 25 00 0F 00 08 05 00 00 00");
        message.skipBytes(4);
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createInstructionsKeyMaker((short)4);
        List instructions = ListDeserializer.deserializeList((short)4, (int)message.readableBytes(), (ByteBuf)message, (CodeKeyMaker)keyMaker, (DeserializerRegistry)this.registry);
        Instruction i1 = (Instruction)instructions.get(0);
        Assert.assertTrue((String)"Wrong type - i1", (boolean)(i1.getInstructionChoice() instanceof GotoTableCase));
        Assert.assertEquals((String)"Wrong table-id - i1", (long)10L, (long)((GotoTableCase)i1.getInstructionChoice()).getGotoTable().getTableId().intValue());
        Instruction i2 = (Instruction)instructions.get(1);
        Assert.assertTrue((String)"Wrong type - i2", (boolean)(i2.getInstructionChoice() instanceof WriteMetadataCase));
        Assert.assertArrayEquals((String)"Wrong metadata - i2", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 00 00 00 00 20"), (byte[])((WriteMetadataCase)i2.getInstructionChoice()).getWriteMetadata().getMetadata());
        Assert.assertArrayEquals((String)"Wrong metadata-mask - i2", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 00 00 00 00 30"), (byte[])((WriteMetadataCase)i2.getInstructionChoice()).getWriteMetadata().getMetadataMask());
        Instruction i3 = (Instruction)instructions.get(2);
        Assert.assertTrue((String)"Wrong type - i3", (boolean)(i3.getInstructionChoice() instanceof ClearActionsCase));
        Instruction i4 = (Instruction)instructions.get(3);
        Assert.assertTrue((String)"Wrong type - i4", (boolean)(i4.getInstructionChoice() instanceof MeterCase));
        Assert.assertEquals((String)"Wrong meterId - i4", (long)66051L, (long)((MeterCase)i4.getInstructionChoice()).getMeter().getMeterId().intValue());
        Instruction i5 = (Instruction)instructions.get(4);
        Assert.assertTrue((String)"Wrong type - i5", (boolean)(i5.getInstructionChoice() instanceof WriteActionsCase));
        Assert.assertEquals((String)"Wrong instructions - i5", (long)2L, (long)((WriteActionsCase)i5.getInstructionChoice()).getWriteActions().getAction().size());
        Action action1 = (Action)((WriteActionsCase)i5.getInstructionChoice()).getWriteActions().getAction().get(0);
        Assert.assertTrue((String)"Wrong action", (boolean)(action1.getActionChoice() instanceof OutputActionCase));
        Assert.assertEquals((String)"Wrong action", (long)37L, (long)((OutputActionCase)action1.getActionChoice()).getOutputAction().getPort().getValue().intValue());
        Assert.assertEquals((String)"Wrong action", (long)53L, (long)((OutputActionCase)action1.getActionChoice()).getOutputAction().getMaxLength().intValue());
        Action action2 = (Action)((WriteActionsCase)i5.getInstructionChoice()).getWriteActions().getAction().get(1);
        Assert.assertTrue((String)"Wrong action", (boolean)(action2.getActionChoice() instanceof GroupCase));
        Assert.assertEquals((String)"Wrong action", (long)80L, (long)((GroupCase)action2.getActionChoice()).getGroupAction().getGroupId().intValue());
        Instruction i6 = (Instruction)instructions.get(5);
        Assert.assertTrue((String)"Wrong type - i6", (boolean)(i6.getInstructionChoice() instanceof ApplyActionsCase));
        Assert.assertEquals((String)"Wrong instructions - i6", (long)2L, (long)((ApplyActionsCase)i6.getInstructionChoice()).getApplyActions().getAction().size());
        action1 = (Action)((ApplyActionsCase)i6.getInstructionChoice()).getApplyActions().getAction().get(0);
        Assert.assertTrue((String)"Wrong action", (boolean)(action1.getActionChoice() instanceof SetQueueCase));
        Assert.assertEquals((String)"Wrong action", (long)37L, (long)((SetQueueCase)action1.getActionChoice()).getSetQueueAction().getQueueId().intValue());
        action2 = (Action)((ApplyActionsCase)i6.getInstructionChoice()).getApplyActions().getAction().get(1);
        Assert.assertTrue((String)"Wrong action", (boolean)(action2.getActionChoice() instanceof SetMplsTtlCase));
        Assert.assertEquals((String)"Wrong action", (long)5L, (long)((SetMplsTtlCase)action2.getActionChoice()).getSetMplsTtlAction().getMplsTtl().shortValue());
    }
}

