/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.HeaderDeserializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Ipv6ExthdrFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.StandardMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ArpOp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ArpSha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ArpSpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ArpTha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ArpTpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.EthDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.EthSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.EthType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Icmpv4Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Icmpv4Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Icmpv6Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Icmpv6Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.IpDscp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.IpEcn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.IpProto;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv4Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv4Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Exthdr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Flabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6NdSll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6NdTarget;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6NdTll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MplsBos;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MplsLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MplsTc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.PbbIsid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.SctpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.SctpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.TcpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.TcpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.TunnelId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.UdpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.UdpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.VlanPcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.VlanVid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpOpCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpShaCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpSpaCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpThaCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpTpaCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.EthDstCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.EthSrcCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.EthTypeCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Icmpv4CodeCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Icmpv4TypeCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Icmpv6CodeCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Icmpv6TypeCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.InPhyPortCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.InPortCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.IpDscpCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.IpEcnCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.IpProtoCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv4DstCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv4SrcCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6DstCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6ExthdrCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6FlabelCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6NdSllCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6NdTargetCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6NdTllCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6SrcCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.MetadataCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.MplsBosCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.MplsLabelCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.MplsTcCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.PbbIsidCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.SctpDstCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.SctpSrcCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.TcpDstCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.TcpSrcCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.TunnelIdCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.UdpDstCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.UdpSrcCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.VlanPcpCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.VlanVidCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;

public class MatchDeserializerTest {
    private OFDeserializer<Match> matchDeserializer;
    private DeserializerRegistry registry;

    @Before
    public void startUp() {
        this.registry = new DeserializerRegistryImpl();
        this.registry.init();
        this.matchDeserializer = (OFDeserializer)this.registry.getDeserializer(new MessageCodeKey(4, 0, Match.class));
    }

    @Test
    public void testIpv4Address() {
        ByteBuf buffer = ByteBufUtils.hexStringToByteBuf((String)"80 00 18 04 00 01 02 03");
        MatchEntryDeserializerKey key = new MatchEntryDeserializerKey(4, 32768, 12);
        key.setExperimenterId(null);
        OFDeserializer entryDeserializer = (OFDeserializer)this.registry.getDeserializer((MessageCodeKey)key);
        MatchEntry entry = (MatchEntry)entryDeserializer.deserialize(buffer);
        Assert.assertEquals((String)"Wrong Ipv4 address format", (Object)new Ipv4Address("0.1.2.3"), (Object)((Ipv4DstCase)entry.getMatchEntryValue()).getIpv4Dst().getIpv4Address());
    }

    @Test
    public void testIpv6Address() {
        ByteBuf buffer = ByteBufUtils.hexStringToByteBuf((String)"80 00 34 10 00 00 00 01 00 02 00 03 00 04 00 05 00 06 0F 07");
        MatchEntryDeserializerKey key = new MatchEntryDeserializerKey(4, 32768, 26);
        key.setExperimenterId(null);
        OFDeserializer entryDeserializer = (OFDeserializer)this.registry.getDeserializer((MessageCodeKey)key);
        MatchEntry entry = (MatchEntry)entryDeserializer.deserialize(buffer);
        Assert.assertEquals((String)"Wrong Ipv6 address format", (Object)new Ipv6Address("0:1:2:3:4:5:6:f07"), (Object)((Ipv6SrcCase)entry.getMatchEntryValue()).getIpv6Src().getIpv6Address());
    }

    @Test
    public void testMatch() {
        ByteBuf buffer = ByteBufUtils.hexStringToByteBuf((String)"00 01 01 A8 80 00 00 04 00 00 00 01 80 00 02 04 00 00 00 02 80 00 05 10 00 00 00 00 00 00 00 03 00 00 00 00 00 00 00 04 80 00 07 0C 00 00 00 00 00 05 00 00 00 00 00 06 80 00 09 0C 00 00 00 00 00 07 00 00 00 00 00 08 80 00 0A 02 00 09 80 00 0D 04 00 0A 00 0B 80 00 0E 01 0C 80 00 10 01 0D 80 00 12 01 0E 80 00 14 01 0F 80 00 17 08 0A 00 00 01 00 00 FF 00 80 00 19 08 0A 00 00 02 00 00 00 FF 80 00 1A 02 00 03 80 00 1C 02 00 04 80 00 1E 02 00 05 80 00 20 02 00 06 80 00 22 02 00 07 80 00 24 02 00 08 80 00 26 01 05 80 00 28 01 07 80 00 2A 02 00 10 80 00 2D 08 0A 00 00 09 00 00 FF 00 80 00 2F 08 0A 00 00 0A 00 00 00 FF 80 00 31 0C 00 00 00 00 00 01 00 00 00 00 00 03 80 00 33 0C 00 00 00 00 00 02 00 00 00 00 00 04 80 00 35 20 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 15 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 16 80 00 37 20 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 17 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 18 80 00 38 04 00 00 00 02 80 00 3A 01 15 80 00 3C 01 17 80 00 3E 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 20 80 00 40 06 00 05 00 00 00 01 80 00 42 06 00 05 00 00 00 02 80 00 44 04 00 00 02 03 80 00 46 01 03 80 00 48 01 01 80 00 4B 06 00 00 02 00 00 01 80 00 4D 10 00 00 00 00 00 00 00 07 00 00 00 00 00 00 00 FF 80 00 4F 04 00 00 03 04");
        System.out.println(buffer.readableBytes());
        Match match = (Match)this.matchDeserializer.deserialize(buffer);
        Assert.assertEquals((String)"Wrong match type", OxmMatchType.class, (Object)match.getType());
        Assert.assertEquals((String)"Wrong match entries size", (long)40L, (long)match.getMatchEntry().size());
        List entries = match.getMatchEntry();
        MatchEntry entry0 = (MatchEntry)entries.get(0);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry0.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", InPort.class, (Object)entry0.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry0.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)1L, (long)((InPortCase)entry0.getMatchEntryValue()).getInPort().getPortNumber().getValue().intValue());
        MatchEntry entry1 = (MatchEntry)entries.get(1);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry1.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", InPhyPort.class, (Object)entry1.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry1.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)2L, (long)((InPhyPortCase)entry1.getMatchEntryValue()).getInPhyPort().getPortNumber().getValue().intValue());
        MatchEntry entry2 = (MatchEntry)entries.get(2);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry2.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Metadata.class, (Object)entry2.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry2.isHasMask());
        Assert.assertArrayEquals((String)"Wrong entry value", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 00 00 00 00 03"), (byte[])((MetadataCase)entry2.getMatchEntryValue()).getMetadata().getMetadata());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 00 00 00 00 04"), (byte[])((MetadataCase)entry2.getMatchEntryValue()).getMetadata().getMask());
        MatchEntry entry3 = (MatchEntry)entries.get(3);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry3.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", EthDst.class, (Object)entry3.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry3.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new MacAddress("00:00:00:00:00:05"), (Object)((EthDstCase)entry3.getMatchEntryValue()).getEthDst().getMacAddress());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 00 00 06"), (byte[])((EthDstCase)entry3.getMatchEntryValue()).getEthDst().getMask());
        MatchEntry entry4 = (MatchEntry)entries.get(4);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry4.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", EthSrc.class, (Object)entry4.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry4.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new MacAddress("00:00:00:00:00:07"), (Object)((EthSrcCase)entry4.getMatchEntryValue()).getEthSrc().getMacAddress());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 00 00 08"), (byte[])((EthSrcCase)entry4.getMatchEntryValue()).getEthSrc().getMask());
        MatchEntry entry5 = (MatchEntry)entries.get(5);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry5.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", EthType.class, (Object)entry5.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry5.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)9L, (long)((EthTypeCase)entry5.getMatchEntryValue()).getEthType().getEthType().getValue().intValue());
        MatchEntry entry6 = (MatchEntry)entries.get(6);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry6.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", VlanVid.class, (Object)entry6.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry6.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)10L, (long)((VlanVidCase)entry6.getMatchEntryValue()).getVlanVid().getVlanVid().intValue());
        Assert.assertEquals((String)"Wrong entry value", (Object)false, (Object)((VlanVidCase)entry6.getMatchEntryValue()).getVlanVid().isCfiBit());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 0B"), (byte[])((VlanVidCase)entry6.getMatchEntryValue()).getVlanVid().getMask());
        MatchEntry entry7 = (MatchEntry)entries.get(7);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry7.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", VlanPcp.class, (Object)entry7.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry7.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)12L, (long)((VlanPcpCase)entry7.getMatchEntryValue()).getVlanPcp().getVlanPcp().intValue());
        MatchEntry entry8 = (MatchEntry)entries.get(8);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry8.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", IpDscp.class, (Object)entry8.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry8.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)13L, (long)((IpDscpCase)entry8.getMatchEntryValue()).getIpDscp().getDscp().getValue().intValue());
        MatchEntry entry9 = (MatchEntry)entries.get(9);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry9.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", IpEcn.class, (Object)entry9.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry9.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)14L, (long)((IpEcnCase)entry9.getMatchEntryValue()).getIpEcn().getEcn().intValue());
        MatchEntry entry10 = (MatchEntry)entries.get(10);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry10.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", IpProto.class, (Object)entry10.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry10.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)15L, (long)((IpProtoCase)entry10.getMatchEntryValue()).getIpProto().getProtocolNumber().intValue());
        MatchEntry entry11 = (MatchEntry)entries.get(11);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry11.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Ipv4Src.class, (Object)entry11.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry11.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new Ipv4Address("10.0.0.1"), (Object)((Ipv4SrcCase)entry11.getMatchEntryValue()).getIpv4Src().getIpv4Address());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 FF 00"), (byte[])((Ipv4SrcCase)entry11.getMatchEntryValue()).getIpv4Src().getMask());
        MatchEntry entry12 = (MatchEntry)entries.get(12);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry12.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Ipv4Dst.class, (Object)entry12.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry12.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new Ipv4Address("10.0.0.2"), (Object)((Ipv4DstCase)entry12.getMatchEntryValue()).getIpv4Dst().getIpv4Address());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 FF"), (byte[])((Ipv4DstCase)entry12.getMatchEntryValue()).getIpv4Dst().getMask());
        MatchEntry entry13 = (MatchEntry)entries.get(13);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry13.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", TcpSrc.class, (Object)entry13.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry13.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)3L, (long)((TcpSrcCase)entry13.getMatchEntryValue()).getTcpSrc().getPort().getValue().intValue());
        MatchEntry entry14 = (MatchEntry)entries.get(14);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry14.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", TcpDst.class, (Object)entry14.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry14.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)4L, (long)((TcpDstCase)entry14.getMatchEntryValue()).getTcpDst().getPort().getValue().intValue());
        MatchEntry entry15 = (MatchEntry)entries.get(15);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry15.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", UdpSrc.class, (Object)entry15.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry15.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)5L, (long)((UdpSrcCase)entry15.getMatchEntryValue()).getUdpSrc().getPort().getValue().intValue());
        MatchEntry entry16 = (MatchEntry)entries.get(16);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry16.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", UdpDst.class, (Object)entry16.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry16.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)6L, (long)((UdpDstCase)entry16.getMatchEntryValue()).getUdpDst().getPort().getValue().intValue());
        MatchEntry entry17 = (MatchEntry)entries.get(17);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry17.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", SctpSrc.class, (Object)entry17.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry17.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)7L, (long)((SctpSrcCase)entry17.getMatchEntryValue()).getSctpSrc().getPort().getValue().intValue());
        MatchEntry entry18 = (MatchEntry)entries.get(18);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry18.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", SctpDst.class, (Object)entry18.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry18.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)8L, (long)((SctpDstCase)entry18.getMatchEntryValue()).getSctpDst().getPort().getValue().intValue());
        MatchEntry entry19 = (MatchEntry)entries.get(19);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry19.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Icmpv4Type.class, (Object)entry19.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry19.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)5L, (long)((Icmpv4TypeCase)entry19.getMatchEntryValue()).getIcmpv4Type().getIcmpv4Type().intValue());
        MatchEntry entry20 = (MatchEntry)entries.get(20);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry20.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Icmpv4Code.class, (Object)entry20.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry20.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)7L, (long)((Icmpv4CodeCase)entry20.getMatchEntryValue()).getIcmpv4Code().getIcmpv4Code().intValue());
        MatchEntry entry21 = (MatchEntry)entries.get(21);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry21.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", ArpOp.class, (Object)entry21.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry21.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)16L, (long)((ArpOpCase)entry21.getMatchEntryValue()).getArpOp().getOpCode().intValue());
        MatchEntry entry22 = (MatchEntry)entries.get(22);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry22.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", ArpSpa.class, (Object)entry22.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry22.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new Ipv4Address("10.0.0.9"), (Object)((ArpSpaCase)entry22.getMatchEntryValue()).getArpSpa().getIpv4Address());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 FF 00"), (byte[])((ArpSpaCase)entry22.getMatchEntryValue()).getArpSpa().getMask());
        MatchEntry entry23 = (MatchEntry)entries.get(23);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry23.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", ArpTpa.class, (Object)entry23.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry23.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new Ipv4Address("10.0.0.10"), (Object)((ArpTpaCase)entry23.getMatchEntryValue()).getArpTpa().getIpv4Address());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 FF"), (byte[])((ArpTpaCase)entry23.getMatchEntryValue()).getArpTpa().getMask());
        MatchEntry entry24 = (MatchEntry)entries.get(24);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry24.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", ArpSha.class, (Object)entry24.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry24.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new MacAddress("00:00:00:00:00:01"), (Object)((ArpShaCase)entry24.getMatchEntryValue()).getArpSha().getMacAddress());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 00 00 03"), (byte[])((ArpShaCase)entry24.getMatchEntryValue()).getArpSha().getMask());
        MatchEntry entry25 = (MatchEntry)entries.get(25);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry25.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", ArpTha.class, (Object)entry25.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry25.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new MacAddress("00:00:00:00:00:02"), (Object)((ArpThaCase)entry25.getMatchEntryValue()).getArpTha().getMacAddress());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 00 00 04"), (byte[])((ArpThaCase)entry25.getMatchEntryValue()).getArpTha().getMask());
        MatchEntry entry26 = (MatchEntry)entries.get(26);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry26.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Ipv6Src.class, (Object)entry26.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry26.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new Ipv6Address("::15"), (Object)((Ipv6SrcCase)entry26.getMatchEntryValue()).getIpv6Src().getIpv6Address());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 16"), (byte[])((Ipv6SrcCase)entry26.getMatchEntryValue()).getIpv6Src().getMask());
        MatchEntry entry27 = (MatchEntry)entries.get(27);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry27.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Ipv6Dst.class, (Object)entry27.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry27.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new Ipv6Address("::17"), (Object)((Ipv6DstCase)entry27.getMatchEntryValue()).getIpv6Dst().getIpv6Address());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 18"), (byte[])((Ipv6DstCase)entry27.getMatchEntryValue()).getIpv6Dst().getMask());
        MatchEntry entry28 = (MatchEntry)entries.get(28);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry28.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Ipv6Flabel.class, (Object)entry28.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry28.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)2L, (long)((Ipv6FlabelCase)entry28.getMatchEntryValue()).getIpv6Flabel().getIpv6Flabel().getValue().intValue());
        MatchEntry entry29 = (MatchEntry)entries.get(29);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry29.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Icmpv6Type.class, (Object)entry29.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry29.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)21L, (long)((Icmpv6TypeCase)entry29.getMatchEntryValue()).getIcmpv6Type().getIcmpv6Type().intValue());
        MatchEntry entry30 = (MatchEntry)entries.get(30);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry30.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Icmpv6Code.class, (Object)entry30.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry30.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)23L, (long)((Icmpv6CodeCase)entry30.getMatchEntryValue()).getIcmpv6Code().getIcmpv6Code().intValue());
        MatchEntry entry31 = (MatchEntry)entries.get(31);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry31.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Ipv6NdTarget.class, (Object)entry31.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry31.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new Ipv6Address("::20"), (Object)((Ipv6NdTargetCase)entry31.getMatchEntryValue()).getIpv6NdTarget().getIpv6Address());
        MatchEntry entry32 = (MatchEntry)entries.get(32);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry32.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Ipv6NdSll.class, (Object)entry32.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry32.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new MacAddress("00:05:00:00:00:01"), (Object)((Ipv6NdSllCase)entry32.getMatchEntryValue()).getIpv6NdSll().getMacAddress());
        MatchEntry entry33 = (MatchEntry)entries.get(33);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry33.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Ipv6NdTll.class, (Object)entry33.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry33.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new MacAddress("00:05:00:00:00:02"), (Object)((Ipv6NdTllCase)entry33.getMatchEntryValue()).getIpv6NdTll().getMacAddress());
        MatchEntry entry34 = (MatchEntry)entries.get(34);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry34.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", MplsLabel.class, (Object)entry34.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry34.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)515L, (long)((MplsLabelCase)entry34.getMatchEntryValue()).getMplsLabel().getMplsLabel().intValue());
        MatchEntry entry35 = (MatchEntry)entries.get(35);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry35.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", MplsTc.class, (Object)entry35.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry35.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)3L, (long)((MplsTcCase)entry35.getMatchEntryValue()).getMplsTc().getTc().intValue());
        MatchEntry entry36 = (MatchEntry)entries.get(36);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry36.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", MplsBos.class, (Object)entry36.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry36.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)true, (Object)((MplsBosCase)entry36.getMatchEntryValue()).getMplsBos().isBos());
        MatchEntry entry37 = (MatchEntry)entries.get(37);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry37.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", PbbIsid.class, (Object)entry37.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry37.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)2L, (long)((PbbIsidCase)entry37.getMatchEntryValue()).getPbbIsid().getIsid().intValue());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 01"), (byte[])((PbbIsidCase)entry37.getMatchEntryValue()).getPbbIsid().getMask());
        MatchEntry entry38 = (MatchEntry)entries.get(38);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry38.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", TunnelId.class, (Object)entry38.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry38.isHasMask());
        Assert.assertArrayEquals((String)"Wrong entry value", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 00 00 00 00 07"), (byte[])((TunnelIdCase)entry38.getMatchEntryValue()).getTunnelId().getTunnelId());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 00 00 00 00 FF"), (byte[])((TunnelIdCase)entry38.getMatchEntryValue()).getTunnelId().getMask());
        MatchEntry entry39 = (MatchEntry)entries.get(39);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry39.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Ipv6Exthdr.class, (Object)entry39.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry39.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new Ipv6ExthdrFlags(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)((Ipv6ExthdrCase)entry39.getMatchEntryValue()).getIpv6Exthdr().getPseudoField());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])ByteBufUtils.hexStringToBytes((String)"03 04"), (byte[])((Ipv6ExthdrCase)entry39.getMatchEntryValue()).getIpv6Exthdr().getMask());
        Assert.assertTrue((String)"Unread data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHeaders() {
        ByteBuf buffer = ByteBufUtils.hexStringToByteBuf((String)"80 00 18 04 00 01 02 03");
        MatchEntryDeserializerKey key = new MatchEntryDeserializerKey(4, 32768, 12);
        key.setExperimenterId(null);
        HeaderDeserializer entryDeserializer = (HeaderDeserializer)this.registry.getDeserializer((MessageCodeKey)key);
        MatchEntry entry = (MatchEntry)entryDeserializer.deserializeHeader(buffer);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Ipv4Dst.class, (Object)entry.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry.isHasMask());
        Assert.assertNull((String)"Wrong Ipv4 address", (Object)entry.getMatchEntryValue());
    }

    @Test
    public void testStandardMatch() {
        ByteBuf buffer = ByteBufUtils.hexStringToByteBuf((String)"00 00 00 10 80 00 04 08 00 00 00 00 00 00 00 01");
        Match match = (Match)this.matchDeserializer.deserialize(buffer);
        Assert.assertEquals((String)"Wrong match type", StandardMatchType.class, (Object)match.getType());
        Assert.assertEquals((String)"Wrong match entries size", (long)1L, (long)match.getMatchEntry().size());
    }
}

