/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMakerFactory;
import org.opendaylight.openflowjava.protocol.impl.util.ListDeserializer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.EnqueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetDlDstCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetDlSrcCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetNwDstCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetNwSrcCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetNwTosCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetTpDstCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetTpSrcCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetVlanPcpCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetVlanVidCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.StripVlanCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;

public class OF10ActionsDeserializerTest {
    private DeserializerRegistry registry;

    @Before
    public void startUp() {
        this.registry = new DeserializerRegistryImpl();
        this.registry.init();
    }

    @Test
    public void test() {
        ByteBuf message = BufferHelper.buildBuffer("00 00 00 08 00 10 20 00 00 01 00 08 10 10 00 00 00 02 00 08 25 00 00 00 00 03 00 08 00 00 00 00 00 04 00 10 01 02 03 04 05 06 00 00 00 00 00 00 00 05 00 10 02 03 04 05 06 07 00 00 00 00 00 00 00 06 00 08 0A 00 00 01 00 07 00 08 0B 00 00 02 00 08 00 08 01 00 00 00 00 09 00 08 00 02 00 00 00 0A 00 08 00 03 00 00 00 0B 00 10 00 04 00 00 00 00 00 00 00 00 00 30");
        message.skipBytes(4);
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createActionsKeyMaker((short)1);
        List actions = ListDeserializer.deserializeList((short)1, (int)message.readableBytes(), (ByteBuf)message, (CodeKeyMaker)keyMaker, (DeserializerRegistry)this.registry);
        Assert.assertEquals((String)"Wrong number of actions", (long)12L, (long)actions.size());
        Action action1 = (Action)actions.get(0);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action1.getActionChoice() instanceof OutputActionCase));
        Assert.assertEquals((String)"Wrong port", (long)16L, (long)((OutputActionCase)action1.getActionChoice()).getOutputAction().getPort().getValue().intValue());
        Assert.assertEquals((String)"Wrong max-length", (long)8192L, (long)((OutputActionCase)action1.getActionChoice()).getOutputAction().getMaxLength().intValue());
        Action action2 = (Action)actions.get(1);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action2.getActionChoice() instanceof SetVlanVidCase));
        Assert.assertEquals((String)"Wrong vlan-vid", (long)4112L, (long)((SetVlanVidCase)action2.getActionChoice()).getSetVlanVidAction().getVlanVid().intValue());
        Action action3 = (Action)actions.get(2);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action3.getActionChoice() instanceof SetVlanPcpCase));
        Assert.assertEquals((String)"Wrong vlan-pcp", (long)37L, (long)((SetVlanPcpCase)action3.getActionChoice()).getSetVlanPcpAction().getVlanPcp().intValue());
        Action action4 = (Action)actions.get(3);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action4.getActionChoice() instanceof StripVlanCase));
        Action action5 = (Action)actions.get(4);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action5.getActionChoice() instanceof SetDlSrcCase));
        Assert.assertEquals((String)"Wrong dl-src", (Object)"01:02:03:04:05:06", (Object)((SetDlSrcCase)action5.getActionChoice()).getSetDlSrcAction().getDlSrcAddress().getValue());
        Action action6 = (Action)actions.get(5);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action6.getActionChoice() instanceof SetDlDstCase));
        Assert.assertEquals((String)"Wrong dl-dst", (Object)"02:03:04:05:06:07", (Object)((SetDlDstCase)action6.getActionChoice()).getSetDlDstAction().getDlDstAddress().getValue());
        Action action7 = (Action)actions.get(6);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action7.getActionChoice() instanceof SetNwSrcCase));
        Assert.assertEquals((String)"Wrong nw-src", (Object)new Ipv4Address("10.0.0.1"), (Object)((SetNwSrcCase)action7.getActionChoice()).getSetNwSrcAction().getIpAddress());
        Action action8 = (Action)actions.get(7);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action8.getActionChoice() instanceof SetNwDstCase));
        Assert.assertEquals((String)"Wrong nw-dst", (Object)new Ipv4Address("11.0.0.2"), (Object)((SetNwDstCase)action8.getActionChoice()).getSetNwDstAction().getIpAddress());
        Action action9 = (Action)actions.get(8);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action9.getActionChoice() instanceof SetNwTosCase));
        Assert.assertEquals((String)"Wrong nw-tos", (long)1L, (long)((SetNwTosCase)action9.getActionChoice()).getSetNwTosAction().getNwTos().intValue());
        Action action10 = (Action)actions.get(9);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action10.getActionChoice() instanceof SetTpSrcCase));
        Assert.assertEquals((String)"Wrong port", (long)2L, (long)((SetTpSrcCase)action10.getActionChoice()).getSetTpSrcAction().getPort().getValue().intValue());
        Action action11 = (Action)actions.get(10);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action11.getActionChoice() instanceof SetTpDstCase));
        Assert.assertEquals((String)"Wrong port", (long)3L, (long)((SetTpDstCase)action11.getActionChoice()).getSetTpDstAction().getPort().getValue().intValue());
        Action action12 = (Action)actions.get(11);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action12.getActionChoice() instanceof EnqueueCase));
        Assert.assertEquals((String)"Wrong port", (long)4L, (long)((EnqueueCase)action12.getActionChoice()).getEnqueueAction().getPort().getValue().intValue());
        Assert.assertEquals((String)"Wrong queue-id", (long)48L, (long)((EnqueueCase)action12.getActionChoice()).getEnqueueAction().getQueueId().getValue().intValue());
    }
}

