/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.ListSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMakerFactory;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.EnqueueCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetDlDstCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetDlSrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetNwDstCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetNwSrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetNwTosCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetTpDstCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetTpSrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetVlanPcpCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetVlanVidCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.StripVlanCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.enqueue._case.EnqueueActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.output.action._case.OutputActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.dl.dst._case.SetDlDstActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.dl.src._case.SetDlSrcActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.nw.dst._case.SetNwDstActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.nw.src._case.SetNwSrcActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.nw.tos._case.SetNwTosActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.tp.dst._case.SetTpDstActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.tp.src._case.SetTpSrcActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.vlan.pcp._case.SetVlanPcpActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.vlan.vid._case.SetVlanVidActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueId;

public class OF10ActionsSerializerTest {
    private SerializerRegistry registry;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
    }

    @Test
    public void test() {
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        OutputActionCaseBuilder caseBuilder = new OutputActionCaseBuilder();
        OutputActionBuilder outputBuilder = new OutputActionBuilder();
        outputBuilder.setPort(new PortNumber(Long.valueOf(42L)));
        outputBuilder.setMaxLength(Integer.valueOf(32));
        caseBuilder.setOutputAction(outputBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)caseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetVlanVidCaseBuilder vlanVidCaseBuilder = new SetVlanVidCaseBuilder();
        SetVlanVidActionBuilder vlanVidBuilder = new SetVlanVidActionBuilder();
        vlanVidBuilder.setVlanVid(Integer.valueOf(15));
        vlanVidCaseBuilder.setSetVlanVidAction(vlanVidBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)vlanVidCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetVlanPcpCaseBuilder vlanPcpCaseBuilder = new SetVlanPcpCaseBuilder();
        SetVlanPcpActionBuilder vlanPcpBuilder = new SetVlanPcpActionBuilder();
        vlanPcpBuilder.setVlanPcp(Short.valueOf((short)16));
        vlanPcpCaseBuilder.setSetVlanPcpAction(vlanPcpBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)vlanPcpCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice((ActionChoice)new StripVlanCaseBuilder().build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetDlSrcCaseBuilder dlSrcCaseBuilder = new SetDlSrcCaseBuilder();
        SetDlSrcActionBuilder dlSrcBuilder = new SetDlSrcActionBuilder();
        dlSrcBuilder.setDlSrcAddress(new MacAddress("00:00:00:02:03:04"));
        dlSrcCaseBuilder.setSetDlSrcAction(dlSrcBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)dlSrcCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetDlDstCaseBuilder dlDstCaseBuilder = new SetDlDstCaseBuilder();
        SetDlDstActionBuilder dlDstBuilder = new SetDlDstActionBuilder();
        dlDstBuilder.setDlDstAddress(new MacAddress("00:00:00:01:02:03"));
        dlDstCaseBuilder.setSetDlDstAction(dlDstBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)dlDstCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetNwSrcCaseBuilder nwSrcCaseBuilder = new SetNwSrcCaseBuilder();
        SetNwSrcActionBuilder nwSrcBuilder = new SetNwSrcActionBuilder();
        nwSrcBuilder.setIpAddress(new Ipv4Address("10.0.0.1"));
        nwSrcCaseBuilder.setSetNwSrcAction(nwSrcBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)nwSrcCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetNwDstCaseBuilder nwDstCaseBuilder = new SetNwDstCaseBuilder();
        SetNwDstActionBuilder nwDstBuilder = new SetNwDstActionBuilder();
        nwDstBuilder.setIpAddress(new Ipv4Address("10.0.0.3"));
        nwDstCaseBuilder.setSetNwDstAction(nwDstBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)nwDstCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetNwTosCaseBuilder tosCaseBuilder = new SetNwTosCaseBuilder();
        SetNwTosActionBuilder tosBuilder = new SetNwTosActionBuilder();
        tosBuilder.setNwTos(Short.valueOf((short)204));
        tosCaseBuilder.setSetNwTosAction(tosBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)tosCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetTpSrcCaseBuilder tpSrcCaseBuilder = new SetTpSrcCaseBuilder();
        SetTpSrcActionBuilder tpSrcBuilder = new SetTpSrcActionBuilder();
        tpSrcBuilder.setPort(new PortNumber(Long.valueOf(6653L)));
        tpSrcCaseBuilder.setSetTpSrcAction(tpSrcBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)tpSrcCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetTpDstCaseBuilder tpDstCaseBuilder = new SetTpDstCaseBuilder();
        SetTpDstActionBuilder tpDstBuilder = new SetTpDstActionBuilder();
        tpDstBuilder.setPort(new PortNumber(Long.valueOf(6633L)));
        tpDstCaseBuilder.setSetTpDstAction(tpDstBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)tpDstCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        EnqueueCaseBuilder enqueueCaseBuilder = new EnqueueCaseBuilder();
        EnqueueActionBuilder enqueueBuilder = new EnqueueActionBuilder();
        enqueueBuilder.setPort(new PortNumber(Long.valueOf(6613L)));
        enqueueBuilder.setQueueId(new QueueId(Long.valueOf(400L)));
        enqueueCaseBuilder.setEnqueueAction(enqueueBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)enqueueCaseBuilder.build());
        actions.add(actionBuilder.build());
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        ListSerializer.serializeList(actions, (TypeKeyMaker)TypeKeyMakerFactory.createActionKeyMaker((short)1), (SerializerRegistry)this.registry, (ByteBuf)out);
        Assert.assertEquals((String)"Wrong action type", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong port", (long)42L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong max-length", (long)32L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action type", (long)1L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong vlan-vid", (long)15L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong action type", (long)2L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong vlan-pcp", (long)16L, (long)out.readUnsignedByte());
        out.skipBytes(3);
        Assert.assertEquals((String)"Wrong action type", (long)3L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong action type", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)16L, (long)out.readUnsignedShort());
        byte[] data = new byte[6];
        out.readBytes(data);
        Assert.assertArrayEquals((String)"Wrong dl-address", (byte[])ByteBufUtils.macAddressToBytes((String)"00:00:00:02:03:04"), (byte[])data);
        out.skipBytes(6);
        Assert.assertEquals((String)"Wrong action type", (long)5L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)16L, (long)out.readUnsignedShort());
        data = new byte[6];
        out.readBytes(data);
        Assert.assertArrayEquals((String)"Wrong dl-address", (byte[])ByteBufUtils.macAddressToBytes((String)"00:00:00:01:02:03"), (byte[])data);
        out.skipBytes(6);
        Assert.assertEquals((String)"Wrong action type", (long)6L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ip-address(1)", (long)10L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ip-address(2)", (long)0L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ip-address(3)", (long)0L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ip-address(4)", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong action type", (long)7L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ip-address(1)", (long)10L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ip-address(2)", (long)0L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ip-address(3)", (long)0L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ip-address(4)", (long)3L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong action type", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong nw-tos", (long)204L, (long)out.readUnsignedByte());
        out.skipBytes(3);
        Assert.assertEquals((String)"Wrong action type", (long)9L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong port", (long)6653L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong action type", (long)10L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong port", (long)6633L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong action type", (long)11L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)16L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong port", (long)6613L, (long)out.readUnsignedShort());
        out.skipBytes(6);
        Assert.assertEquals((String)"Wrong queue-id", (long)400L, (long)out.readUnsignedInt());
        Assert.assertTrue((String)"Written more bytes than needed", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }
}

