/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;

public class OF10MatchDeserializerTest {
    private OFDeserializer<MatchV10> matchDeserializer;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.matchDeserializer = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(1, 0, MatchV10.class));
    }

    @Test
    public void test() {
        ByteBuf message = BufferHelper.buildBuffer("00 24 08 91 00 20 AA BB CC DD EE FF AA BB CC DD EE FF 00 05 10 00 00 08 07 06 00 00 10 11 12 13 01 02 03 04 50 50 20 20");
        message.skipBytes(4);
        MatchV10 match = (MatchV10)this.matchDeserializer.deserialize(message);
        Assert.assertEquals((String)"Wrong wildcards", (Object)new FlowWildcardsV10(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)), (Object)match.getWildcards());
        Assert.assertEquals((String)"Wrong srcMask", (long)24L, (long)match.getNwSrcMask().shortValue());
        Assert.assertEquals((String)"Wrong dstMask", (long)16L, (long)match.getNwDstMask().shortValue());
        Assert.assertEquals((String)"Wrong in-port", (long)32L, (long)match.getInPort().intValue());
        Assert.assertEquals((String)"Wrong dl-src", (Object)new MacAddress("aa:bb:cc:dd:ee:ff"), (Object)match.getDlSrc());
        Assert.assertEquals((String)"Wrong dl-dst", (Object)new MacAddress("aa:bb:cc:dd:ee:ff"), (Object)match.getDlDst());
        Assert.assertEquals((String)"Wrong dl-vlan", (long)5L, (long)match.getDlVlan().intValue());
        Assert.assertEquals((String)"Wrong dl-vlan-pcp", (long)16L, (long)match.getDlVlanPcp().shortValue());
        Assert.assertEquals((String)"Wrong dl-type", (long)8L, (long)match.getDlType().intValue());
        Assert.assertEquals((String)"Wrong nw-tos", (long)7L, (long)match.getNwTos().shortValue());
        Assert.assertEquals((String)"Wrong nw-proto", (long)6L, (long)match.getNwProto().shortValue());
        Assert.assertEquals((String)"Wrong nw-src", (Object)new Ipv4Address("16.17.18.19"), (Object)match.getNwSrc());
        Assert.assertEquals((String)"Wrong nw-dst", (Object)new Ipv4Address("1.2.3.4"), (Object)match.getNwDst());
        Assert.assertEquals((String)"Wrong tp-src", (long)20560L, (long)match.getTpSrc().shortValue());
        Assert.assertEquals((String)"Wrong tp-dst", (long)8224L, (long)match.getTpDst().shortValue());
    }

    @Test
    public void test2() {
        ByteBuf message = BufferHelper.buildBuffer("00 3F FF FF 00 20 AA BB CC DD EE FF AA BB CC DD EE FF 00 05 10 00 00 08 07 06 00 00 10 11 12 13 01 02 03 04 50 50 20 20");
        message.skipBytes(4);
        MatchV10 match = (MatchV10)this.matchDeserializer.deserialize(message);
        Assert.assertEquals((String)"Wrong wildcards", (Object)new FlowWildcardsV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)match.getWildcards());
        Assert.assertEquals((String)"Wrong srcMask", (long)0L, (long)match.getNwSrcMask().shortValue());
        Assert.assertEquals((String)"Wrong dstMask", (long)0L, (long)match.getNwDstMask().shortValue());
        Assert.assertEquals((String)"Wrong in-port", (long)32L, (long)match.getInPort().intValue());
        Assert.assertEquals((String)"Wrong dl-src", (Object)new MacAddress("aa:bb:cc:dd:ee:ff"), (Object)match.getDlSrc());
        Assert.assertEquals((String)"Wrong dl-dst", (Object)new MacAddress("aa:bb:cc:dd:ee:ff"), (Object)match.getDlDst());
        Assert.assertEquals((String)"Wrong dl-vlan", (long)5L, (long)match.getDlVlan().intValue());
        Assert.assertEquals((String)"Wrong dl-vlan-pcp", (long)16L, (long)match.getDlVlanPcp().shortValue());
        Assert.assertEquals((String)"Wrong dl-type", (long)8L, (long)match.getDlType().intValue());
        Assert.assertEquals((String)"Wrong nw-tos", (long)7L, (long)match.getNwTos().shortValue());
        Assert.assertEquals((String)"Wrong nw-proto", (long)6L, (long)match.getNwProto().shortValue());
        Assert.assertEquals((String)"Wrong nw-src", (Object)new Ipv4Address("16.17.18.19"), (Object)match.getNwSrc());
        Assert.assertEquals((String)"Wrong nw-dst", (Object)new Ipv4Address("1.2.3.4"), (Object)match.getNwDst());
        Assert.assertEquals((String)"Wrong tp-src", (long)20560L, (long)match.getTpSrc().shortValue());
        Assert.assertEquals((String)"Wrong tp-dst", (long)8224L, (long)match.getTpDst().shortValue());
    }
}

