/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10Builder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10MatchSerializerTest {
    private SerializerRegistry registry;
    private OFSerializer<MatchV10> matchSerializer;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.matchSerializer = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(1, MatchV10.class));
    }

    @Test
    public void test() {
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        MatchV10Builder builder = new MatchV10Builder();
        builder.setWildcards(new FlowWildcardsV10(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
        builder.setNwSrcMask(Short.valueOf((short)24));
        builder.setNwDstMask(Short.valueOf((short)16));
        builder.setInPort(Integer.valueOf(6653));
        builder.setDlSrc(new MacAddress("01:01:01:01:01:01"));
        builder.setDlDst(new MacAddress("02:02:02:02:02:02"));
        builder.setDlVlan(Integer.valueOf(128));
        builder.setDlVlanPcp(Short.valueOf((short)2));
        builder.setDlType(Integer.valueOf(15));
        builder.setNwTos(Short.valueOf((short)14));
        builder.setNwProto(Short.valueOf((short)85));
        builder.setNwSrc(new Ipv4Address("1.1.1.2"));
        builder.setNwDst(new Ipv4Address("32.16.8.1"));
        builder.setTpSrc(Integer.valueOf(2048));
        builder.setTpDst(Integer.valueOf(4096));
        MatchV10 match = builder.build();
        this.matchSerializer.serialize((DataContainer)match, out);
        Assert.assertEquals((String)"Wrong wildcards", (long)2361553L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong in-port", (long)6653L, (long)out.readUnsignedShort());
        byte[] dlSrc = new byte[6];
        out.readBytes(dlSrc);
        Assert.assertEquals((String)"Wrong dl-src", (Object)"01:01:01:01:01:01", (Object)ByteBufUtils.macAddressToString((byte[])dlSrc));
        byte[] dlDst = new byte[6];
        out.readBytes(dlDst);
        Assert.assertEquals((String)"Wrong dl-dst", (Object)"02:02:02:02:02:02", (Object)ByteBufUtils.macAddressToString((byte[])dlDst));
        Assert.assertEquals((String)"Wrong dl-vlan", (long)128L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong dl-vlan-pcp", (long)2L, (long)out.readUnsignedByte());
        out.skipBytes(1);
        Assert.assertEquals((String)"Wrong dl-type", (long)15L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong nw-tos", (long)14L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong nw-proto", (long)85L, (long)out.readUnsignedByte());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong nw-src", (long)0x1010102L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong nw-dst", (long)537921537L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong tp-src", (long)2048L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong tp-dst", (long)4096L, (long)out.readUnsignedShort());
    }

    @Test
    public void test2() {
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        MatchV10Builder builder = new MatchV10Builder();
        builder.setWildcards(new FlowWildcardsV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
        builder.setNwSrcMask(Short.valueOf((short)0));
        builder.setNwDstMask(Short.valueOf((short)0));
        builder.setInPort(Integer.valueOf(6653));
        builder.setDlSrc(new MacAddress("01:01:01:01:01:01"));
        builder.setDlDst(new MacAddress("02:02:02:02:02:02"));
        builder.setDlVlan(Integer.valueOf(128));
        builder.setDlVlanPcp(Short.valueOf((short)2));
        builder.setDlType(Integer.valueOf(15));
        builder.setNwTos(Short.valueOf((short)14));
        builder.setNwProto(Short.valueOf((short)85));
        builder.setNwSrc(new Ipv4Address("1.1.1.2"));
        builder.setNwDst(new Ipv4Address("32.16.8.1"));
        builder.setTpSrc(Integer.valueOf(2048));
        builder.setTpDst(Integer.valueOf(4096));
        MatchV10 match = builder.build();
        this.matchSerializer.serialize((DataContainer)match, out);
        Assert.assertEquals((String)"Wrong wildcards", (long)3678463L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong in-port", (long)6653L, (long)out.readUnsignedShort());
        byte[] dlSrc = new byte[6];
        out.readBytes(dlSrc);
        Assert.assertEquals((String)"Wrong dl-src", (Object)"01:01:01:01:01:01", (Object)ByteBufUtils.macAddressToString((byte[])dlSrc));
        byte[] dlDst = new byte[6];
        out.readBytes(dlDst);
        Assert.assertEquals((String)"Wrong dl-dst", (Object)"02:02:02:02:02:02", (Object)ByteBufUtils.macAddressToString((byte[])dlDst));
        Assert.assertEquals((String)"Wrong dl-vlan", (long)128L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong dl-vlan-pcp", (long)2L, (long)out.readUnsignedByte());
        out.skipBytes(1);
        Assert.assertEquals((String)"Wrong dl-type", (long)15L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong nw-tos", (long)14L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong nw-proto", (long)85L, (long)out.readUnsignedByte());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong nw-src", (long)0x1010102L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong nw-dst", (long)537921537L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong tp-src", (long)2048L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong tp-dst", (long)4096L, (long)out.readUnsignedShort());
    }
}

